// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A legal hold is an administrative tool that helps prevent backups from being deleted while under a hold. While the hold is in place, backups under a hold cannot be deleted and lifecycle policies that would alter the backup status (such as transition to cold storage) are delayed until the legal hold is removed. A backup can have more than one legal hold. Legal holds are applied to one or more backups (also known as recovery points). These backups can be filtered by resource types and by resource IDs.
 */
public class LegalHold private constructor(builder: Builder) {
    /**
     * This is the time in number format when legal hold was cancelled.
     */
    public val cancellationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.cancellationDate
    /**
     * This is the time in number format when legal hold was created.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * This is the description of a legal hold.
     */
    public val description: kotlin.String? = builder.description
    /**
     * This is an Amazon Resource Number (ARN) that uniquely identifies the legal hold; for example, `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
     */
    public val legalHoldArn: kotlin.String? = builder.legalHoldArn
    /**
     * ID of specific legal hold on one or more recovery points.
     */
    public val legalHoldId: kotlin.String? = builder.legalHoldId
    /**
     * This is the status of the legal hold. Statuses can be `ACTIVE`, `CREATING`, `CANCELED`, and `CANCELING`.
     */
    public val status: aws.sdk.kotlin.services.backup.model.LegalHoldStatus? = builder.status
    /**
     * This is the title of a legal hold.
     */
    public val title: kotlin.String? = builder.title

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.LegalHold = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LegalHold(")
        append("cancellationDate=$cancellationDate,")
        append("creationDate=$creationDate,")
        append("description=$description,")
        append("legalHoldArn=$legalHoldArn,")
        append("legalHoldId=$legalHoldId,")
        append("status=$status,")
        append("title=$title")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cancellationDate?.hashCode() ?: 0
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (legalHoldArn?.hashCode() ?: 0)
        result = 31 * result + (legalHoldId?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (title?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LegalHold

        if (cancellationDate != other.cancellationDate) return false
        if (creationDate != other.creationDate) return false
        if (description != other.description) return false
        if (legalHoldArn != other.legalHoldArn) return false
        if (legalHoldId != other.legalHoldId) return false
        if (status != other.status) return false
        if (title != other.title) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.LegalHold = Builder(this).apply(block).build()

    public class Builder {
        /**
         * This is the time in number format when legal hold was cancelled.
         */
        public var cancellationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * This is the time in number format when legal hold was created.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * This is the description of a legal hold.
         */
        public var description: kotlin.String? = null
        /**
         * This is an Amazon Resource Number (ARN) that uniquely identifies the legal hold; for example, `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
         */
        public var legalHoldArn: kotlin.String? = null
        /**
         * ID of specific legal hold on one or more recovery points.
         */
        public var legalHoldId: kotlin.String? = null
        /**
         * This is the status of the legal hold. Statuses can be `ACTIVE`, `CREATING`, `CANCELED`, and `CANCELING`.
         */
        public var status: aws.sdk.kotlin.services.backup.model.LegalHoldStatus? = null
        /**
         * This is the title of a legal hold.
         */
        public var title: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.LegalHold) : this() {
            this.cancellationDate = x.cancellationDate
            this.creationDate = x.creationDate
            this.description = x.description
            this.legalHoldArn = x.legalHoldArn
            this.legalHoldId = x.legalHoldId
            this.status = x.status
            this.title = x.title
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.LegalHold = LegalHold(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
