// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.serde

import aws.sdk.kotlin.services.backup.model.FrameworkControl
import aws.sdk.kotlin.services.backup.model.UpdateFrameworkRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateFrameworkOperationSerializer: HttpSerialize<UpdateFrameworkRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateFrameworkRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            requireNotNull(input.frameworkName) { "frameworkName is bound to the URI and must not be null" }
            val pathSegments = listOf<String>(
                "audit",
                "frameworks",
                "${input.frameworkName}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateFrameworkOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateFrameworkOperationBody(context: ExecutionContext, input: UpdateFrameworkRequest): ByteArray {
    val serializer = JsonSerializer()
    val FRAMEWORKCONTROLS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("FrameworkControls"))
    val FRAMEWORKDESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("FrameworkDescription"))
    val IDEMPOTENCYTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("IdempotencyToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FRAMEWORKCONTROLS_DESCRIPTOR)
        field(FRAMEWORKDESCRIPTION_DESCRIPTOR)
        field(IDEMPOTENCYTOKEN_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.frameworkControls != null) {
            listField(FRAMEWORKCONTROLS_DESCRIPTOR) {
                for (el0 in input.frameworkControls) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeFrameworkControlDocument))
                }
            }
        }
        input.frameworkDescription?.let { field(FRAMEWORKDESCRIPTION_DESCRIPTOR, it) }
        input.idempotencyToken?.let { field(IDEMPOTENCYTOKEN_DESCRIPTOR, it) } ?: field(IDEMPOTENCYTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
    }
    return serializer.toByteArray()
}
