// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.serde

import aws.sdk.kotlin.services.backup.model.ListRecoveryPointsByBackupVaultRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.net.parameters
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class ListRecoveryPointsByBackupVaultOperationSerializer: HttpSerialize<ListRecoveryPointsByBackupVaultRequest> {
    override suspend fun serialize(context: ExecutionContext, input: ListRecoveryPointsByBackupVaultRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.GET

        builder.url {
            requireNotNull(input.backupVaultName) { "backupVaultName is bound to the URI and must not be null" }
            val pathSegments = listOf<String>(
                "backup-vaults",
                "${input.backupVaultName}".encodeLabel(),
                "recovery-points",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
            parameters {
                if (input.backupVaultAccountId != null) append("backupVaultAccountId", input.backupVaultAccountId)
                if (input.byBackupPlanId != null) append("backupPlanId", input.byBackupPlanId)
                if (input.byCreatedAfter != null) append("createdAfter", input.byCreatedAfter.format(TimestampFormat.ISO_8601))
                if (input.byCreatedBefore != null) append("createdBefore", input.byCreatedBefore.format(TimestampFormat.ISO_8601))
                if (input.byParentRecoveryPointArn != null) append("parentRecoveryPointArn", input.byParentRecoveryPointArn)
                if (input.byResourceArn != null) append("resourceArn", input.byResourceArn)
                if (input.byResourceType != null) append("resourceType", input.byResourceType)
                if (input.maxResults != null) append("maxResults", "${input.maxResults}")
                if (input.nextToken != null) append("nextToken", input.nextToken)
            }
        }

        return builder
    }
}
