// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.serde

import aws.sdk.kotlin.services.backup.model.BackupException
import aws.sdk.kotlin.services.backup.model.DescribeBackupVaultResponse
import aws.sdk.kotlin.services.backup.model.VaultType
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant


internal class DescribeBackupVaultOperationDeserializer: HttpDeserialize<DescribeBackupVaultResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): DescribeBackupVaultResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeBackupVaultError(context, call)
        }
        val builder = DescribeBackupVaultResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeBackupVaultOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwDescribeBackupVaultError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw BackupException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "MissingParameterValueException" -> MissingParameterValueExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedCall)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedCall)
        else -> BackupException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeBackupVaultOperationBody(builder: DescribeBackupVaultResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BACKUPVAULTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BackupVaultArn"))
    val BACKUPVAULTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BackupVaultName"))
    val CREATIONDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("CreationDate"))
    val CREATORREQUESTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("CreatorRequestId"))
    val ENCRYPTIONKEYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EncryptionKeyArn"))
    val LOCKDATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("LockDate"))
    val LOCKED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("Locked"))
    val MAXRETENTIONDAYS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("MaxRetentionDays"))
    val MINRETENTIONDAYS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("MinRetentionDays"))
    val NUMBEROFRECOVERYPOINTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("NumberOfRecoveryPoints"))
    val VAULTTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("VaultType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BACKUPVAULTARN_DESCRIPTOR)
        field(BACKUPVAULTNAME_DESCRIPTOR)
        field(CREATIONDATE_DESCRIPTOR)
        field(CREATORREQUESTID_DESCRIPTOR)
        field(ENCRYPTIONKEYARN_DESCRIPTOR)
        field(LOCKDATE_DESCRIPTOR)
        field(LOCKED_DESCRIPTOR)
        field(MAXRETENTIONDAYS_DESCRIPTOR)
        field(MINRETENTIONDAYS_DESCRIPTOR)
        field(NUMBEROFRECOVERYPOINTS_DESCRIPTOR)
        field(VAULTTYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BACKUPVAULTARN_DESCRIPTOR.index -> builder.backupVaultArn = deserializeString()
                BACKUPVAULTNAME_DESCRIPTOR.index -> builder.backupVaultName = deserializeString()
                CREATIONDATE_DESCRIPTOR.index -> builder.creationDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                CREATORREQUESTID_DESCRIPTOR.index -> builder.creatorRequestId = deserializeString()
                ENCRYPTIONKEYARN_DESCRIPTOR.index -> builder.encryptionKeyArn = deserializeString()
                LOCKDATE_DESCRIPTOR.index -> builder.lockDate = deserializeString().let { Instant.fromEpochSeconds(it) }
                LOCKED_DESCRIPTOR.index -> builder.locked = deserializeBoolean()
                MAXRETENTIONDAYS_DESCRIPTOR.index -> builder.maxRetentionDays = deserializeLong()
                MINRETENTIONDAYS_DESCRIPTOR.index -> builder.minRetentionDays = deserializeLong()
                NUMBEROFRECOVERYPOINTS_DESCRIPTOR.index -> builder.numberOfRecoveryPoints = deserializeLong()
                VAULTTYPE_DESCRIPTOR.index -> builder.vaultType = deserializeString().let { VaultType.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
