// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.backup.auth.BackupAuthSchemeProvider
import aws.sdk.kotlin.services.backup.auth.DefaultBackupAuthSchemeProvider
import aws.sdk.kotlin.services.backup.endpoints.BackupEndpointParameters
import aws.sdk.kotlin.services.backup.endpoints.BackupEndpointProvider
import aws.sdk.kotlin.services.backup.endpoints.DefaultBackupEndpointProvider
import aws.sdk.kotlin.services.backup.model.CancelLegalHoldRequest
import aws.sdk.kotlin.services.backup.model.CancelLegalHoldResponse
import aws.sdk.kotlin.services.backup.model.CreateBackupPlanRequest
import aws.sdk.kotlin.services.backup.model.CreateBackupPlanResponse
import aws.sdk.kotlin.services.backup.model.CreateBackupSelectionRequest
import aws.sdk.kotlin.services.backup.model.CreateBackupSelectionResponse
import aws.sdk.kotlin.services.backup.model.CreateBackupVaultRequest
import aws.sdk.kotlin.services.backup.model.CreateBackupVaultResponse
import aws.sdk.kotlin.services.backup.model.CreateFrameworkRequest
import aws.sdk.kotlin.services.backup.model.CreateFrameworkResponse
import aws.sdk.kotlin.services.backup.model.CreateLegalHoldRequest
import aws.sdk.kotlin.services.backup.model.CreateLegalHoldResponse
import aws.sdk.kotlin.services.backup.model.CreateLogicallyAirGappedBackupVaultRequest
import aws.sdk.kotlin.services.backup.model.CreateLogicallyAirGappedBackupVaultResponse
import aws.sdk.kotlin.services.backup.model.CreateReportPlanRequest
import aws.sdk.kotlin.services.backup.model.CreateReportPlanResponse
import aws.sdk.kotlin.services.backup.model.DeleteBackupPlanRequest
import aws.sdk.kotlin.services.backup.model.DeleteBackupPlanResponse
import aws.sdk.kotlin.services.backup.model.DeleteBackupSelectionRequest
import aws.sdk.kotlin.services.backup.model.DeleteBackupSelectionResponse
import aws.sdk.kotlin.services.backup.model.DeleteBackupVaultAccessPolicyRequest
import aws.sdk.kotlin.services.backup.model.DeleteBackupVaultAccessPolicyResponse
import aws.sdk.kotlin.services.backup.model.DeleteBackupVaultLockConfigurationRequest
import aws.sdk.kotlin.services.backup.model.DeleteBackupVaultLockConfigurationResponse
import aws.sdk.kotlin.services.backup.model.DeleteBackupVaultNotificationsRequest
import aws.sdk.kotlin.services.backup.model.DeleteBackupVaultNotificationsResponse
import aws.sdk.kotlin.services.backup.model.DeleteBackupVaultRequest
import aws.sdk.kotlin.services.backup.model.DeleteBackupVaultResponse
import aws.sdk.kotlin.services.backup.model.DeleteFrameworkRequest
import aws.sdk.kotlin.services.backup.model.DeleteFrameworkResponse
import aws.sdk.kotlin.services.backup.model.DeleteRecoveryPointRequest
import aws.sdk.kotlin.services.backup.model.DeleteRecoveryPointResponse
import aws.sdk.kotlin.services.backup.model.DeleteReportPlanRequest
import aws.sdk.kotlin.services.backup.model.DeleteReportPlanResponse
import aws.sdk.kotlin.services.backup.model.DescribeBackupJobRequest
import aws.sdk.kotlin.services.backup.model.DescribeBackupJobResponse
import aws.sdk.kotlin.services.backup.model.DescribeBackupVaultRequest
import aws.sdk.kotlin.services.backup.model.DescribeBackupVaultResponse
import aws.sdk.kotlin.services.backup.model.DescribeCopyJobRequest
import aws.sdk.kotlin.services.backup.model.DescribeCopyJobResponse
import aws.sdk.kotlin.services.backup.model.DescribeFrameworkRequest
import aws.sdk.kotlin.services.backup.model.DescribeFrameworkResponse
import aws.sdk.kotlin.services.backup.model.DescribeGlobalSettingsRequest
import aws.sdk.kotlin.services.backup.model.DescribeGlobalSettingsResponse
import aws.sdk.kotlin.services.backup.model.DescribeProtectedResourceRequest
import aws.sdk.kotlin.services.backup.model.DescribeProtectedResourceResponse
import aws.sdk.kotlin.services.backup.model.DescribeRecoveryPointRequest
import aws.sdk.kotlin.services.backup.model.DescribeRecoveryPointResponse
import aws.sdk.kotlin.services.backup.model.DescribeRegionSettingsRequest
import aws.sdk.kotlin.services.backup.model.DescribeRegionSettingsResponse
import aws.sdk.kotlin.services.backup.model.DescribeReportJobRequest
import aws.sdk.kotlin.services.backup.model.DescribeReportJobResponse
import aws.sdk.kotlin.services.backup.model.DescribeReportPlanRequest
import aws.sdk.kotlin.services.backup.model.DescribeReportPlanResponse
import aws.sdk.kotlin.services.backup.model.DescribeRestoreJobRequest
import aws.sdk.kotlin.services.backup.model.DescribeRestoreJobResponse
import aws.sdk.kotlin.services.backup.model.DisassociateRecoveryPointFromParentRequest
import aws.sdk.kotlin.services.backup.model.DisassociateRecoveryPointFromParentResponse
import aws.sdk.kotlin.services.backup.model.DisassociateRecoveryPointRequest
import aws.sdk.kotlin.services.backup.model.DisassociateRecoveryPointResponse
import aws.sdk.kotlin.services.backup.model.ExportBackupPlanTemplateRequest
import aws.sdk.kotlin.services.backup.model.ExportBackupPlanTemplateResponse
import aws.sdk.kotlin.services.backup.model.GetBackupPlanFromJsonRequest
import aws.sdk.kotlin.services.backup.model.GetBackupPlanFromJsonResponse
import aws.sdk.kotlin.services.backup.model.GetBackupPlanFromTemplateRequest
import aws.sdk.kotlin.services.backup.model.GetBackupPlanFromTemplateResponse
import aws.sdk.kotlin.services.backup.model.GetBackupPlanRequest
import aws.sdk.kotlin.services.backup.model.GetBackupPlanResponse
import aws.sdk.kotlin.services.backup.model.GetBackupSelectionRequest
import aws.sdk.kotlin.services.backup.model.GetBackupSelectionResponse
import aws.sdk.kotlin.services.backup.model.GetBackupVaultAccessPolicyRequest
import aws.sdk.kotlin.services.backup.model.GetBackupVaultAccessPolicyResponse
import aws.sdk.kotlin.services.backup.model.GetBackupVaultNotificationsRequest
import aws.sdk.kotlin.services.backup.model.GetBackupVaultNotificationsResponse
import aws.sdk.kotlin.services.backup.model.GetLegalHoldRequest
import aws.sdk.kotlin.services.backup.model.GetLegalHoldResponse
import aws.sdk.kotlin.services.backup.model.GetRecoveryPointRestoreMetadataRequest
import aws.sdk.kotlin.services.backup.model.GetRecoveryPointRestoreMetadataResponse
import aws.sdk.kotlin.services.backup.model.GetSupportedResourceTypesRequest
import aws.sdk.kotlin.services.backup.model.GetSupportedResourceTypesResponse
import aws.sdk.kotlin.services.backup.model.ListBackupJobSummariesRequest
import aws.sdk.kotlin.services.backup.model.ListBackupJobSummariesResponse
import aws.sdk.kotlin.services.backup.model.ListBackupJobsRequest
import aws.sdk.kotlin.services.backup.model.ListBackupJobsResponse
import aws.sdk.kotlin.services.backup.model.ListBackupPlanTemplatesRequest
import aws.sdk.kotlin.services.backup.model.ListBackupPlanTemplatesResponse
import aws.sdk.kotlin.services.backup.model.ListBackupPlanVersionsRequest
import aws.sdk.kotlin.services.backup.model.ListBackupPlanVersionsResponse
import aws.sdk.kotlin.services.backup.model.ListBackupPlansRequest
import aws.sdk.kotlin.services.backup.model.ListBackupPlansResponse
import aws.sdk.kotlin.services.backup.model.ListBackupSelectionsRequest
import aws.sdk.kotlin.services.backup.model.ListBackupSelectionsResponse
import aws.sdk.kotlin.services.backup.model.ListBackupVaultsRequest
import aws.sdk.kotlin.services.backup.model.ListBackupVaultsResponse
import aws.sdk.kotlin.services.backup.model.ListCopyJobSummariesRequest
import aws.sdk.kotlin.services.backup.model.ListCopyJobSummariesResponse
import aws.sdk.kotlin.services.backup.model.ListCopyJobsRequest
import aws.sdk.kotlin.services.backup.model.ListCopyJobsResponse
import aws.sdk.kotlin.services.backup.model.ListFrameworksRequest
import aws.sdk.kotlin.services.backup.model.ListFrameworksResponse
import aws.sdk.kotlin.services.backup.model.ListLegalHoldsRequest
import aws.sdk.kotlin.services.backup.model.ListLegalHoldsResponse
import aws.sdk.kotlin.services.backup.model.ListProtectedResourcesByBackupVaultRequest
import aws.sdk.kotlin.services.backup.model.ListProtectedResourcesByBackupVaultResponse
import aws.sdk.kotlin.services.backup.model.ListProtectedResourcesRequest
import aws.sdk.kotlin.services.backup.model.ListProtectedResourcesResponse
import aws.sdk.kotlin.services.backup.model.ListRecoveryPointsByBackupVaultRequest
import aws.sdk.kotlin.services.backup.model.ListRecoveryPointsByBackupVaultResponse
import aws.sdk.kotlin.services.backup.model.ListRecoveryPointsByLegalHoldRequest
import aws.sdk.kotlin.services.backup.model.ListRecoveryPointsByLegalHoldResponse
import aws.sdk.kotlin.services.backup.model.ListRecoveryPointsByResourceRequest
import aws.sdk.kotlin.services.backup.model.ListRecoveryPointsByResourceResponse
import aws.sdk.kotlin.services.backup.model.ListReportJobsRequest
import aws.sdk.kotlin.services.backup.model.ListReportJobsResponse
import aws.sdk.kotlin.services.backup.model.ListReportPlansRequest
import aws.sdk.kotlin.services.backup.model.ListReportPlansResponse
import aws.sdk.kotlin.services.backup.model.ListRestoreJobSummariesRequest
import aws.sdk.kotlin.services.backup.model.ListRestoreJobSummariesResponse
import aws.sdk.kotlin.services.backup.model.ListRestoreJobsRequest
import aws.sdk.kotlin.services.backup.model.ListRestoreJobsResponse
import aws.sdk.kotlin.services.backup.model.ListTagsRequest
import aws.sdk.kotlin.services.backup.model.ListTagsResponse
import aws.sdk.kotlin.services.backup.model.PutBackupVaultAccessPolicyRequest
import aws.sdk.kotlin.services.backup.model.PutBackupVaultAccessPolicyResponse
import aws.sdk.kotlin.services.backup.model.PutBackupVaultLockConfigurationRequest
import aws.sdk.kotlin.services.backup.model.PutBackupVaultLockConfigurationResponse
import aws.sdk.kotlin.services.backup.model.PutBackupVaultNotificationsRequest
import aws.sdk.kotlin.services.backup.model.PutBackupVaultNotificationsResponse
import aws.sdk.kotlin.services.backup.model.StartBackupJobRequest
import aws.sdk.kotlin.services.backup.model.StartBackupJobResponse
import aws.sdk.kotlin.services.backup.model.StartCopyJobRequest
import aws.sdk.kotlin.services.backup.model.StartCopyJobResponse
import aws.sdk.kotlin.services.backup.model.StartReportJobRequest
import aws.sdk.kotlin.services.backup.model.StartReportJobResponse
import aws.sdk.kotlin.services.backup.model.StartRestoreJobRequest
import aws.sdk.kotlin.services.backup.model.StartRestoreJobResponse
import aws.sdk.kotlin.services.backup.model.StopBackupJobRequest
import aws.sdk.kotlin.services.backup.model.StopBackupJobResponse
import aws.sdk.kotlin.services.backup.model.TagResourceRequest
import aws.sdk.kotlin.services.backup.model.TagResourceResponse
import aws.sdk.kotlin.services.backup.model.UntagResourceRequest
import aws.sdk.kotlin.services.backup.model.UntagResourceResponse
import aws.sdk.kotlin.services.backup.model.UpdateBackupPlanRequest
import aws.sdk.kotlin.services.backup.model.UpdateBackupPlanResponse
import aws.sdk.kotlin.services.backup.model.UpdateFrameworkRequest
import aws.sdk.kotlin.services.backup.model.UpdateFrameworkResponse
import aws.sdk.kotlin.services.backup.model.UpdateGlobalSettingsRequest
import aws.sdk.kotlin.services.backup.model.UpdateGlobalSettingsResponse
import aws.sdk.kotlin.services.backup.model.UpdateRecoveryPointLifecycleRequest
import aws.sdk.kotlin.services.backup.model.UpdateRecoveryPointLifecycleResponse
import aws.sdk.kotlin.services.backup.model.UpdateRegionSettingsRequest
import aws.sdk.kotlin.services.backup.model.UpdateRegionSettingsResponse
import aws.sdk.kotlin.services.backup.model.UpdateReportPlanRequest
import aws.sdk.kotlin.services.backup.model.UpdateReportPlanResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Backup"
public const val SdkVersion: String = "0.36.1-beta"

/**
 * # Backup
 * Backup is a unified backup service designed to protect Amazon Web Services services and their associated data. Backup simplifies the creation, migration, restoration, and deletion of backups, while also providing reporting and auditing.
 */
public interface BackupClient : SdkClient {
    /**
     * BackupClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, BackupClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Backup",
                "BACKUP",
                "backup",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, BackupClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): BackupClient = DefaultBackupClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: BackupEndpointProvider = builder.endpointProvider ?: DefaultBackupEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: BackupAuthSchemeProvider = builder.authSchemeProvider ?: DefaultBackupAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Backup"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: BackupEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: BackupAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * This action removes the specified legal hold on a recovery point. This action can only be performed by a user with sufficient permissions.
     */
    public suspend fun cancelLegalHold(input: CancelLegalHoldRequest): CancelLegalHoldResponse

    /**
     * Creates a backup plan using a backup plan name and backup rules. A backup plan is a document that contains information that Backup uses to schedule tasks that create recovery points for resources.
     *
     * If you call `CreateBackupPlan` with a plan that already exists, you receive an `AlreadyExistsException` exception.
     */
    public suspend fun createBackupPlan(input: CreateBackupPlanRequest): CreateBackupPlanResponse

    /**
     * Creates a JSON document that specifies a set of resources to assign to a backup plan. For examples, see [Assigning resources programmatically](https://docs.aws.amazon.com/aws-backup/latest/devguide/assigning-resources.html#assigning-resources-json).
     */
    public suspend fun createBackupSelection(input: CreateBackupSelectionRequest): CreateBackupSelectionResponse

    /**
     * Creates a logical container where backups are stored. A `CreateBackupVault` request includes a name, optionally one or more resource tags, an encryption key, and a request ID.
     *
     * Do not include sensitive data, such as passport numbers, in the name of a backup vault.
     */
    public suspend fun createBackupVault(input: CreateBackupVaultRequest): CreateBackupVaultResponse

    /**
     * Creates a framework with one or more controls. A framework is a collection of controls that you can use to evaluate your backup practices. By using pre-built customizable controls to define your policies, you can evaluate whether your backup practices comply with your policies and which resources are not yet in compliance.
     */
    public suspend fun createFramework(input: CreateFrameworkRequest): CreateFrameworkResponse

    /**
     * This action creates a legal hold on a recovery point (backup). A legal hold is a restraint on altering or deleting a backup until an authorized user cancels the legal hold. Any actions to delete or disassociate a recovery point will fail with an error if one or more active legal holds are on the recovery point.
     */
    public suspend fun createLegalHold(input: CreateLegalHoldRequest): CreateLegalHoldResponse

    /**
     * This request creates a logical container to where backups may be copied.
     *
     * This request includes a name, the Region, the maximum number of retention days, the minimum number of retention days, and optionally can include tags and a creator request ID.
     *
     * Do not include sensitive data, such as passport numbers, in the name of a backup vault.
     */
    public suspend fun createLogicallyAirGappedBackupVault(input: CreateLogicallyAirGappedBackupVaultRequest): CreateLogicallyAirGappedBackupVaultResponse

    /**
     * Creates a report plan. A report plan is a document that contains information about the contents of the report and where Backup will deliver it.
     *
     * If you call `CreateReportPlan` with a plan that already exists, you receive an `AlreadyExistsException` exception.
     */
    public suspend fun createReportPlan(input: CreateReportPlanRequest): CreateReportPlanResponse

    /**
     * Deletes a backup plan. A backup plan can only be deleted after all associated selections of resources have been deleted. Deleting a backup plan deletes the current version of a backup plan. Previous versions, if any, will still exist.
     */
    public suspend fun deleteBackupPlan(input: DeleteBackupPlanRequest): DeleteBackupPlanResponse

    /**
     * Deletes the resource selection associated with a backup plan that is specified by the `SelectionId`.
     */
    public suspend fun deleteBackupSelection(input: DeleteBackupSelectionRequest): DeleteBackupSelectionResponse

    /**
     * Deletes the backup vault identified by its name. A vault can be deleted only if it is empty.
     */
    public suspend fun deleteBackupVault(input: DeleteBackupVaultRequest): DeleteBackupVaultResponse

    /**
     * Deletes the policy document that manages permissions on a backup vault.
     */
    public suspend fun deleteBackupVaultAccessPolicy(input: DeleteBackupVaultAccessPolicyRequest): DeleteBackupVaultAccessPolicyResponse

    /**
     * Deletes Backup Vault Lock from a backup vault specified by a backup vault name.
     *
     * If the Vault Lock configuration is immutable, then you cannot delete Vault Lock using API operations, and you will receive an `InvalidRequestException` if you attempt to do so. For more information, see [Vault Lock](https://docs.aws.amazon.com/aws-backup/latest/devguide/vault-lock.html) in the *Backup Developer Guide*.
     */
    public suspend fun deleteBackupVaultLockConfiguration(input: DeleteBackupVaultLockConfigurationRequest): DeleteBackupVaultLockConfigurationResponse

    /**
     * Deletes event notifications for the specified backup vault.
     */
    public suspend fun deleteBackupVaultNotifications(input: DeleteBackupVaultNotificationsRequest): DeleteBackupVaultNotificationsResponse

    /**
     * Deletes the framework specified by a framework name.
     */
    public suspend fun deleteFramework(input: DeleteFrameworkRequest): DeleteFrameworkResponse

    /**
     * Deletes the recovery point specified by a recovery point ID.
     *
     * If the recovery point ID belongs to a continuous backup, calling this endpoint deletes the existing continuous backup and stops future continuous backup.
     *
     * When an IAM role's permissions are insufficient to call this API, the service sends back an HTTP 200 response with an empty HTTP body, but the recovery point is not deleted. Instead, it enters an `EXPIRED` state.
     *
     * `EXPIRED` recovery points can be deleted with this API once the IAM role has the `iam:CreateServiceLinkedRole` action. To learn more about adding this role, see [ Troubleshooting manual deletions](https://docs.aws.amazon.com/aws-backup/latest/devguide/deleting-backups.html#deleting-backups-troubleshooting).
     *
     * If the user or role is deleted or the permission within the role is removed, the deletion will not be successful and will enter an `EXPIRED` state.
     */
    public suspend fun deleteRecoveryPoint(input: DeleteRecoveryPointRequest): DeleteRecoveryPointResponse

    /**
     * Deletes the report plan specified by a report plan name.
     */
    public suspend fun deleteReportPlan(input: DeleteReportPlanRequest): DeleteReportPlanResponse

    /**
     * Returns backup job details for the specified `BackupJobId`.
     */
    public suspend fun describeBackupJob(input: DescribeBackupJobRequest): DescribeBackupJobResponse

    /**
     * Returns metadata about a backup vault specified by its name.
     */
    public suspend fun describeBackupVault(input: DescribeBackupVaultRequest): DescribeBackupVaultResponse

    /**
     * Returns metadata associated with creating a copy of a resource.
     */
    public suspend fun describeCopyJob(input: DescribeCopyJobRequest): DescribeCopyJobResponse

    /**
     * Returns the framework details for the specified `FrameworkName`.
     */
    public suspend fun describeFramework(input: DescribeFrameworkRequest): DescribeFrameworkResponse

    /**
     * Describes whether the Amazon Web Services account is opted in to cross-account backup. Returns an error if the account is not a member of an Organizations organization. Example: `describe-global-settings --region us-west-2`
     */
    public suspend fun describeGlobalSettings(input: DescribeGlobalSettingsRequest = DescribeGlobalSettingsRequest { }): DescribeGlobalSettingsResponse

    /**
     * Returns information about a saved resource, including the last time it was backed up, its Amazon Resource Name (ARN), and the Amazon Web Services service type of the saved resource.
     */
    public suspend fun describeProtectedResource(input: DescribeProtectedResourceRequest): DescribeProtectedResourceResponse

    /**
     * Returns metadata associated with a recovery point, including ID, status, encryption, and lifecycle.
     */
    public suspend fun describeRecoveryPoint(input: DescribeRecoveryPointRequest): DescribeRecoveryPointResponse

    /**
     * Returns the current service opt-in settings for the Region. If service opt-in is enabled for a service, Backup tries to protect that service's resources in this Region, when the resource is included in an on-demand backup or scheduled backup plan. Otherwise, Backup does not try to protect that service's resources in this Region.
     */
    public suspend fun describeRegionSettings(input: DescribeRegionSettingsRequest = DescribeRegionSettingsRequest { }): DescribeRegionSettingsResponse

    /**
     * Returns the details associated with creating a report as specified by its `ReportJobId`.
     */
    public suspend fun describeReportJob(input: DescribeReportJobRequest): DescribeReportJobResponse

    /**
     * Returns a list of all report plans for an Amazon Web Services account and Amazon Web Services Region.
     */
    public suspend fun describeReportPlan(input: DescribeReportPlanRequest): DescribeReportPlanResponse

    /**
     * Returns metadata associated with a restore job that is specified by a job ID.
     */
    public suspend fun describeRestoreJob(input: DescribeRestoreJobRequest): DescribeRestoreJobResponse

    /**
     * Deletes the specified continuous backup recovery point from Backup and releases control of that continuous backup to the source service, such as Amazon RDS. The source service will continue to create and retain continuous backups using the lifecycle that you specified in your original backup plan.
     *
     * Does not support snapshot backup recovery points.
     */
    public suspend fun disassociateRecoveryPoint(input: DisassociateRecoveryPointRequest): DisassociateRecoveryPointResponse

    /**
     * This action to a specific child (nested) recovery point removes the relationship between the specified recovery point and its parent (composite) recovery point.
     */
    public suspend fun disassociateRecoveryPointFromParent(input: DisassociateRecoveryPointFromParentRequest): DisassociateRecoveryPointFromParentResponse

    /**
     * Returns the backup plan that is specified by the plan ID as a backup template.
     */
    public suspend fun exportBackupPlanTemplate(input: ExportBackupPlanTemplateRequest): ExportBackupPlanTemplateResponse

    /**
     * Returns `BackupPlan` details for the specified `BackupPlanId`. The details are the body of a backup plan in JSON format, in addition to plan metadata.
     */
    public suspend fun getBackupPlan(input: GetBackupPlanRequest): GetBackupPlanResponse

    /**
     * Returns a valid JSON document specifying a backup plan or an error.
     */
    public suspend fun getBackupPlanFromJson(input: GetBackupPlanFromJsonRequest): GetBackupPlanFromJsonResponse

    /**
     * Returns the template specified by its `templateId` as a backup plan.
     */
    public suspend fun getBackupPlanFromTemplate(input: GetBackupPlanFromTemplateRequest): GetBackupPlanFromTemplateResponse

    /**
     * Returns selection metadata and a document in JSON format that specifies a list of resources that are associated with a backup plan.
     */
    public suspend fun getBackupSelection(input: GetBackupSelectionRequest): GetBackupSelectionResponse

    /**
     * Returns the access policy document that is associated with the named backup vault.
     */
    public suspend fun getBackupVaultAccessPolicy(input: GetBackupVaultAccessPolicyRequest): GetBackupVaultAccessPolicyResponse

    /**
     * Returns event notifications for the specified backup vault.
     */
    public suspend fun getBackupVaultNotifications(input: GetBackupVaultNotificationsRequest): GetBackupVaultNotificationsResponse

    /**
     * This action returns details for a specified legal hold. The details are the body of a legal hold in JSON format, in addition to metadata.
     */
    public suspend fun getLegalHold(input: GetLegalHoldRequest): GetLegalHoldResponse

    /**
     * Returns a set of metadata key-value pairs that were used to create the backup.
     */
    public suspend fun getRecoveryPointRestoreMetadata(input: GetRecoveryPointRestoreMetadataRequest): GetRecoveryPointRestoreMetadataResponse

    /**
     * Returns the Amazon Web Services resource types supported by Backup.
     */
    public suspend fun getSupportedResourceTypes(input: GetSupportedResourceTypesRequest = GetSupportedResourceTypesRequest { }): GetSupportedResourceTypesResponse

    /**
     * This is a request for a summary of backup jobs created or running within the most recent 30 days. You can include parameters AccountID, State, ResourceType, MessageCategory, AggregationPeriod, MaxResults, or NextToken to filter results.
     *
     * This request returns a summary that contains Region, Account, State, ResourceType, MessageCategory, StartTime, EndTime, and Count of included jobs.
     */
    public suspend fun listBackupJobSummaries(input: ListBackupJobSummariesRequest = ListBackupJobSummariesRequest { }): ListBackupJobSummariesResponse

    /**
     * Returns a list of existing backup jobs for an authenticated account for the last 30 days. For a longer period of time, consider using these [monitoring tools](https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html).
     */
    public suspend fun listBackupJobs(input: ListBackupJobsRequest = ListBackupJobsRequest { }): ListBackupJobsResponse

    /**
     * Returns metadata of your saved backup plan templates, including the template ID, name, and the creation and deletion dates.
     */
    public suspend fun listBackupPlanTemplates(input: ListBackupPlanTemplatesRequest = ListBackupPlanTemplatesRequest { }): ListBackupPlanTemplatesResponse

    /**
     * Returns version metadata of your backup plans, including Amazon Resource Names (ARNs), backup plan IDs, creation and deletion dates, plan names, and version IDs.
     */
    public suspend fun listBackupPlanVersions(input: ListBackupPlanVersionsRequest): ListBackupPlanVersionsResponse

    /**
     * Returns a list of all active backup plans for an authenticated account. The list contains information such as Amazon Resource Names (ARNs), plan IDs, creation and deletion dates, version IDs, plan names, and creator request IDs.
     */
    public suspend fun listBackupPlans(input: ListBackupPlansRequest = ListBackupPlansRequest { }): ListBackupPlansResponse

    /**
     * Returns an array containing metadata of the resources associated with the target backup plan.
     */
    public suspend fun listBackupSelections(input: ListBackupSelectionsRequest): ListBackupSelectionsResponse

    /**
     * Returns a list of recovery point storage containers along with information about them.
     */
    public suspend fun listBackupVaults(input: ListBackupVaultsRequest = ListBackupVaultsRequest { }): ListBackupVaultsResponse

    /**
     * This request obtains a list of copy jobs created or running within the the most recent 30 days. You can include parameters AccountID, State, ResourceType, MessageCategory, AggregationPeriod, MaxResults, or NextToken to filter results.
     *
     * This request returns a summary that contains Region, Account, State, RestourceType, MessageCategory, StartTime, EndTime, and Count of included jobs.
     */
    public suspend fun listCopyJobSummaries(input: ListCopyJobSummariesRequest = ListCopyJobSummariesRequest { }): ListCopyJobSummariesResponse

    /**
     * Returns metadata about your copy jobs.
     */
    public suspend fun listCopyJobs(input: ListCopyJobsRequest = ListCopyJobsRequest { }): ListCopyJobsResponse

    /**
     * Returns a list of all frameworks for an Amazon Web Services account and Amazon Web Services Region.
     */
    public suspend fun listFrameworks(input: ListFrameworksRequest = ListFrameworksRequest { }): ListFrameworksResponse

    /**
     * This action returns metadata about active and previous legal holds.
     */
    public suspend fun listLegalHolds(input: ListLegalHoldsRequest = ListLegalHoldsRequest { }): ListLegalHoldsResponse

    /**
     * Returns an array of resources successfully backed up by Backup, including the time the resource was saved, an Amazon Resource Name (ARN) of the resource, and a resource type.
     */
    public suspend fun listProtectedResources(input: ListProtectedResourcesRequest = ListProtectedResourcesRequest { }): ListProtectedResourcesResponse

    /**
     * This request lists the protected resources corresponding to each backup vault.
     */
    public suspend fun listProtectedResourcesByBackupVault(input: ListProtectedResourcesByBackupVaultRequest): ListProtectedResourcesByBackupVaultResponse

    /**
     * Returns detailed information about the recovery points stored in a backup vault.
     */
    public suspend fun listRecoveryPointsByBackupVault(input: ListRecoveryPointsByBackupVaultRequest): ListRecoveryPointsByBackupVaultResponse

    /**
     * This action returns recovery point ARNs (Amazon Resource Names) of the specified legal hold.
     */
    public suspend fun listRecoveryPointsByLegalHold(input: ListRecoveryPointsByLegalHoldRequest): ListRecoveryPointsByLegalHoldResponse

    /**
     * Returns detailed information about all the recovery points of the type specified by a resource Amazon Resource Name (ARN).
     *
     * For Amazon EFS and Amazon EC2, this action only lists recovery points created by Backup.
     */
    public suspend fun listRecoveryPointsByResource(input: ListRecoveryPointsByResourceRequest): ListRecoveryPointsByResourceResponse

    /**
     * Returns details about your report jobs.
     */
    public suspend fun listReportJobs(input: ListReportJobsRequest = ListReportJobsRequest { }): ListReportJobsResponse

    /**
     * Returns a list of your report plans. For detailed information about a single report plan, use `DescribeReportPlan`.
     */
    public suspend fun listReportPlans(input: ListReportPlansRequest = ListReportPlansRequest { }): ListReportPlansResponse

    /**
     * This request obtains a summary of restore jobs created or running within the the most recent 30 days. You can include parameters AccountID, State, ResourceType, AggregationPeriod, MaxResults, or NextToken to filter results.
     *
     * This request returns a summary that contains Region, Account, State, RestourceType, MessageCategory, StartTime, EndTime, and Count of included jobs.
     */
    public suspend fun listRestoreJobSummaries(input: ListRestoreJobSummariesRequest = ListRestoreJobSummariesRequest { }): ListRestoreJobSummariesResponse

    /**
     * Returns a list of jobs that Backup initiated to restore a saved resource, including details about the recovery process.
     */
    public suspend fun listRestoreJobs(input: ListRestoreJobsRequest = ListRestoreJobsRequest { }): ListRestoreJobsResponse

    /**
     * Returns a list of key-value pairs assigned to a target recovery point, backup plan, or backup vault.
     *
     * `ListTags` only works for resource types that support full Backup management of their backups. Those resource types are listed in the "Full Backup management" section of the [ Feature availability by resource](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource) table.
     */
    public suspend fun listTags(input: ListTagsRequest): ListTagsResponse

    /**
     * Sets a resource-based policy that is used to manage access permissions on the target backup vault. Requires a backup vault name and an access policy document in JSON format.
     */
    public suspend fun putBackupVaultAccessPolicy(input: PutBackupVaultAccessPolicyRequest): PutBackupVaultAccessPolicyResponse

    /**
     * Applies Backup Vault Lock to a backup vault, preventing attempts to delete any recovery point stored in or created in a backup vault. Vault Lock also prevents attempts to update the lifecycle policy that controls the retention period of any recovery point currently stored in a backup vault. If specified, Vault Lock enforces a minimum and maximum retention period for future backup and copy jobs that target a backup vault.
     *
     * Backup Vault Lock has been assessed by Cohasset Associates for use in environments that are subject to SEC 17a-4, CFTC, and FINRA regulations. For more information about how Backup Vault Lock relates to these regulations, see the [Cohasset Associates Compliance Assessment.](samples/cohassetreport.zip)
     */
    public suspend fun putBackupVaultLockConfiguration(input: PutBackupVaultLockConfigurationRequest): PutBackupVaultLockConfigurationResponse

    /**
     * Turns on notifications on a backup vault for the specified topic and events.
     */
    public suspend fun putBackupVaultNotifications(input: PutBackupVaultNotificationsRequest): PutBackupVaultNotificationsResponse

    /**
     * Starts an on-demand backup job for the specified resource.
     */
    public suspend fun startBackupJob(input: StartBackupJobRequest): StartBackupJobResponse

    /**
     * Starts a job to create a one-time copy of the specified resource.
     *
     * Does not support continuous backups.
     */
    public suspend fun startCopyJob(input: StartCopyJobRequest): StartCopyJobResponse

    /**
     * Starts an on-demand report job for the specified report plan.
     */
    public suspend fun startReportJob(input: StartReportJobRequest): StartReportJobResponse

    /**
     * Recovers the saved resource identified by an Amazon Resource Name (ARN).
     */
    public suspend fun startRestoreJob(input: StartRestoreJobRequest): StartRestoreJobResponse

    /**
     * Attempts to cancel a job to create a one-time backup of a resource.
     *
     * This action is not supported for the following services: Amazon FSx for Windows File Server, Amazon FSx for Lustre, FSx for ONTAP , Amazon FSx for OpenZFS, Amazon DocumentDB (with MongoDB compatibility), Amazon RDS, Amazon Aurora, and Amazon Neptune.
     */
    public suspend fun stopBackupJob(input: StopBackupJobRequest): StopBackupJobResponse

    /**
     * Assigns a set of key-value pairs to a recovery point, backup plan, or backup vault identified by an Amazon Resource Name (ARN).
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes a set of key-value pairs from a recovery point, backup plan, or backup vault identified by an Amazon Resource Name (ARN)
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an existing backup plan identified by its `backupPlanId` with the input document in JSON format. The new version is uniquely identified by a `VersionId`.
     */
    public suspend fun updateBackupPlan(input: UpdateBackupPlanRequest): UpdateBackupPlanResponse

    /**
     * Updates an existing framework identified by its `FrameworkName` with the input document in JSON format.
     */
    public suspend fun updateFramework(input: UpdateFrameworkRequest): UpdateFrameworkResponse

    /**
     * Updates whether the Amazon Web Services account is opted in to cross-account backup. Returns an error if the account is not an Organizations management account. Use the `DescribeGlobalSettings` API to determine the current settings.
     */
    public suspend fun updateGlobalSettings(input: UpdateGlobalSettingsRequest = UpdateGlobalSettingsRequest { }): UpdateGlobalSettingsResponse

    /**
     * Sets the transition lifecycle of a recovery point.
     *
     * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define.
     *
     * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
     *
     * Resource types that are able to be transitioned to cold storage are listed in the "Lifecycle to cold storage" section of the [ Feature availability by resource](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource) table. Backup ignores this expression for other resource types.
     *
     * This operation does not support continuous backups.
     */
    public suspend fun updateRecoveryPointLifecycle(input: UpdateRecoveryPointLifecycleRequest): UpdateRecoveryPointLifecycleResponse

    /**
     * Updates the current service opt-in settings for the Region. If service-opt-in is enabled for a service, Backup tries to protect that service's resources in this Region, when the resource is included in an on-demand backup or scheduled backup plan. Otherwise, Backup does not try to protect that service's resources in this Region. Use the `DescribeRegionSettings` API to determine the resource types that are supported.
     */
    public suspend fun updateRegionSettings(input: UpdateRegionSettingsRequest = UpdateRegionSettingsRequest { }): UpdateRegionSettingsResponse

    /**
     * Updates an existing report plan identified by its `ReportPlanName` with the input document in JSON format.
     */
    public suspend fun updateReportPlan(input: UpdateReportPlanRequest): UpdateReportPlanResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun BackupClient.withConfig(block: BackupClient.Config.Builder.() -> Unit): BackupClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultBackupClient(newConfig)
}

/**
 * This action removes the specified legal hold on a recovery point. This action can only be performed by a user with sufficient permissions.
 */
public suspend inline fun BackupClient.cancelLegalHold(crossinline block: CancelLegalHoldRequest.Builder.() -> Unit): CancelLegalHoldResponse = cancelLegalHold(CancelLegalHoldRequest.Builder().apply(block).build())

/**
 * Creates a backup plan using a backup plan name and backup rules. A backup plan is a document that contains information that Backup uses to schedule tasks that create recovery points for resources.
 *
 * If you call `CreateBackupPlan` with a plan that already exists, you receive an `AlreadyExistsException` exception.
 */
public suspend inline fun BackupClient.createBackupPlan(crossinline block: CreateBackupPlanRequest.Builder.() -> Unit): CreateBackupPlanResponse = createBackupPlan(CreateBackupPlanRequest.Builder().apply(block).build())

/**
 * Creates a JSON document that specifies a set of resources to assign to a backup plan. For examples, see [Assigning resources programmatically](https://docs.aws.amazon.com/aws-backup/latest/devguide/assigning-resources.html#assigning-resources-json).
 */
public suspend inline fun BackupClient.createBackupSelection(crossinline block: CreateBackupSelectionRequest.Builder.() -> Unit): CreateBackupSelectionResponse = createBackupSelection(CreateBackupSelectionRequest.Builder().apply(block).build())

/**
 * Creates a logical container where backups are stored. A `CreateBackupVault` request includes a name, optionally one or more resource tags, an encryption key, and a request ID.
 *
 * Do not include sensitive data, such as passport numbers, in the name of a backup vault.
 */
public suspend inline fun BackupClient.createBackupVault(crossinline block: CreateBackupVaultRequest.Builder.() -> Unit): CreateBackupVaultResponse = createBackupVault(CreateBackupVaultRequest.Builder().apply(block).build())

/**
 * Creates a framework with one or more controls. A framework is a collection of controls that you can use to evaluate your backup practices. By using pre-built customizable controls to define your policies, you can evaluate whether your backup practices comply with your policies and which resources are not yet in compliance.
 */
public suspend inline fun BackupClient.createFramework(crossinline block: CreateFrameworkRequest.Builder.() -> Unit): CreateFrameworkResponse = createFramework(CreateFrameworkRequest.Builder().apply(block).build())

/**
 * This action creates a legal hold on a recovery point (backup). A legal hold is a restraint on altering or deleting a backup until an authorized user cancels the legal hold. Any actions to delete or disassociate a recovery point will fail with an error if one or more active legal holds are on the recovery point.
 */
public suspend inline fun BackupClient.createLegalHold(crossinline block: CreateLegalHoldRequest.Builder.() -> Unit): CreateLegalHoldResponse = createLegalHold(CreateLegalHoldRequest.Builder().apply(block).build())

/**
 * This request creates a logical container to where backups may be copied.
 *
 * This request includes a name, the Region, the maximum number of retention days, the minimum number of retention days, and optionally can include tags and a creator request ID.
 *
 * Do not include sensitive data, such as passport numbers, in the name of a backup vault.
 */
public suspend inline fun BackupClient.createLogicallyAirGappedBackupVault(crossinline block: CreateLogicallyAirGappedBackupVaultRequest.Builder.() -> Unit): CreateLogicallyAirGappedBackupVaultResponse = createLogicallyAirGappedBackupVault(CreateLogicallyAirGappedBackupVaultRequest.Builder().apply(block).build())

/**
 * Creates a report plan. A report plan is a document that contains information about the contents of the report and where Backup will deliver it.
 *
 * If you call `CreateReportPlan` with a plan that already exists, you receive an `AlreadyExistsException` exception.
 */
public suspend inline fun BackupClient.createReportPlan(crossinline block: CreateReportPlanRequest.Builder.() -> Unit): CreateReportPlanResponse = createReportPlan(CreateReportPlanRequest.Builder().apply(block).build())

/**
 * Deletes a backup plan. A backup plan can only be deleted after all associated selections of resources have been deleted. Deleting a backup plan deletes the current version of a backup plan. Previous versions, if any, will still exist.
 */
public suspend inline fun BackupClient.deleteBackupPlan(crossinline block: DeleteBackupPlanRequest.Builder.() -> Unit): DeleteBackupPlanResponse = deleteBackupPlan(DeleteBackupPlanRequest.Builder().apply(block).build())

/**
 * Deletes the resource selection associated with a backup plan that is specified by the `SelectionId`.
 */
public suspend inline fun BackupClient.deleteBackupSelection(crossinline block: DeleteBackupSelectionRequest.Builder.() -> Unit): DeleteBackupSelectionResponse = deleteBackupSelection(DeleteBackupSelectionRequest.Builder().apply(block).build())

/**
 * Deletes the backup vault identified by its name. A vault can be deleted only if it is empty.
 */
public suspend inline fun BackupClient.deleteBackupVault(crossinline block: DeleteBackupVaultRequest.Builder.() -> Unit): DeleteBackupVaultResponse = deleteBackupVault(DeleteBackupVaultRequest.Builder().apply(block).build())

/**
 * Deletes the policy document that manages permissions on a backup vault.
 */
public suspend inline fun BackupClient.deleteBackupVaultAccessPolicy(crossinline block: DeleteBackupVaultAccessPolicyRequest.Builder.() -> Unit): DeleteBackupVaultAccessPolicyResponse = deleteBackupVaultAccessPolicy(DeleteBackupVaultAccessPolicyRequest.Builder().apply(block).build())

/**
 * Deletes Backup Vault Lock from a backup vault specified by a backup vault name.
 *
 * If the Vault Lock configuration is immutable, then you cannot delete Vault Lock using API operations, and you will receive an `InvalidRequestException` if you attempt to do so. For more information, see [Vault Lock](https://docs.aws.amazon.com/aws-backup/latest/devguide/vault-lock.html) in the *Backup Developer Guide*.
 */
public suspend inline fun BackupClient.deleteBackupVaultLockConfiguration(crossinline block: DeleteBackupVaultLockConfigurationRequest.Builder.() -> Unit): DeleteBackupVaultLockConfigurationResponse = deleteBackupVaultLockConfiguration(DeleteBackupVaultLockConfigurationRequest.Builder().apply(block).build())

/**
 * Deletes event notifications for the specified backup vault.
 */
public suspend inline fun BackupClient.deleteBackupVaultNotifications(crossinline block: DeleteBackupVaultNotificationsRequest.Builder.() -> Unit): DeleteBackupVaultNotificationsResponse = deleteBackupVaultNotifications(DeleteBackupVaultNotificationsRequest.Builder().apply(block).build())

/**
 * Deletes the framework specified by a framework name.
 */
public suspend inline fun BackupClient.deleteFramework(crossinline block: DeleteFrameworkRequest.Builder.() -> Unit): DeleteFrameworkResponse = deleteFramework(DeleteFrameworkRequest.Builder().apply(block).build())

/**
 * Deletes the recovery point specified by a recovery point ID.
 *
 * If the recovery point ID belongs to a continuous backup, calling this endpoint deletes the existing continuous backup and stops future continuous backup.
 *
 * When an IAM role's permissions are insufficient to call this API, the service sends back an HTTP 200 response with an empty HTTP body, but the recovery point is not deleted. Instead, it enters an `EXPIRED` state.
 *
 * `EXPIRED` recovery points can be deleted with this API once the IAM role has the `iam:CreateServiceLinkedRole` action. To learn more about adding this role, see [ Troubleshooting manual deletions](https://docs.aws.amazon.com/aws-backup/latest/devguide/deleting-backups.html#deleting-backups-troubleshooting).
 *
 * If the user or role is deleted or the permission within the role is removed, the deletion will not be successful and will enter an `EXPIRED` state.
 */
public suspend inline fun BackupClient.deleteRecoveryPoint(crossinline block: DeleteRecoveryPointRequest.Builder.() -> Unit): DeleteRecoveryPointResponse = deleteRecoveryPoint(DeleteRecoveryPointRequest.Builder().apply(block).build())

/**
 * Deletes the report plan specified by a report plan name.
 */
public suspend inline fun BackupClient.deleteReportPlan(crossinline block: DeleteReportPlanRequest.Builder.() -> Unit): DeleteReportPlanResponse = deleteReportPlan(DeleteReportPlanRequest.Builder().apply(block).build())

/**
 * Returns backup job details for the specified `BackupJobId`.
 */
public suspend inline fun BackupClient.describeBackupJob(crossinline block: DescribeBackupJobRequest.Builder.() -> Unit): DescribeBackupJobResponse = describeBackupJob(DescribeBackupJobRequest.Builder().apply(block).build())

/**
 * Returns metadata about a backup vault specified by its name.
 */
public suspend inline fun BackupClient.describeBackupVault(crossinline block: DescribeBackupVaultRequest.Builder.() -> Unit): DescribeBackupVaultResponse = describeBackupVault(DescribeBackupVaultRequest.Builder().apply(block).build())

/**
 * Returns metadata associated with creating a copy of a resource.
 */
public suspend inline fun BackupClient.describeCopyJob(crossinline block: DescribeCopyJobRequest.Builder.() -> Unit): DescribeCopyJobResponse = describeCopyJob(DescribeCopyJobRequest.Builder().apply(block).build())

/**
 * Returns the framework details for the specified `FrameworkName`.
 */
public suspend inline fun BackupClient.describeFramework(crossinline block: DescribeFrameworkRequest.Builder.() -> Unit): DescribeFrameworkResponse = describeFramework(DescribeFrameworkRequest.Builder().apply(block).build())

/**
 * Describes whether the Amazon Web Services account is opted in to cross-account backup. Returns an error if the account is not a member of an Organizations organization. Example: `describe-global-settings --region us-west-2`
 */
public suspend inline fun BackupClient.describeGlobalSettings(crossinline block: DescribeGlobalSettingsRequest.Builder.() -> Unit): DescribeGlobalSettingsResponse = describeGlobalSettings(DescribeGlobalSettingsRequest.Builder().apply(block).build())

/**
 * Returns information about a saved resource, including the last time it was backed up, its Amazon Resource Name (ARN), and the Amazon Web Services service type of the saved resource.
 */
public suspend inline fun BackupClient.describeProtectedResource(crossinline block: DescribeProtectedResourceRequest.Builder.() -> Unit): DescribeProtectedResourceResponse = describeProtectedResource(DescribeProtectedResourceRequest.Builder().apply(block).build())

/**
 * Returns metadata associated with a recovery point, including ID, status, encryption, and lifecycle.
 */
public suspend inline fun BackupClient.describeRecoveryPoint(crossinline block: DescribeRecoveryPointRequest.Builder.() -> Unit): DescribeRecoveryPointResponse = describeRecoveryPoint(DescribeRecoveryPointRequest.Builder().apply(block).build())

/**
 * Returns the current service opt-in settings for the Region. If service opt-in is enabled for a service, Backup tries to protect that service's resources in this Region, when the resource is included in an on-demand backup or scheduled backup plan. Otherwise, Backup does not try to protect that service's resources in this Region.
 */
public suspend inline fun BackupClient.describeRegionSettings(crossinline block: DescribeRegionSettingsRequest.Builder.() -> Unit): DescribeRegionSettingsResponse = describeRegionSettings(DescribeRegionSettingsRequest.Builder().apply(block).build())

/**
 * Returns the details associated with creating a report as specified by its `ReportJobId`.
 */
public suspend inline fun BackupClient.describeReportJob(crossinline block: DescribeReportJobRequest.Builder.() -> Unit): DescribeReportJobResponse = describeReportJob(DescribeReportJobRequest.Builder().apply(block).build())

/**
 * Returns a list of all report plans for an Amazon Web Services account and Amazon Web Services Region.
 */
public suspend inline fun BackupClient.describeReportPlan(crossinline block: DescribeReportPlanRequest.Builder.() -> Unit): DescribeReportPlanResponse = describeReportPlan(DescribeReportPlanRequest.Builder().apply(block).build())

/**
 * Returns metadata associated with a restore job that is specified by a job ID.
 */
public suspend inline fun BackupClient.describeRestoreJob(crossinline block: DescribeRestoreJobRequest.Builder.() -> Unit): DescribeRestoreJobResponse = describeRestoreJob(DescribeRestoreJobRequest.Builder().apply(block).build())

/**
 * Deletes the specified continuous backup recovery point from Backup and releases control of that continuous backup to the source service, such as Amazon RDS. The source service will continue to create and retain continuous backups using the lifecycle that you specified in your original backup plan.
 *
 * Does not support snapshot backup recovery points.
 */
public suspend inline fun BackupClient.disassociateRecoveryPoint(crossinline block: DisassociateRecoveryPointRequest.Builder.() -> Unit): DisassociateRecoveryPointResponse = disassociateRecoveryPoint(DisassociateRecoveryPointRequest.Builder().apply(block).build())

/**
 * This action to a specific child (nested) recovery point removes the relationship between the specified recovery point and its parent (composite) recovery point.
 */
public suspend inline fun BackupClient.disassociateRecoveryPointFromParent(crossinline block: DisassociateRecoveryPointFromParentRequest.Builder.() -> Unit): DisassociateRecoveryPointFromParentResponse = disassociateRecoveryPointFromParent(DisassociateRecoveryPointFromParentRequest.Builder().apply(block).build())

/**
 * Returns the backup plan that is specified by the plan ID as a backup template.
 */
public suspend inline fun BackupClient.exportBackupPlanTemplate(crossinline block: ExportBackupPlanTemplateRequest.Builder.() -> Unit): ExportBackupPlanTemplateResponse = exportBackupPlanTemplate(ExportBackupPlanTemplateRequest.Builder().apply(block).build())

/**
 * Returns `BackupPlan` details for the specified `BackupPlanId`. The details are the body of a backup plan in JSON format, in addition to plan metadata.
 */
public suspend inline fun BackupClient.getBackupPlan(crossinline block: GetBackupPlanRequest.Builder.() -> Unit): GetBackupPlanResponse = getBackupPlan(GetBackupPlanRequest.Builder().apply(block).build())

/**
 * Returns a valid JSON document specifying a backup plan or an error.
 */
public suspend inline fun BackupClient.getBackupPlanFromJson(crossinline block: GetBackupPlanFromJsonRequest.Builder.() -> Unit): GetBackupPlanFromJsonResponse = getBackupPlanFromJson(GetBackupPlanFromJsonRequest.Builder().apply(block).build())

/**
 * Returns the template specified by its `templateId` as a backup plan.
 */
public suspend inline fun BackupClient.getBackupPlanFromTemplate(crossinline block: GetBackupPlanFromTemplateRequest.Builder.() -> Unit): GetBackupPlanFromTemplateResponse = getBackupPlanFromTemplate(GetBackupPlanFromTemplateRequest.Builder().apply(block).build())

/**
 * Returns selection metadata and a document in JSON format that specifies a list of resources that are associated with a backup plan.
 */
public suspend inline fun BackupClient.getBackupSelection(crossinline block: GetBackupSelectionRequest.Builder.() -> Unit): GetBackupSelectionResponse = getBackupSelection(GetBackupSelectionRequest.Builder().apply(block).build())

/**
 * Returns the access policy document that is associated with the named backup vault.
 */
public suspend inline fun BackupClient.getBackupVaultAccessPolicy(crossinline block: GetBackupVaultAccessPolicyRequest.Builder.() -> Unit): GetBackupVaultAccessPolicyResponse = getBackupVaultAccessPolicy(GetBackupVaultAccessPolicyRequest.Builder().apply(block).build())

/**
 * Returns event notifications for the specified backup vault.
 */
public suspend inline fun BackupClient.getBackupVaultNotifications(crossinline block: GetBackupVaultNotificationsRequest.Builder.() -> Unit): GetBackupVaultNotificationsResponse = getBackupVaultNotifications(GetBackupVaultNotificationsRequest.Builder().apply(block).build())

/**
 * This action returns details for a specified legal hold. The details are the body of a legal hold in JSON format, in addition to metadata.
 */
public suspend inline fun BackupClient.getLegalHold(crossinline block: GetLegalHoldRequest.Builder.() -> Unit): GetLegalHoldResponse = getLegalHold(GetLegalHoldRequest.Builder().apply(block).build())

/**
 * Returns a set of metadata key-value pairs that were used to create the backup.
 */
public suspend inline fun BackupClient.getRecoveryPointRestoreMetadata(crossinline block: GetRecoveryPointRestoreMetadataRequest.Builder.() -> Unit): GetRecoveryPointRestoreMetadataResponse = getRecoveryPointRestoreMetadata(GetRecoveryPointRestoreMetadataRequest.Builder().apply(block).build())

/**
 * Returns the Amazon Web Services resource types supported by Backup.
 */
public suspend inline fun BackupClient.getSupportedResourceTypes(crossinline block: GetSupportedResourceTypesRequest.Builder.() -> Unit): GetSupportedResourceTypesResponse = getSupportedResourceTypes(GetSupportedResourceTypesRequest.Builder().apply(block).build())

/**
 * This is a request for a summary of backup jobs created or running within the most recent 30 days. You can include parameters AccountID, State, ResourceType, MessageCategory, AggregationPeriod, MaxResults, or NextToken to filter results.
 *
 * This request returns a summary that contains Region, Account, State, ResourceType, MessageCategory, StartTime, EndTime, and Count of included jobs.
 */
public suspend inline fun BackupClient.listBackupJobSummaries(crossinline block: ListBackupJobSummariesRequest.Builder.() -> Unit): ListBackupJobSummariesResponse = listBackupJobSummaries(ListBackupJobSummariesRequest.Builder().apply(block).build())

/**
 * Returns a list of existing backup jobs for an authenticated account for the last 30 days. For a longer period of time, consider using these [monitoring tools](https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html).
 */
public suspend inline fun BackupClient.listBackupJobs(crossinline block: ListBackupJobsRequest.Builder.() -> Unit): ListBackupJobsResponse = listBackupJobs(ListBackupJobsRequest.Builder().apply(block).build())

/**
 * Returns metadata of your saved backup plan templates, including the template ID, name, and the creation and deletion dates.
 */
public suspend inline fun BackupClient.listBackupPlanTemplates(crossinline block: ListBackupPlanTemplatesRequest.Builder.() -> Unit): ListBackupPlanTemplatesResponse = listBackupPlanTemplates(ListBackupPlanTemplatesRequest.Builder().apply(block).build())

/**
 * Returns version metadata of your backup plans, including Amazon Resource Names (ARNs), backup plan IDs, creation and deletion dates, plan names, and version IDs.
 */
public suspend inline fun BackupClient.listBackupPlanVersions(crossinline block: ListBackupPlanVersionsRequest.Builder.() -> Unit): ListBackupPlanVersionsResponse = listBackupPlanVersions(ListBackupPlanVersionsRequest.Builder().apply(block).build())

/**
 * Returns a list of all active backup plans for an authenticated account. The list contains information such as Amazon Resource Names (ARNs), plan IDs, creation and deletion dates, version IDs, plan names, and creator request IDs.
 */
public suspend inline fun BackupClient.listBackupPlans(crossinline block: ListBackupPlansRequest.Builder.() -> Unit): ListBackupPlansResponse = listBackupPlans(ListBackupPlansRequest.Builder().apply(block).build())

/**
 * Returns an array containing metadata of the resources associated with the target backup plan.
 */
public suspend inline fun BackupClient.listBackupSelections(crossinline block: ListBackupSelectionsRequest.Builder.() -> Unit): ListBackupSelectionsResponse = listBackupSelections(ListBackupSelectionsRequest.Builder().apply(block).build())

/**
 * Returns a list of recovery point storage containers along with information about them.
 */
public suspend inline fun BackupClient.listBackupVaults(crossinline block: ListBackupVaultsRequest.Builder.() -> Unit): ListBackupVaultsResponse = listBackupVaults(ListBackupVaultsRequest.Builder().apply(block).build())

/**
 * This request obtains a list of copy jobs created or running within the the most recent 30 days. You can include parameters AccountID, State, ResourceType, MessageCategory, AggregationPeriod, MaxResults, or NextToken to filter results.
 *
 * This request returns a summary that contains Region, Account, State, RestourceType, MessageCategory, StartTime, EndTime, and Count of included jobs.
 */
public suspend inline fun BackupClient.listCopyJobSummaries(crossinline block: ListCopyJobSummariesRequest.Builder.() -> Unit): ListCopyJobSummariesResponse = listCopyJobSummaries(ListCopyJobSummariesRequest.Builder().apply(block).build())

/**
 * Returns metadata about your copy jobs.
 */
public suspend inline fun BackupClient.listCopyJobs(crossinline block: ListCopyJobsRequest.Builder.() -> Unit): ListCopyJobsResponse = listCopyJobs(ListCopyJobsRequest.Builder().apply(block).build())

/**
 * Returns a list of all frameworks for an Amazon Web Services account and Amazon Web Services Region.
 */
public suspend inline fun BackupClient.listFrameworks(crossinline block: ListFrameworksRequest.Builder.() -> Unit): ListFrameworksResponse = listFrameworks(ListFrameworksRequest.Builder().apply(block).build())

/**
 * This action returns metadata about active and previous legal holds.
 */
public suspend inline fun BackupClient.listLegalHolds(crossinline block: ListLegalHoldsRequest.Builder.() -> Unit): ListLegalHoldsResponse = listLegalHolds(ListLegalHoldsRequest.Builder().apply(block).build())

/**
 * Returns an array of resources successfully backed up by Backup, including the time the resource was saved, an Amazon Resource Name (ARN) of the resource, and a resource type.
 */
public suspend inline fun BackupClient.listProtectedResources(crossinline block: ListProtectedResourcesRequest.Builder.() -> Unit): ListProtectedResourcesResponse = listProtectedResources(ListProtectedResourcesRequest.Builder().apply(block).build())

/**
 * This request lists the protected resources corresponding to each backup vault.
 */
public suspend inline fun BackupClient.listProtectedResourcesByBackupVault(crossinline block: ListProtectedResourcesByBackupVaultRequest.Builder.() -> Unit): ListProtectedResourcesByBackupVaultResponse = listProtectedResourcesByBackupVault(ListProtectedResourcesByBackupVaultRequest.Builder().apply(block).build())

/**
 * Returns detailed information about the recovery points stored in a backup vault.
 */
public suspend inline fun BackupClient.listRecoveryPointsByBackupVault(crossinline block: ListRecoveryPointsByBackupVaultRequest.Builder.() -> Unit): ListRecoveryPointsByBackupVaultResponse = listRecoveryPointsByBackupVault(ListRecoveryPointsByBackupVaultRequest.Builder().apply(block).build())

/**
 * This action returns recovery point ARNs (Amazon Resource Names) of the specified legal hold.
 */
public suspend inline fun BackupClient.listRecoveryPointsByLegalHold(crossinline block: ListRecoveryPointsByLegalHoldRequest.Builder.() -> Unit): ListRecoveryPointsByLegalHoldResponse = listRecoveryPointsByLegalHold(ListRecoveryPointsByLegalHoldRequest.Builder().apply(block).build())

/**
 * Returns detailed information about all the recovery points of the type specified by a resource Amazon Resource Name (ARN).
 *
 * For Amazon EFS and Amazon EC2, this action only lists recovery points created by Backup.
 */
public suspend inline fun BackupClient.listRecoveryPointsByResource(crossinline block: ListRecoveryPointsByResourceRequest.Builder.() -> Unit): ListRecoveryPointsByResourceResponse = listRecoveryPointsByResource(ListRecoveryPointsByResourceRequest.Builder().apply(block).build())

/**
 * Returns details about your report jobs.
 */
public suspend inline fun BackupClient.listReportJobs(crossinline block: ListReportJobsRequest.Builder.() -> Unit): ListReportJobsResponse = listReportJobs(ListReportJobsRequest.Builder().apply(block).build())

/**
 * Returns a list of your report plans. For detailed information about a single report plan, use `DescribeReportPlan`.
 */
public suspend inline fun BackupClient.listReportPlans(crossinline block: ListReportPlansRequest.Builder.() -> Unit): ListReportPlansResponse = listReportPlans(ListReportPlansRequest.Builder().apply(block).build())

/**
 * This request obtains a summary of restore jobs created or running within the the most recent 30 days. You can include parameters AccountID, State, ResourceType, AggregationPeriod, MaxResults, or NextToken to filter results.
 *
 * This request returns a summary that contains Region, Account, State, RestourceType, MessageCategory, StartTime, EndTime, and Count of included jobs.
 */
public suspend inline fun BackupClient.listRestoreJobSummaries(crossinline block: ListRestoreJobSummariesRequest.Builder.() -> Unit): ListRestoreJobSummariesResponse = listRestoreJobSummaries(ListRestoreJobSummariesRequest.Builder().apply(block).build())

/**
 * Returns a list of jobs that Backup initiated to restore a saved resource, including details about the recovery process.
 */
public suspend inline fun BackupClient.listRestoreJobs(crossinline block: ListRestoreJobsRequest.Builder.() -> Unit): ListRestoreJobsResponse = listRestoreJobs(ListRestoreJobsRequest.Builder().apply(block).build())

/**
 * Returns a list of key-value pairs assigned to a target recovery point, backup plan, or backup vault.
 *
 * `ListTags` only works for resource types that support full Backup management of their backups. Those resource types are listed in the "Full Backup management" section of the [ Feature availability by resource](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource) table.
 */
public suspend inline fun BackupClient.listTags(crossinline block: ListTagsRequest.Builder.() -> Unit): ListTagsResponse = listTags(ListTagsRequest.Builder().apply(block).build())

/**
 * Sets a resource-based policy that is used to manage access permissions on the target backup vault. Requires a backup vault name and an access policy document in JSON format.
 */
public suspend inline fun BackupClient.putBackupVaultAccessPolicy(crossinline block: PutBackupVaultAccessPolicyRequest.Builder.() -> Unit): PutBackupVaultAccessPolicyResponse = putBackupVaultAccessPolicy(PutBackupVaultAccessPolicyRequest.Builder().apply(block).build())

/**
 * Applies Backup Vault Lock to a backup vault, preventing attempts to delete any recovery point stored in or created in a backup vault. Vault Lock also prevents attempts to update the lifecycle policy that controls the retention period of any recovery point currently stored in a backup vault. If specified, Vault Lock enforces a minimum and maximum retention period for future backup and copy jobs that target a backup vault.
 *
 * Backup Vault Lock has been assessed by Cohasset Associates for use in environments that are subject to SEC 17a-4, CFTC, and FINRA regulations. For more information about how Backup Vault Lock relates to these regulations, see the [Cohasset Associates Compliance Assessment.](samples/cohassetreport.zip)
 */
public suspend inline fun BackupClient.putBackupVaultLockConfiguration(crossinline block: PutBackupVaultLockConfigurationRequest.Builder.() -> Unit): PutBackupVaultLockConfigurationResponse = putBackupVaultLockConfiguration(PutBackupVaultLockConfigurationRequest.Builder().apply(block).build())

/**
 * Turns on notifications on a backup vault for the specified topic and events.
 */
public suspend inline fun BackupClient.putBackupVaultNotifications(crossinline block: PutBackupVaultNotificationsRequest.Builder.() -> Unit): PutBackupVaultNotificationsResponse = putBackupVaultNotifications(PutBackupVaultNotificationsRequest.Builder().apply(block).build())

/**
 * Starts an on-demand backup job for the specified resource.
 */
public suspend inline fun BackupClient.startBackupJob(crossinline block: StartBackupJobRequest.Builder.() -> Unit): StartBackupJobResponse = startBackupJob(StartBackupJobRequest.Builder().apply(block).build())

/**
 * Starts a job to create a one-time copy of the specified resource.
 *
 * Does not support continuous backups.
 */
public suspend inline fun BackupClient.startCopyJob(crossinline block: StartCopyJobRequest.Builder.() -> Unit): StartCopyJobResponse = startCopyJob(StartCopyJobRequest.Builder().apply(block).build())

/**
 * Starts an on-demand report job for the specified report plan.
 */
public suspend inline fun BackupClient.startReportJob(crossinline block: StartReportJobRequest.Builder.() -> Unit): StartReportJobResponse = startReportJob(StartReportJobRequest.Builder().apply(block).build())

/**
 * Recovers the saved resource identified by an Amazon Resource Name (ARN).
 */
public suspend inline fun BackupClient.startRestoreJob(crossinline block: StartRestoreJobRequest.Builder.() -> Unit): StartRestoreJobResponse = startRestoreJob(StartRestoreJobRequest.Builder().apply(block).build())

/**
 * Attempts to cancel a job to create a one-time backup of a resource.
 *
 * This action is not supported for the following services: Amazon FSx for Windows File Server, Amazon FSx for Lustre, FSx for ONTAP , Amazon FSx for OpenZFS, Amazon DocumentDB (with MongoDB compatibility), Amazon RDS, Amazon Aurora, and Amazon Neptune.
 */
public suspend inline fun BackupClient.stopBackupJob(crossinline block: StopBackupJobRequest.Builder.() -> Unit): StopBackupJobResponse = stopBackupJob(StopBackupJobRequest.Builder().apply(block).build())

/**
 * Assigns a set of key-value pairs to a recovery point, backup plan, or backup vault identified by an Amazon Resource Name (ARN).
 */
public suspend inline fun BackupClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes a set of key-value pairs from a recovery point, backup plan, or backup vault identified by an Amazon Resource Name (ARN)
 */
public suspend inline fun BackupClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an existing backup plan identified by its `backupPlanId` with the input document in JSON format. The new version is uniquely identified by a `VersionId`.
 */
public suspend inline fun BackupClient.updateBackupPlan(crossinline block: UpdateBackupPlanRequest.Builder.() -> Unit): UpdateBackupPlanResponse = updateBackupPlan(UpdateBackupPlanRequest.Builder().apply(block).build())

/**
 * Updates an existing framework identified by its `FrameworkName` with the input document in JSON format.
 */
public suspend inline fun BackupClient.updateFramework(crossinline block: UpdateFrameworkRequest.Builder.() -> Unit): UpdateFrameworkResponse = updateFramework(UpdateFrameworkRequest.Builder().apply(block).build())

/**
 * Updates whether the Amazon Web Services account is opted in to cross-account backup. Returns an error if the account is not an Organizations management account. Use the `DescribeGlobalSettings` API to determine the current settings.
 */
public suspend inline fun BackupClient.updateGlobalSettings(crossinline block: UpdateGlobalSettingsRequest.Builder.() -> Unit): UpdateGlobalSettingsResponse = updateGlobalSettings(UpdateGlobalSettingsRequest.Builder().apply(block).build())

/**
 * Sets the transition lifecycle of a recovery point.
 *
 * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup transitions and expires backups automatically according to the lifecycle that you define.
 *
 * Backups transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition to cold after days” setting cannot be changed after a backup has been transitioned to cold.
 *
 * Resource types that are able to be transitioned to cold storage are listed in the "Lifecycle to cold storage" section of the [ Feature availability by resource](https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource) table. Backup ignores this expression for other resource types.
 *
 * This operation does not support continuous backups.
 */
public suspend inline fun BackupClient.updateRecoveryPointLifecycle(crossinline block: UpdateRecoveryPointLifecycleRequest.Builder.() -> Unit): UpdateRecoveryPointLifecycleResponse = updateRecoveryPointLifecycle(UpdateRecoveryPointLifecycleRequest.Builder().apply(block).build())

/**
 * Updates the current service opt-in settings for the Region. If service-opt-in is enabled for a service, Backup tries to protect that service's resources in this Region, when the resource is included in an on-demand backup or scheduled backup plan. Otherwise, Backup does not try to protect that service's resources in this Region. Use the `DescribeRegionSettings` API to determine the resource types that are supported.
 */
public suspend inline fun BackupClient.updateRegionSettings(crossinline block: UpdateRegionSettingsRequest.Builder.() -> Unit): UpdateRegionSettingsResponse = updateRegionSettings(UpdateRegionSettingsRequest.Builder().apply(block).build())

/**
 * Updates an existing report plan identified by its `ReportPlanName` with the input document in JSON format.
 */
public suspend inline fun BackupClient.updateReportPlan(crossinline block: UpdateReportPlanRequest.Builder.() -> Unit): UpdateReportPlanResponse = updateReportPlan(UpdateReportPlanRequest.Builder().apply(block).build())
