// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.backup.model.BackupException
import aws.sdk.kotlin.services.backup.model.CalculatedLifecycle
import aws.sdk.kotlin.services.backup.model.Lifecycle
import aws.sdk.kotlin.services.backup.model.UpdateRecoveryPointLifecycleResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateRecoveryPointLifecycleOperationDeserializer: HttpDeserialize<UpdateRecoveryPointLifecycleResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateRecoveryPointLifecycleResponse {
        if (!response.status.isSuccess()) {
            throwUpdateRecoveryPointLifecycleError(context, response)
        }
        val builder = UpdateRecoveryPointLifecycleResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateRecoveryPointLifecycleOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateRecoveryPointLifecycleError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw BackupException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterValueException" -> InvalidParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "MissingParameterValueException" -> MissingParameterValueExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ServiceUnavailableException" -> ServiceUnavailableExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> BackupException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateRecoveryPointLifecycleOperationBody(builder: UpdateRecoveryPointLifecycleResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BACKUPVAULTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("BackupVaultArn"))
    val CALCULATEDLIFECYCLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CalculatedLifecycle"))
    val LIFECYCLE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Lifecycle"))
    val RECOVERYPOINTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RecoveryPointArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BACKUPVAULTARN_DESCRIPTOR)
        field(CALCULATEDLIFECYCLE_DESCRIPTOR)
        field(LIFECYCLE_DESCRIPTOR)
        field(RECOVERYPOINTARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BACKUPVAULTARN_DESCRIPTOR.index -> builder.backupVaultArn = deserializeString()
                CALCULATEDLIFECYCLE_DESCRIPTOR.index -> builder.calculatedLifecycle = deserializeCalculatedLifecycleDocument(deserializer)
                LIFECYCLE_DESCRIPTOR.index -> builder.lifecycle = deserializeLifecycleDocument(deserializer)
                RECOVERYPOINTARN_DESCRIPTOR.index -> builder.recoveryPointArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
