// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model



public class PutBackupVaultNotificationsRequest private constructor(builder: Builder) {
    /**
     * An array of events that indicate the status of jobs to back up resources to the backup vault.
     *
     * For common use cases and code samples, see [Using Amazon SNS to track Backup events](https://docs.aws.amazon.com/aws-backup/latest/devguide/sns-notifications.html).
     *
     * The following events are supported:
     * + `BACKUP_JOB_STARTED` | `BACKUP_JOB_COMPLETED`
     * + `COPY_JOB_STARTED` | `COPY_JOB_SUCCESSFUL` | `COPY_JOB_FAILED`
     * + `RESTORE_JOB_STARTED` | `RESTORE_JOB_COMPLETED` | `RECOVERY_POINT_MODIFIED`
     * + `S3_BACKUP_OBJECT_FAILED` | `S3_RESTORE_OBJECT_FAILED`
     *
     * Ignore the list below because it includes deprecated events. Refer to the list above.
     */
    public val backupVaultEvents: List<BackupVaultEvent>? = builder.backupVaultEvents
    /**
     * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.
     */
    public val backupVaultName: kotlin.String? = requireNotNull(builder.backupVaultName) { "A non-null value must be provided for backupVaultName" }
    /**
     * The Amazon Resource Name (ARN) that specifies the topic for a backup vault’s events; for example, `arn:aws:sns:us-west-2:111122223333:MyVaultTopic`.
     */
    public val snsTopicArn: kotlin.String? = builder.snsTopicArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.PutBackupVaultNotificationsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutBackupVaultNotificationsRequest(")
        append("backupVaultEvents=$backupVaultEvents,")
        append("backupVaultName=$backupVaultName,")
        append("snsTopicArn=$snsTopicArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = backupVaultEvents?.hashCode() ?: 0
        result = 31 * result + (backupVaultName?.hashCode() ?: 0)
        result = 31 * result + (snsTopicArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutBackupVaultNotificationsRequest

        if (backupVaultEvents != other.backupVaultEvents) return false
        if (backupVaultName != other.backupVaultName) return false
        if (snsTopicArn != other.snsTopicArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.PutBackupVaultNotificationsRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An array of events that indicate the status of jobs to back up resources to the backup vault.
         *
         * For common use cases and code samples, see [Using Amazon SNS to track Backup events](https://docs.aws.amazon.com/aws-backup/latest/devguide/sns-notifications.html).
         *
         * The following events are supported:
         * + `BACKUP_JOB_STARTED` | `BACKUP_JOB_COMPLETED`
         * + `COPY_JOB_STARTED` | `COPY_JOB_SUCCESSFUL` | `COPY_JOB_FAILED`
         * + `RESTORE_JOB_STARTED` | `RESTORE_JOB_COMPLETED` | `RECOVERY_POINT_MODIFIED`
         * + `S3_BACKUP_OBJECT_FAILED` | `S3_RESTORE_OBJECT_FAILED`
         *
         * Ignore the list below because it includes deprecated events. Refer to the list above.
         */
        public var backupVaultEvents: List<BackupVaultEvent>? = null
        /**
         * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique to the account used to create them and the Amazon Web Services Region where they are created. They consist of lowercase letters, numbers, and hyphens.
         */
        public var backupVaultName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) that specifies the topic for a backup vault’s events; for example, `arn:aws:sns:us-west-2:111122223333:MyVaultTopic`.
         */
        public var snsTopicArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.PutBackupVaultNotificationsRequest) : this() {
            this.backupVaultEvents = x.backupVaultEvents
            this.backupVaultName = x.backupVaultName
            this.snsTopicArn = x.snsTopicArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.PutBackupVaultNotificationsRequest = PutBackupVaultNotificationsRequest(this)
    }
}
