// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.backup.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Contains detailed information about a copy job.
 */
public class CopyJob private constructor(builder: Builder) {
    /**
     * The account ID that owns the copy job.
     */
    public val accountId: kotlin.String? = builder.accountId
    /**
     * The size, in bytes, of a copy job.
     */
    public val backupSizeInBytes: kotlin.Long? = builder.backupSizeInBytes
    /**
     * The date and time a copy job is completed, in Unix format and Coordinated Universal Time (UTC). The value of `CompletionDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val completionDate: aws.smithy.kotlin.runtime.time.Instant? = builder.completionDate
    /**
     * Uniquely identifies a copy job.
     */
    public val copyJobId: kotlin.String? = builder.copyJobId
    /**
     * Contains information about the backup plan and rule that Backup used to initiate the recovery point backup.
     */
    public val createdBy: aws.sdk.kotlin.services.backup.model.RecoveryPointCreator? = builder.createdBy
    /**
     * The date and time a copy job is created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public val creationDate: aws.smithy.kotlin.runtime.time.Instant? = builder.creationDate
    /**
     * An Amazon Resource Name (ARN) that uniquely identifies a destination copy vault; for example, `arn:aws:backup:us-east-1:123456789012:vault:aBackupVault`.
     */
    public val destinationBackupVaultArn: kotlin.String? = builder.destinationBackupVaultArn
    /**
     * An ARN that uniquely identifies a destination recovery point; for example, `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
     */
    public val destinationRecoveryPointArn: kotlin.String? = builder.destinationRecoveryPointArn
    /**
     * Specifies the IAM role ARN used to copy the target recovery point; for example, `arn:aws:iam::123456789012:role/S3Access`.
     */
    public val iamRoleArn: kotlin.String? = builder.iamRoleArn
    /**
     * The Amazon Web Services resource to be copied; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.
     */
    public val resourceArn: kotlin.String? = builder.resourceArn
    /**
     * The type of Amazon Web Services resource to be copied; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.
     */
    public val resourceType: kotlin.String? = builder.resourceType
    /**
     * An Amazon Resource Name (ARN) that uniquely identifies a source copy vault; for example, `arn:aws:backup:us-east-1:123456789012:vault:aBackupVault`.
     */
    public val sourceBackupVaultArn: kotlin.String? = builder.sourceBackupVaultArn
    /**
     * An ARN that uniquely identifies a source recovery point; for example, `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
     */
    public val sourceRecoveryPointArn: kotlin.String? = builder.sourceRecoveryPointArn
    /**
     * The current state of a copy job.
     */
    public val state: aws.sdk.kotlin.services.backup.model.CopyJobState? = builder.state
    /**
     * A detailed message explaining the status of the job to copy a resource.
     */
    public val statusMessage: kotlin.String? = builder.statusMessage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.backup.model.CopyJob = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CopyJob(")
        append("accountId=$accountId,")
        append("backupSizeInBytes=$backupSizeInBytes,")
        append("completionDate=$completionDate,")
        append("copyJobId=$copyJobId,")
        append("createdBy=$createdBy,")
        append("creationDate=$creationDate,")
        append("destinationBackupVaultArn=$destinationBackupVaultArn,")
        append("destinationRecoveryPointArn=$destinationRecoveryPointArn,")
        append("iamRoleArn=$iamRoleArn,")
        append("resourceArn=$resourceArn,")
        append("resourceType=$resourceType,")
        append("sourceBackupVaultArn=$sourceBackupVaultArn,")
        append("sourceRecoveryPointArn=$sourceRecoveryPointArn,")
        append("state=$state,")
        append("statusMessage=$statusMessage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountId?.hashCode() ?: 0
        result = 31 * result + (backupSizeInBytes?.hashCode() ?: 0)
        result = 31 * result + (completionDate?.hashCode() ?: 0)
        result = 31 * result + (copyJobId?.hashCode() ?: 0)
        result = 31 * result + (createdBy?.hashCode() ?: 0)
        result = 31 * result + (creationDate?.hashCode() ?: 0)
        result = 31 * result + (destinationBackupVaultArn?.hashCode() ?: 0)
        result = 31 * result + (destinationRecoveryPointArn?.hashCode() ?: 0)
        result = 31 * result + (iamRoleArn?.hashCode() ?: 0)
        result = 31 * result + (resourceArn?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        result = 31 * result + (sourceBackupVaultArn?.hashCode() ?: 0)
        result = 31 * result + (sourceRecoveryPointArn?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        result = 31 * result + (statusMessage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CopyJob

        if (accountId != other.accountId) return false
        if (backupSizeInBytes != other.backupSizeInBytes) return false
        if (completionDate != other.completionDate) return false
        if (copyJobId != other.copyJobId) return false
        if (createdBy != other.createdBy) return false
        if (creationDate != other.creationDate) return false
        if (destinationBackupVaultArn != other.destinationBackupVaultArn) return false
        if (destinationRecoveryPointArn != other.destinationRecoveryPointArn) return false
        if (iamRoleArn != other.iamRoleArn) return false
        if (resourceArn != other.resourceArn) return false
        if (resourceType != other.resourceType) return false
        if (sourceBackupVaultArn != other.sourceBackupVaultArn) return false
        if (sourceRecoveryPointArn != other.sourceRecoveryPointArn) return false
        if (state != other.state) return false
        if (statusMessage != other.statusMessage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.backup.model.CopyJob = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The account ID that owns the copy job.
         */
        public var accountId: kotlin.String? = null
        /**
         * The size, in bytes, of a copy job.
         */
        public var backupSizeInBytes: kotlin.Long? = null
        /**
         * The date and time a copy job is completed, in Unix format and Coordinated Universal Time (UTC). The value of `CompletionDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var completionDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Uniquely identifies a copy job.
         */
        public var copyJobId: kotlin.String? = null
        /**
         * Contains information about the backup plan and rule that Backup used to initiate the recovery point backup.
         */
        public var createdBy: aws.sdk.kotlin.services.backup.model.RecoveryPointCreator? = null
        /**
         * The date and time a copy job is created, in Unix format and Coordinated Universal Time (UTC). The value of `CreationDate` is accurate to milliseconds. For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         */
        public var creationDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An Amazon Resource Name (ARN) that uniquely identifies a destination copy vault; for example, `arn:aws:backup:us-east-1:123456789012:vault:aBackupVault`.
         */
        public var destinationBackupVaultArn: kotlin.String? = null
        /**
         * An ARN that uniquely identifies a destination recovery point; for example, `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
         */
        public var destinationRecoveryPointArn: kotlin.String? = null
        /**
         * Specifies the IAM role ARN used to copy the target recovery point; for example, `arn:aws:iam::123456789012:role/S3Access`.
         */
        public var iamRoleArn: kotlin.String? = null
        /**
         * The Amazon Web Services resource to be copied; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.
         */
        public var resourceArn: kotlin.String? = null
        /**
         * The type of Amazon Web Services resource to be copied; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.
         */
        public var resourceType: kotlin.String? = null
        /**
         * An Amazon Resource Name (ARN) that uniquely identifies a source copy vault; for example, `arn:aws:backup:us-east-1:123456789012:vault:aBackupVault`.
         */
        public var sourceBackupVaultArn: kotlin.String? = null
        /**
         * An ARN that uniquely identifies a source recovery point; for example, `arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45`.
         */
        public var sourceRecoveryPointArn: kotlin.String? = null
        /**
         * The current state of a copy job.
         */
        public var state: aws.sdk.kotlin.services.backup.model.CopyJobState? = null
        /**
         * A detailed message explaining the status of the job to copy a resource.
         */
        public var statusMessage: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.backup.model.CopyJob) : this() {
            this.accountId = x.accountId
            this.backupSizeInBytes = x.backupSizeInBytes
            this.completionDate = x.completionDate
            this.copyJobId = x.copyJobId
            this.createdBy = x.createdBy
            this.creationDate = x.creationDate
            this.destinationBackupVaultArn = x.destinationBackupVaultArn
            this.destinationRecoveryPointArn = x.destinationRecoveryPointArn
            this.iamRoleArn = x.iamRoleArn
            this.resourceArn = x.resourceArn
            this.resourceType = x.resourceType
            this.sourceBackupVaultArn = x.sourceBackupVaultArn
            this.sourceRecoveryPointArn = x.sourceRecoveryPointArn
            this.state = x.state
            this.statusMessage = x.statusMessage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.backup.model.CopyJob = CopyJob(this)

        /**
         * construct an [aws.sdk.kotlin.services.backup.model.RecoveryPointCreator] inside the given [block]
         */
        public fun createdBy(block: aws.sdk.kotlin.services.backup.model.RecoveryPointCreator.Builder.() -> kotlin.Unit) {
            this.createdBy = aws.sdk.kotlin.services.backup.model.RecoveryPointCreator.invoke(block)
        }
    }
}
