// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.b2bi.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains options for wrapping (line folding) in X12 EDI files. Wrapping controls how long lines are handled in the EDI output.
 */
public class WrapOptions private constructor(builder: Builder) {
    /**
     * Specifies the maximum length of a line before wrapping occurs. This value is used when `wrapBy` is set to `LINE_LENGTH`.
     */
    public val lineLength: kotlin.Int? = builder.lineLength
    /**
     * Specifies the character sequence used to terminate lines when wrapping. Valid values:
     * + `CRLF`: carriage return and line feed
     * + `LF`: line feed)
     * + `CR`: carriage return
     */
    public val lineTerminator: aws.sdk.kotlin.services.b2bi.model.LineTerminator? = builder.lineTerminator
    /**
     * Specifies the method used for wrapping lines in the EDI output. Valid values:
     * + `SEGMENT`: Wraps by segment.
     * + `ONE_LINE`: Indicates that the entire content is on a single line.When you specify `ONE_LINE`, do not provide either the line length nor the line terminator value.
     * + `LINE_LENGTH`: Wraps by character count, as specified by `lineLength` value.
     */
    public val wrapBy: aws.sdk.kotlin.services.b2bi.model.WrapFormat = requireNotNull(builder.wrapBy) { "A non-null value must be provided for wrapBy" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.b2bi.model.WrapOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WrapOptions(")
        append("lineLength=$lineLength,")
        append("lineTerminator=$lineTerminator,")
        append("wrapBy=$wrapBy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = lineLength ?: 0
        result = 31 * result + (lineTerminator?.hashCode() ?: 0)
        result = 31 * result + (wrapBy.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WrapOptions

        if (lineLength != other.lineLength) return false
        if (lineTerminator != other.lineTerminator) return false
        if (wrapBy != other.wrapBy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.b2bi.model.WrapOptions = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the maximum length of a line before wrapping occurs. This value is used when `wrapBy` is set to `LINE_LENGTH`.
         */
        public var lineLength: kotlin.Int? = null
        /**
         * Specifies the character sequence used to terminate lines when wrapping. Valid values:
         * + `CRLF`: carriage return and line feed
         * + `LF`: line feed)
         * + `CR`: carriage return
         */
        public var lineTerminator: aws.sdk.kotlin.services.b2bi.model.LineTerminator? = null
        /**
         * Specifies the method used for wrapping lines in the EDI output. Valid values:
         * + `SEGMENT`: Wraps by segment.
         * + `ONE_LINE`: Indicates that the entire content is on a single line.When you specify `ONE_LINE`, do not provide either the line length nor the line terminator value.
         * + `LINE_LENGTH`: Wraps by character count, as specified by `lineLength` value.
         */
        public var wrapBy: aws.sdk.kotlin.services.b2bi.model.WrapFormat? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.b2bi.model.WrapOptions) : this() {
            this.lineLength = x.lineLength
            this.lineTerminator = x.lineTerminator
            this.wrapBy = x.wrapBy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.b2bi.model.WrapOptions = WrapOptions(this)

        internal fun correctErrors(): Builder {
            if (wrapBy == null) wrapBy = WrapFormat.SdkUnknown("no value provided")
            return this
        }
    }
}
