// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.b2bi.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class GetPartnershipResponse private constructor(builder: Builder) {
    /**
     * Returns one or more capabilities associated with this partnership.
     */
    public val capabilities: List<String>? = builder.capabilities
    /**
     * Contains the details for an Outbound EDI capability.
     */
    public val capabilityOptions: aws.sdk.kotlin.services.b2bi.model.CapabilityOptions? = builder.capabilityOptions
    /**
     * Returns a timestamp for creation date and time of the partnership.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * Returns the email address associated with this trading partner.
     */
    public val email: kotlin.String? = builder.email
    /**
     * Returns a timestamp that identifies the most recent date and time that the partnership was modified.
     */
    public val modifiedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.modifiedAt
    /**
     * Returns the display name of the partnership
     */
    public val name: kotlin.String? = builder.name
    /**
     * Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a capability, partnership, profile, or transformer.
     */
    public val partnershipArn: kotlin.String = requireNotNull(builder.partnershipArn) { "A non-null value must be provided for partnershipArn" }
    /**
     * Returns the unique, system-generated identifier for a partnership.
     */
    public val partnershipId: kotlin.String = requireNotNull(builder.partnershipId) { "A non-null value must be provided for partnershipId" }
    /**
     * Returns the phone number associated with the partnership.
     */
    public val phone: kotlin.String? = builder.phone
    /**
     * Returns the unique, system-generated identifier for the profile connected to this partnership.
     */
    public val profileId: kotlin.String = requireNotNull(builder.profileId) { "A non-null value must be provided for profileId" }
    /**
     * Returns the unique identifier for the partner for this partnership.
     */
    public val tradingPartnerId: kotlin.String? = builder.tradingPartnerId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.b2bi.model.GetPartnershipResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetPartnershipResponse(")
        append("capabilities=$capabilities,")
        append("capabilityOptions=$capabilityOptions,")
        append("createdAt=$createdAt,")
        append("email=*** Sensitive Data Redacted ***,")
        append("modifiedAt=$modifiedAt,")
        append("name=$name,")
        append("partnershipArn=$partnershipArn,")
        append("partnershipId=$partnershipId,")
        append("phone=*** Sensitive Data Redacted ***,")
        append("profileId=$profileId,")
        append("tradingPartnerId=$tradingPartnerId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = capabilities?.hashCode() ?: 0
        result = 31 * result + (capabilityOptions?.hashCode() ?: 0)
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (email?.hashCode() ?: 0)
        result = 31 * result + (modifiedAt?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (partnershipArn.hashCode())
        result = 31 * result + (partnershipId.hashCode())
        result = 31 * result + (phone?.hashCode() ?: 0)
        result = 31 * result + (profileId.hashCode())
        result = 31 * result + (tradingPartnerId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetPartnershipResponse

        if (capabilities != other.capabilities) return false
        if (capabilityOptions != other.capabilityOptions) return false
        if (createdAt != other.createdAt) return false
        if (email != other.email) return false
        if (modifiedAt != other.modifiedAt) return false
        if (name != other.name) return false
        if (partnershipArn != other.partnershipArn) return false
        if (partnershipId != other.partnershipId) return false
        if (phone != other.phone) return false
        if (profileId != other.profileId) return false
        if (tradingPartnerId != other.tradingPartnerId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.b2bi.model.GetPartnershipResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Returns one or more capabilities associated with this partnership.
         */
        public var capabilities: List<String>? = null
        /**
         * Contains the details for an Outbound EDI capability.
         */
        public var capabilityOptions: aws.sdk.kotlin.services.b2bi.model.CapabilityOptions? = null
        /**
         * Returns a timestamp for creation date and time of the partnership.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Returns the email address associated with this trading partner.
         */
        public var email: kotlin.String? = null
        /**
         * Returns a timestamp that identifies the most recent date and time that the partnership was modified.
         */
        public var modifiedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Returns the display name of the partnership
         */
        public var name: kotlin.String? = null
        /**
         * Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a capability, partnership, profile, or transformer.
         */
        public var partnershipArn: kotlin.String? = null
        /**
         * Returns the unique, system-generated identifier for a partnership.
         */
        public var partnershipId: kotlin.String? = null
        /**
         * Returns the phone number associated with the partnership.
         */
        public var phone: kotlin.String? = null
        /**
         * Returns the unique, system-generated identifier for the profile connected to this partnership.
         */
        public var profileId: kotlin.String? = null
        /**
         * Returns the unique identifier for the partner for this partnership.
         */
        public var tradingPartnerId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.b2bi.model.GetPartnershipResponse) : this() {
            this.capabilities = x.capabilities
            this.capabilityOptions = x.capabilityOptions
            this.createdAt = x.createdAt
            this.email = x.email
            this.modifiedAt = x.modifiedAt
            this.name = x.name
            this.partnershipArn = x.partnershipArn
            this.partnershipId = x.partnershipId
            this.phone = x.phone
            this.profileId = x.profileId
            this.tradingPartnerId = x.tradingPartnerId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.b2bi.model.GetPartnershipResponse = GetPartnershipResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.b2bi.model.CapabilityOptions] inside the given [block]
         */
        public fun capabilityOptions(block: aws.sdk.kotlin.services.b2bi.model.CapabilityOptions.Builder.() -> kotlin.Unit) {
            this.capabilityOptions = aws.sdk.kotlin.services.b2bi.model.CapabilityOptions.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (partnershipArn == null) partnershipArn = ""
            if (partnershipId == null) partnershipId = ""
            if (profileId == null) profileId = ""
            return this
        }
    }
}
