// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.b2bi

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.b2bi.auth.B2BiAuthSchemeProvider
import aws.sdk.kotlin.services.b2bi.auth.DefaultB2BiAuthSchemeProvider
import aws.sdk.kotlin.services.b2bi.endpoints.B2BiEndpointParameters
import aws.sdk.kotlin.services.b2bi.endpoints.B2BiEndpointProvider
import aws.sdk.kotlin.services.b2bi.endpoints.DefaultB2BiEndpointProvider
import aws.sdk.kotlin.services.b2bi.model.CreateCapabilityRequest
import aws.sdk.kotlin.services.b2bi.model.CreateCapabilityResponse
import aws.sdk.kotlin.services.b2bi.model.CreatePartnershipRequest
import aws.sdk.kotlin.services.b2bi.model.CreatePartnershipResponse
import aws.sdk.kotlin.services.b2bi.model.CreateProfileRequest
import aws.sdk.kotlin.services.b2bi.model.CreateProfileResponse
import aws.sdk.kotlin.services.b2bi.model.CreateStarterMappingTemplateRequest
import aws.sdk.kotlin.services.b2bi.model.CreateStarterMappingTemplateResponse
import aws.sdk.kotlin.services.b2bi.model.CreateTransformerRequest
import aws.sdk.kotlin.services.b2bi.model.CreateTransformerResponse
import aws.sdk.kotlin.services.b2bi.model.DeleteCapabilityRequest
import aws.sdk.kotlin.services.b2bi.model.DeleteCapabilityResponse
import aws.sdk.kotlin.services.b2bi.model.DeletePartnershipRequest
import aws.sdk.kotlin.services.b2bi.model.DeletePartnershipResponse
import aws.sdk.kotlin.services.b2bi.model.DeleteProfileRequest
import aws.sdk.kotlin.services.b2bi.model.DeleteProfileResponse
import aws.sdk.kotlin.services.b2bi.model.DeleteTransformerRequest
import aws.sdk.kotlin.services.b2bi.model.DeleteTransformerResponse
import aws.sdk.kotlin.services.b2bi.model.GenerateMappingRequest
import aws.sdk.kotlin.services.b2bi.model.GenerateMappingResponse
import aws.sdk.kotlin.services.b2bi.model.GetCapabilityRequest
import aws.sdk.kotlin.services.b2bi.model.GetCapabilityResponse
import aws.sdk.kotlin.services.b2bi.model.GetPartnershipRequest
import aws.sdk.kotlin.services.b2bi.model.GetPartnershipResponse
import aws.sdk.kotlin.services.b2bi.model.GetProfileRequest
import aws.sdk.kotlin.services.b2bi.model.GetProfileResponse
import aws.sdk.kotlin.services.b2bi.model.GetTransformerJobRequest
import aws.sdk.kotlin.services.b2bi.model.GetTransformerJobResponse
import aws.sdk.kotlin.services.b2bi.model.GetTransformerRequest
import aws.sdk.kotlin.services.b2bi.model.GetTransformerResponse
import aws.sdk.kotlin.services.b2bi.model.ListCapabilitiesRequest
import aws.sdk.kotlin.services.b2bi.model.ListCapabilitiesResponse
import aws.sdk.kotlin.services.b2bi.model.ListPartnershipsRequest
import aws.sdk.kotlin.services.b2bi.model.ListPartnershipsResponse
import aws.sdk.kotlin.services.b2bi.model.ListProfilesRequest
import aws.sdk.kotlin.services.b2bi.model.ListProfilesResponse
import aws.sdk.kotlin.services.b2bi.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.b2bi.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.b2bi.model.ListTransformersRequest
import aws.sdk.kotlin.services.b2bi.model.ListTransformersResponse
import aws.sdk.kotlin.services.b2bi.model.StartTransformerJobRequest
import aws.sdk.kotlin.services.b2bi.model.StartTransformerJobResponse
import aws.sdk.kotlin.services.b2bi.model.TagResourceRequest
import aws.sdk.kotlin.services.b2bi.model.TagResourceResponse
import aws.sdk.kotlin.services.b2bi.model.TestConversionRequest
import aws.sdk.kotlin.services.b2bi.model.TestConversionResponse
import aws.sdk.kotlin.services.b2bi.model.TestMappingRequest
import aws.sdk.kotlin.services.b2bi.model.TestMappingResponse
import aws.sdk.kotlin.services.b2bi.model.TestParsingRequest
import aws.sdk.kotlin.services.b2bi.model.TestParsingResponse
import aws.sdk.kotlin.services.b2bi.model.UntagResourceRequest
import aws.sdk.kotlin.services.b2bi.model.UntagResourceResponse
import aws.sdk.kotlin.services.b2bi.model.UpdateCapabilityRequest
import aws.sdk.kotlin.services.b2bi.model.UpdateCapabilityResponse
import aws.sdk.kotlin.services.b2bi.model.UpdatePartnershipRequest
import aws.sdk.kotlin.services.b2bi.model.UpdatePartnershipResponse
import aws.sdk.kotlin.services.b2bi.model.UpdateProfileRequest
import aws.sdk.kotlin.services.b2bi.model.UpdateProfileResponse
import aws.sdk.kotlin.services.b2bi.model.UpdateTransformerRequest
import aws.sdk.kotlin.services.b2bi.model.UpdateTransformerResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "b2bi"
public const val SdkVersion: String = "1.5.9"
public const val ServiceApiVersion: String = "2022-06-23"

/**
 * This is the *Amazon Web Services B2B Data Interchange API Reference*. It provides descriptions, API request parameters, and the XML response for each of the B2BI API actions.
 *
 * B2BI enables automated exchange of EDI (electronic data interchange) based business-critical transactions at cloud scale, with elasticity and pay-as-you-go pricing. Businesses use EDI documents to exchange transactional data with trading partners, such as suppliers and end customers, using standardized formats such as X12.
 *
 * Rather than actually running a command, you can use the `--generate-cli-skeleton` parameter with any API call to generate and display a parameter template. You can then use the generated template to customize and use as input on a later command. For details, see [Generate and use a parameter skeleton file](https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-skeleton.html#cli-usage-skeleton-generate).
 */
public interface B2BiClient : SdkClient {
    /**
     * B2BiClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, B2BiClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "B2Bi",
                "B2BI",
                "b2bi",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, B2BiClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): B2BiClient = DefaultB2BiClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: B2BiEndpointProvider = builder.endpointProvider ?: DefaultB2BiEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: B2BiAuthSchemeProvider = builder.authSchemeProvider ?: DefaultB2BiAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "b2bi"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: B2BiEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: B2BiAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Instantiates a capability based on the specified parameters. A trading capability contains the information required to transform incoming EDI documents into JSON or XML outputs.
     *
     * @sample aws.sdk.kotlin.services.b2bi.samples.CreateCapability.sample
     */
    public suspend fun createCapability(input: CreateCapabilityRequest): CreateCapabilityResponse

    /**
     * Creates a partnership between a customer and a trading partner, based on the supplied parameters. A partnership represents the connection between you and your trading partner. It ties together a profile and one or more trading capabilities.
     *
     * @sample aws.sdk.kotlin.services.b2bi.samples.CreatePartnership.sample
     */
    public suspend fun createPartnership(input: CreatePartnershipRequest): CreatePartnershipResponse

    /**
     * Creates a customer profile. You can have up to five customer profiles, each representing a distinct private network. A profile is the mechanism used to create the concept of a private network.
     *
     * @sample aws.sdk.kotlin.services.b2bi.samples.CreateProfile.sample
     */
    public suspend fun createProfile(input: CreateProfileRequest): CreateProfileResponse

    /**
     * Amazon Web Services B2B Data Interchange uses a mapping template in JSONata or XSLT format to transform a customer input file into a JSON or XML file that can be converted to EDI.
     *
     * If you provide a sample EDI file with the same structure as the EDI files that you wish to generate, then the service can generate a mapping template. The starter template contains placeholder values which you can replace with JSONata or XSLT expressions to take data from your input file and insert it into the JSON or XML file that is used to generate the EDI.
     *
     * If you do not provide a sample EDI file, then the service can generate a mapping template based on the EDI settings in the `templateDetails` parameter.
     *
     *  Currently, we only support generating a template that can generate the input to produce an Outbound X12 EDI file.
     *
     * @sample aws.sdk.kotlin.services.b2bi.samples.CreateStarterMappingTemplate.sample
     */
    public suspend fun createStarterMappingTemplate(input: CreateStarterMappingTemplateRequest): CreateStarterMappingTemplateResponse

    /**
     * Creates a transformer. Amazon Web Services B2B Data Interchange currently supports two scenarios:
     * + *Inbound EDI*: the Amazon Web Services customer receives an EDI file from their trading partner. Amazon Web Services B2B Data Interchange converts this EDI file into a JSON or XML file with a service-defined structure. A mapping template provided by the customer, in JSONata or XSLT format, is optionally applied to this file to produce a JSON or XML file with the structure the customer requires.
     * + *Outbound EDI*: the Amazon Web Services customer has a JSON or XML file containing data that they wish to use in an EDI file. A mapping template, provided by the customer (in either JSONata or XSLT format) is applied to this file to generate a JSON or XML file in the service-defined structure. This file is then converted to an EDI file.
     *
     * The following fields are provided for backwards compatibility only: `fileFormat`, `mappingTemplate`, `ediType`, and `sampleDocument`.
     * + Use the `mapping` data type in place of `mappingTemplate` and `fileFormat`
     * + Use the `sampleDocuments` data type in place of `sampleDocument`
     * + Use either the `inputConversion` or `outputConversion` in place of `ediType`
     *
     * @sample aws.sdk.kotlin.services.b2bi.samples.CreateTransformer.sample
     */
    public suspend fun createTransformer(input: CreateTransformerRequest): CreateTransformerResponse

    /**
     * Deletes the specified capability. A trading capability contains the information required to transform incoming EDI documents into JSON or XML outputs.
     *
     * @sample aws.sdk.kotlin.services.b2bi.samples.DeleteCapability.sample
     */
    public suspend fun deleteCapability(input: DeleteCapabilityRequest): DeleteCapabilityResponse

    /**
     * Deletes the specified partnership. A partnership represents the connection between you and your trading partner. It ties together a profile and one or more trading capabilities.
     *
     * @sample aws.sdk.kotlin.services.b2bi.samples.DeletePartnership.sample
     */
    public suspend fun deletePartnership(input: DeletePartnershipRequest): DeletePartnershipResponse

    /**
     * Deletes the specified profile. A profile is the mechanism used to create the concept of a private network.
     *
     * @sample aws.sdk.kotlin.services.b2bi.samples.DeleteProfile.sample
     */
    public suspend fun deleteProfile(input: DeleteProfileRequest): DeleteProfileResponse

    /**
     * Deletes the specified transformer. A transformer can take an EDI file as input and transform it into a JSON-or XML-formatted document. Alternatively, a transformer can take a JSON-or XML-formatted document as input and transform it into an EDI file.
     *
     * @sample aws.sdk.kotlin.services.b2bi.samples.DeleteTransformer.sample
     */
    public suspend fun deleteTransformer(input: DeleteTransformerRequest): DeleteTransformerResponse

    /**
     * Takes sample input and output documents and uses Amazon Bedrock to generate a mapping automatically. Depending on the accuracy and other factors, you can then edit the mapping for your needs.
     *
     * Before you can use the AI-assisted feature for Amazon Web Services B2B Data Interchange you must enable models in Amazon Bedrock. For details, see [AI-assisted template mapping prerequisites](https://docs.aws.amazon.com/b2bi/latest/userguide/ai-assisted-mapping.html#ai-assist-prereq) in the *Amazon Web Services B2B Data Interchange User guide*.
     *
     * To generate a mapping, perform the following steps:
     * + Start with an X12 EDI document to use as the input.
     * + Call `TestMapping` using your EDI document.
     * + Use the output from the `TestMapping` operation as either input or output for your GenerateMapping call, along with your sample file.
     *
     * @sample aws.sdk.kotlin.services.b2bi.samples.GenerateMapping.sample
     */
    public suspend fun generateMapping(input: GenerateMappingRequest): GenerateMappingResponse

    /**
     * Retrieves the details for the specified capability. A trading capability contains the information required to transform incoming EDI documents into JSON or XML outputs.
     *
     * @sample aws.sdk.kotlin.services.b2bi.samples.GetCapability.sample
     */
    public suspend fun getCapability(input: GetCapabilityRequest): GetCapabilityResponse

    /**
     * Retrieves the details for a partnership, based on the partner and profile IDs specified. A partnership represents the connection between you and your trading partner. It ties together a profile and one or more trading capabilities.
     *
     * @sample aws.sdk.kotlin.services.b2bi.samples.GetPartnership.sample
     */
    public suspend fun getPartnership(input: GetPartnershipRequest): GetPartnershipResponse

    /**
     * Retrieves the details for the profile specified by the profile ID. A profile is the mechanism used to create the concept of a private network.
     *
     * @sample aws.sdk.kotlin.services.b2bi.samples.GetProfile.sample
     */
    public suspend fun getProfile(input: GetProfileRequest): GetProfileResponse

    /**
     * Retrieves the details for the transformer specified by the transformer ID. A transformer can take an EDI file as input and transform it into a JSON-or XML-formatted document. Alternatively, a transformer can take a JSON-or XML-formatted document as input and transform it into an EDI file.
     *
     * @sample aws.sdk.kotlin.services.b2bi.samples.GetTransformer.sample
     */
    public suspend fun getTransformer(input: GetTransformerRequest): GetTransformerResponse

    /**
     * Returns the details of the transformer run, based on the Transformer job ID.
     *
     * If 30 days have elapsed since your transformer job was started, the system deletes it. So, if you run `GetTransformerJob` and supply a `transformerId` and `transformerJobId` for a job that was started more than 30 days previously, you receive a 404 response.
     *
     * @sample aws.sdk.kotlin.services.b2bi.samples.GetTransformerJob.sample
     */
    public suspend fun getTransformerJob(input: GetTransformerJobRequest): GetTransformerJobResponse

    /**
     * Lists the capabilities associated with your Amazon Web Services account for your current or specified region. A trading capability contains the information required to transform incoming EDI documents into JSON or XML outputs.
     *
     * @sample aws.sdk.kotlin.services.b2bi.samples.ListCapabilities.sample
     */
    public suspend fun listCapabilities(input: ListCapabilitiesRequest = ListCapabilitiesRequest { }): ListCapabilitiesResponse

    /**
     * Lists the partnerships associated with your Amazon Web Services account for your current or specified region. A partnership represents the connection between you and your trading partner. It ties together a profile and one or more trading capabilities.
     *
     * @sample aws.sdk.kotlin.services.b2bi.samples.ListPartnerships.sample
     */
    public suspend fun listPartnerships(input: ListPartnershipsRequest = ListPartnershipsRequest { }): ListPartnershipsResponse

    /**
     * Lists the profiles associated with your Amazon Web Services account for your current or specified region. A profile is the mechanism used to create the concept of a private network.
     *
     * @sample aws.sdk.kotlin.services.b2bi.samples.ListProfiles.sample
     */
    public suspend fun listProfiles(input: ListProfilesRequest = ListProfilesRequest { }): ListProfilesResponse

    /**
     * Lists all of the tags associated with the Amazon Resource Name (ARN) that you specify. The resource can be a capability, partnership, profile, or transformer.
     *
     * @sample aws.sdk.kotlin.services.b2bi.samples.ListTagsForResource.sample
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the available transformers. A transformer can take an EDI file as input and transform it into a JSON-or XML-formatted document. Alternatively, a transformer can take a JSON-or XML-formatted document as input and transform it into an EDI file.
     *
     * @sample aws.sdk.kotlin.services.b2bi.samples.ListTransformers.sample
     */
    public suspend fun listTransformers(input: ListTransformersRequest = ListTransformersRequest { }): ListTransformersResponse

    /**
     * Runs a job, using a transformer, to parse input EDI (electronic data interchange) file into the output structures used by Amazon Web Services B2B Data Interchange.
     *
     * If you only want to transform EDI (electronic data interchange) documents, you don't need to create profiles, partnerships or capabilities. Just create and configure a transformer, and then run the `StartTransformerJob` API to process your files.
     *
     * The system stores transformer jobs for 30 days. During that period, you can run [GetTransformerJob](https://docs.aws.amazon.com/b2bi/latest/APIReference/API_GetTransformerJob.html) and supply its `transformerId` and `transformerJobId` to return details of the job.
     *
     * @sample aws.sdk.kotlin.services.b2bi.samples.StartTransformerJob.sample
     */
    public suspend fun startTransformerJob(input: StartTransformerJobRequest): StartTransformerJobResponse

    /**
     * Attaches a key-value pair to a resource, as identified by its Amazon Resource Name (ARN). Resources are capability, partnership, profile, transformers and other entities.
     *
     * There is no response returned from this call.
     *
     * @sample aws.sdk.kotlin.services.b2bi.samples.TagResource.sample
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * This operation mimics the latter half of a typical Outbound EDI request. It takes an input JSON/XML in the B2Bi shape as input, converts it to an X12 EDI string, and return that string.
     *
     * @sample aws.sdk.kotlin.services.b2bi.samples.TestConversion.sample
     */
    public suspend fun testConversion(input: TestConversionRequest): TestConversionResponse

    /**
     * Maps the input file according to the provided template file. The API call downloads the file contents from the Amazon S3 location, and passes the contents in as a string, to the `inputFileContent` parameter.
     *
     * @sample aws.sdk.kotlin.services.b2bi.samples.TestMapping.sample
     */
    public suspend fun testMapping(input: TestMappingRequest): TestMappingResponse

    /**
     * Parses the input EDI (electronic data interchange) file. The input file has a file size limit of 250 KB.
     *
     * @sample aws.sdk.kotlin.services.b2bi.samples.TestParsing.sample
     * @sample aws.sdk.kotlin.services.b2bi.samples.TestParsing.sample2
     * @sample aws.sdk.kotlin.services.b2bi.samples.TestParsing.sample3
     */
    public suspend fun testParsing(input: TestParsingRequest): TestParsingResponse

    /**
     * Detaches a key-value pair from the specified resource, as identified by its Amazon Resource Name (ARN). Resources are capability, partnership, profile, transformers and other entities.
     *
     * @sample aws.sdk.kotlin.services.b2bi.samples.UntagResource.sample
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates some of the parameters for a capability, based on the specified parameters. A trading capability contains the information required to transform incoming EDI documents into JSON or XML outputs.
     *
     * @sample aws.sdk.kotlin.services.b2bi.samples.UpdateCapability.sample
     */
    public suspend fun updateCapability(input: UpdateCapabilityRequest): UpdateCapabilityResponse

    /**
     * Updates some of the parameters for a partnership between a customer and trading partner. A partnership represents the connection between you and your trading partner. It ties together a profile and one or more trading capabilities.
     *
     * @sample aws.sdk.kotlin.services.b2bi.samples.UpdatePartnership.sample
     */
    public suspend fun updatePartnership(input: UpdatePartnershipRequest): UpdatePartnershipResponse

    /**
     * Updates the specified parameters for a profile. A profile is the mechanism used to create the concept of a private network.
     *
     * @sample aws.sdk.kotlin.services.b2bi.samples.UpdateProfile.sample
     */
    public suspend fun updateProfile(input: UpdateProfileRequest): UpdateProfileResponse

    /**
     * Updates the specified parameters for a transformer. A transformer can take an EDI file as input and transform it into a JSON-or XML-formatted document. Alternatively, a transformer can take a JSON-or XML-formatted document as input and transform it into an EDI file.
     *
     * @sample aws.sdk.kotlin.services.b2bi.samples.UpdateTransformer.sample
     */
    public suspend fun updateTransformer(input: UpdateTransformerRequest): UpdateTransformerResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun B2BiClient.withConfig(block: B2BiClient.Config.Builder.() -> Unit): B2BiClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultB2BiClient(newConfig)
}

/**
 * Instantiates a capability based on the specified parameters. A trading capability contains the information required to transform incoming EDI documents into JSON or XML outputs.
 *
 * @sample aws.sdk.kotlin.services.b2bi.samples.CreateCapability.sample
 */
public suspend inline fun B2BiClient.createCapability(crossinline block: CreateCapabilityRequest.Builder.() -> Unit): CreateCapabilityResponse = createCapability(CreateCapabilityRequest.Builder().apply(block).build())

/**
 * Creates a partnership between a customer and a trading partner, based on the supplied parameters. A partnership represents the connection between you and your trading partner. It ties together a profile and one or more trading capabilities.
 *
 * @sample aws.sdk.kotlin.services.b2bi.samples.CreatePartnership.sample
 */
public suspend inline fun B2BiClient.createPartnership(crossinline block: CreatePartnershipRequest.Builder.() -> Unit): CreatePartnershipResponse = createPartnership(CreatePartnershipRequest.Builder().apply(block).build())

/**
 * Creates a customer profile. You can have up to five customer profiles, each representing a distinct private network. A profile is the mechanism used to create the concept of a private network.
 *
 * @sample aws.sdk.kotlin.services.b2bi.samples.CreateProfile.sample
 */
public suspend inline fun B2BiClient.createProfile(crossinline block: CreateProfileRequest.Builder.() -> Unit): CreateProfileResponse = createProfile(CreateProfileRequest.Builder().apply(block).build())

/**
 * Amazon Web Services B2B Data Interchange uses a mapping template in JSONata or XSLT format to transform a customer input file into a JSON or XML file that can be converted to EDI.
 *
 * If you provide a sample EDI file with the same structure as the EDI files that you wish to generate, then the service can generate a mapping template. The starter template contains placeholder values which you can replace with JSONata or XSLT expressions to take data from your input file and insert it into the JSON or XML file that is used to generate the EDI.
 *
 * If you do not provide a sample EDI file, then the service can generate a mapping template based on the EDI settings in the `templateDetails` parameter.
 *
 *  Currently, we only support generating a template that can generate the input to produce an Outbound X12 EDI file.
 *
 * @sample aws.sdk.kotlin.services.b2bi.samples.CreateStarterMappingTemplate.sample
 */
public suspend inline fun B2BiClient.createStarterMappingTemplate(crossinline block: CreateStarterMappingTemplateRequest.Builder.() -> Unit): CreateStarterMappingTemplateResponse = createStarterMappingTemplate(CreateStarterMappingTemplateRequest.Builder().apply(block).build())

/**
 * Creates a transformer. Amazon Web Services B2B Data Interchange currently supports two scenarios:
 * + *Inbound EDI*: the Amazon Web Services customer receives an EDI file from their trading partner. Amazon Web Services B2B Data Interchange converts this EDI file into a JSON or XML file with a service-defined structure. A mapping template provided by the customer, in JSONata or XSLT format, is optionally applied to this file to produce a JSON or XML file with the structure the customer requires.
 * + *Outbound EDI*: the Amazon Web Services customer has a JSON or XML file containing data that they wish to use in an EDI file. A mapping template, provided by the customer (in either JSONata or XSLT format) is applied to this file to generate a JSON or XML file in the service-defined structure. This file is then converted to an EDI file.
 *
 * The following fields are provided for backwards compatibility only: `fileFormat`, `mappingTemplate`, `ediType`, and `sampleDocument`.
 * + Use the `mapping` data type in place of `mappingTemplate` and `fileFormat`
 * + Use the `sampleDocuments` data type in place of `sampleDocument`
 * + Use either the `inputConversion` or `outputConversion` in place of `ediType`
 *
 * @sample aws.sdk.kotlin.services.b2bi.samples.CreateTransformer.sample
 */
public suspend inline fun B2BiClient.createTransformer(crossinline block: CreateTransformerRequest.Builder.() -> Unit): CreateTransformerResponse = createTransformer(CreateTransformerRequest.Builder().apply(block).build())

/**
 * Deletes the specified capability. A trading capability contains the information required to transform incoming EDI documents into JSON or XML outputs.
 *
 * @sample aws.sdk.kotlin.services.b2bi.samples.DeleteCapability.sample
 */
public suspend inline fun B2BiClient.deleteCapability(crossinline block: DeleteCapabilityRequest.Builder.() -> Unit): DeleteCapabilityResponse = deleteCapability(DeleteCapabilityRequest.Builder().apply(block).build())

/**
 * Deletes the specified partnership. A partnership represents the connection between you and your trading partner. It ties together a profile and one or more trading capabilities.
 *
 * @sample aws.sdk.kotlin.services.b2bi.samples.DeletePartnership.sample
 */
public suspend inline fun B2BiClient.deletePartnership(crossinline block: DeletePartnershipRequest.Builder.() -> Unit): DeletePartnershipResponse = deletePartnership(DeletePartnershipRequest.Builder().apply(block).build())

/**
 * Deletes the specified profile. A profile is the mechanism used to create the concept of a private network.
 *
 * @sample aws.sdk.kotlin.services.b2bi.samples.DeleteProfile.sample
 */
public suspend inline fun B2BiClient.deleteProfile(crossinline block: DeleteProfileRequest.Builder.() -> Unit): DeleteProfileResponse = deleteProfile(DeleteProfileRequest.Builder().apply(block).build())

/**
 * Deletes the specified transformer. A transformer can take an EDI file as input and transform it into a JSON-or XML-formatted document. Alternatively, a transformer can take a JSON-or XML-formatted document as input and transform it into an EDI file.
 *
 * @sample aws.sdk.kotlin.services.b2bi.samples.DeleteTransformer.sample
 */
public suspend inline fun B2BiClient.deleteTransformer(crossinline block: DeleteTransformerRequest.Builder.() -> Unit): DeleteTransformerResponse = deleteTransformer(DeleteTransformerRequest.Builder().apply(block).build())

/**
 * Takes sample input and output documents and uses Amazon Bedrock to generate a mapping automatically. Depending on the accuracy and other factors, you can then edit the mapping for your needs.
 *
 * Before you can use the AI-assisted feature for Amazon Web Services B2B Data Interchange you must enable models in Amazon Bedrock. For details, see [AI-assisted template mapping prerequisites](https://docs.aws.amazon.com/b2bi/latest/userguide/ai-assisted-mapping.html#ai-assist-prereq) in the *Amazon Web Services B2B Data Interchange User guide*.
 *
 * To generate a mapping, perform the following steps:
 * + Start with an X12 EDI document to use as the input.
 * + Call `TestMapping` using your EDI document.
 * + Use the output from the `TestMapping` operation as either input or output for your GenerateMapping call, along with your sample file.
 *
 * @sample aws.sdk.kotlin.services.b2bi.samples.GenerateMapping.sample
 */
public suspend inline fun B2BiClient.generateMapping(crossinline block: GenerateMappingRequest.Builder.() -> Unit): GenerateMappingResponse = generateMapping(GenerateMappingRequest.Builder().apply(block).build())

/**
 * Retrieves the details for the specified capability. A trading capability contains the information required to transform incoming EDI documents into JSON or XML outputs.
 *
 * @sample aws.sdk.kotlin.services.b2bi.samples.GetCapability.sample
 */
public suspend inline fun B2BiClient.getCapability(crossinline block: GetCapabilityRequest.Builder.() -> Unit): GetCapabilityResponse = getCapability(GetCapabilityRequest.Builder().apply(block).build())

/**
 * Retrieves the details for a partnership, based on the partner and profile IDs specified. A partnership represents the connection between you and your trading partner. It ties together a profile and one or more trading capabilities.
 *
 * @sample aws.sdk.kotlin.services.b2bi.samples.GetPartnership.sample
 */
public suspend inline fun B2BiClient.getPartnership(crossinline block: GetPartnershipRequest.Builder.() -> Unit): GetPartnershipResponse = getPartnership(GetPartnershipRequest.Builder().apply(block).build())

/**
 * Retrieves the details for the profile specified by the profile ID. A profile is the mechanism used to create the concept of a private network.
 *
 * @sample aws.sdk.kotlin.services.b2bi.samples.GetProfile.sample
 */
public suspend inline fun B2BiClient.getProfile(crossinline block: GetProfileRequest.Builder.() -> Unit): GetProfileResponse = getProfile(GetProfileRequest.Builder().apply(block).build())

/**
 * Retrieves the details for the transformer specified by the transformer ID. A transformer can take an EDI file as input and transform it into a JSON-or XML-formatted document. Alternatively, a transformer can take a JSON-or XML-formatted document as input and transform it into an EDI file.
 *
 * @sample aws.sdk.kotlin.services.b2bi.samples.GetTransformer.sample
 */
public suspend inline fun B2BiClient.getTransformer(crossinline block: GetTransformerRequest.Builder.() -> Unit): GetTransformerResponse = getTransformer(GetTransformerRequest.Builder().apply(block).build())

/**
 * Returns the details of the transformer run, based on the Transformer job ID.
 *
 * If 30 days have elapsed since your transformer job was started, the system deletes it. So, if you run `GetTransformerJob` and supply a `transformerId` and `transformerJobId` for a job that was started more than 30 days previously, you receive a 404 response.
 *
 * @sample aws.sdk.kotlin.services.b2bi.samples.GetTransformerJob.sample
 */
public suspend inline fun B2BiClient.getTransformerJob(crossinline block: GetTransformerJobRequest.Builder.() -> Unit): GetTransformerJobResponse = getTransformerJob(GetTransformerJobRequest.Builder().apply(block).build())

/**
 * Lists the capabilities associated with your Amazon Web Services account for your current or specified region. A trading capability contains the information required to transform incoming EDI documents into JSON or XML outputs.
 *
 * @sample aws.sdk.kotlin.services.b2bi.samples.ListCapabilities.sample
 */
public suspend inline fun B2BiClient.listCapabilities(crossinline block: ListCapabilitiesRequest.Builder.() -> Unit): ListCapabilitiesResponse = listCapabilities(ListCapabilitiesRequest.Builder().apply(block).build())

/**
 * Lists the partnerships associated with your Amazon Web Services account for your current or specified region. A partnership represents the connection between you and your trading partner. It ties together a profile and one or more trading capabilities.
 *
 * @sample aws.sdk.kotlin.services.b2bi.samples.ListPartnerships.sample
 */
public suspend inline fun B2BiClient.listPartnerships(crossinline block: ListPartnershipsRequest.Builder.() -> Unit): ListPartnershipsResponse = listPartnerships(ListPartnershipsRequest.Builder().apply(block).build())

/**
 * Lists the profiles associated with your Amazon Web Services account for your current or specified region. A profile is the mechanism used to create the concept of a private network.
 *
 * @sample aws.sdk.kotlin.services.b2bi.samples.ListProfiles.sample
 */
public suspend inline fun B2BiClient.listProfiles(crossinline block: ListProfilesRequest.Builder.() -> Unit): ListProfilesResponse = listProfiles(ListProfilesRequest.Builder().apply(block).build())

/**
 * Lists all of the tags associated with the Amazon Resource Name (ARN) that you specify. The resource can be a capability, partnership, profile, or transformer.
 *
 * @sample aws.sdk.kotlin.services.b2bi.samples.ListTagsForResource.sample
 */
public suspend inline fun B2BiClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists the available transformers. A transformer can take an EDI file as input and transform it into a JSON-or XML-formatted document. Alternatively, a transformer can take a JSON-or XML-formatted document as input and transform it into an EDI file.
 *
 * @sample aws.sdk.kotlin.services.b2bi.samples.ListTransformers.sample
 */
public suspend inline fun B2BiClient.listTransformers(crossinline block: ListTransformersRequest.Builder.() -> Unit): ListTransformersResponse = listTransformers(ListTransformersRequest.Builder().apply(block).build())

/**
 * Runs a job, using a transformer, to parse input EDI (electronic data interchange) file into the output structures used by Amazon Web Services B2B Data Interchange.
 *
 * If you only want to transform EDI (electronic data interchange) documents, you don't need to create profiles, partnerships or capabilities. Just create and configure a transformer, and then run the `StartTransformerJob` API to process your files.
 *
 * The system stores transformer jobs for 30 days. During that period, you can run [GetTransformerJob](https://docs.aws.amazon.com/b2bi/latest/APIReference/API_GetTransformerJob.html) and supply its `transformerId` and `transformerJobId` to return details of the job.
 *
 * @sample aws.sdk.kotlin.services.b2bi.samples.StartTransformerJob.sample
 */
public suspend inline fun B2BiClient.startTransformerJob(crossinline block: StartTransformerJobRequest.Builder.() -> Unit): StartTransformerJobResponse = startTransformerJob(StartTransformerJobRequest.Builder().apply(block).build())

/**
 * Attaches a key-value pair to a resource, as identified by its Amazon Resource Name (ARN). Resources are capability, partnership, profile, transformers and other entities.
 *
 * There is no response returned from this call.
 *
 * @sample aws.sdk.kotlin.services.b2bi.samples.TagResource.sample
 */
public suspend inline fun B2BiClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * This operation mimics the latter half of a typical Outbound EDI request. It takes an input JSON/XML in the B2Bi shape as input, converts it to an X12 EDI string, and return that string.
 *
 * @sample aws.sdk.kotlin.services.b2bi.samples.TestConversion.sample
 */
public suspend inline fun B2BiClient.testConversion(crossinline block: TestConversionRequest.Builder.() -> Unit): TestConversionResponse = testConversion(TestConversionRequest.Builder().apply(block).build())

/**
 * Maps the input file according to the provided template file. The API call downloads the file contents from the Amazon S3 location, and passes the contents in as a string, to the `inputFileContent` parameter.
 *
 * @sample aws.sdk.kotlin.services.b2bi.samples.TestMapping.sample
 */
public suspend inline fun B2BiClient.testMapping(crossinline block: TestMappingRequest.Builder.() -> Unit): TestMappingResponse = testMapping(TestMappingRequest.Builder().apply(block).build())

/**
 * Parses the input EDI (electronic data interchange) file. The input file has a file size limit of 250 KB.
 *
 * @sample aws.sdk.kotlin.services.b2bi.samples.TestParsing.sample
 * @sample aws.sdk.kotlin.services.b2bi.samples.TestParsing.sample2
 * @sample aws.sdk.kotlin.services.b2bi.samples.TestParsing.sample3
 */
public suspend inline fun B2BiClient.testParsing(crossinline block: TestParsingRequest.Builder.() -> Unit): TestParsingResponse = testParsing(TestParsingRequest.Builder().apply(block).build())

/**
 * Detaches a key-value pair from the specified resource, as identified by its Amazon Resource Name (ARN). Resources are capability, partnership, profile, transformers and other entities.
 *
 * @sample aws.sdk.kotlin.services.b2bi.samples.UntagResource.sample
 */
public suspend inline fun B2BiClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates some of the parameters for a capability, based on the specified parameters. A trading capability contains the information required to transform incoming EDI documents into JSON or XML outputs.
 *
 * @sample aws.sdk.kotlin.services.b2bi.samples.UpdateCapability.sample
 */
public suspend inline fun B2BiClient.updateCapability(crossinline block: UpdateCapabilityRequest.Builder.() -> Unit): UpdateCapabilityResponse = updateCapability(UpdateCapabilityRequest.Builder().apply(block).build())

/**
 * Updates some of the parameters for a partnership between a customer and trading partner. A partnership represents the connection between you and your trading partner. It ties together a profile and one or more trading capabilities.
 *
 * @sample aws.sdk.kotlin.services.b2bi.samples.UpdatePartnership.sample
 */
public suspend inline fun B2BiClient.updatePartnership(crossinline block: UpdatePartnershipRequest.Builder.() -> Unit): UpdatePartnershipResponse = updatePartnership(UpdatePartnershipRequest.Builder().apply(block).build())

/**
 * Updates the specified parameters for a profile. A profile is the mechanism used to create the concept of a private network.
 *
 * @sample aws.sdk.kotlin.services.b2bi.samples.UpdateProfile.sample
 */
public suspend inline fun B2BiClient.updateProfile(crossinline block: UpdateProfileRequest.Builder.() -> Unit): UpdateProfileResponse = updateProfile(UpdateProfileRequest.Builder().apply(block).build())

/**
 * Updates the specified parameters for a transformer. A transformer can take an EDI file as input and transform it into a JSON-or XML-formatted document. Alternatively, a transformer can take a JSON-or XML-formatted document as input and transform it into an EDI file.
 *
 * @sample aws.sdk.kotlin.services.b2bi.samples.UpdateTransformer.sample
 */
public suspend inline fun B2BiClient.updateTransformer(crossinline block: UpdateTransformerRequest.Builder.() -> Unit): UpdateTransformerResponse = updateTransformer(UpdateTransformerRequest.Builder().apply(block).build())
