// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.b2bi.serde

import aws.sdk.kotlin.services.b2bi.model.B2BiException
import aws.sdk.kotlin.services.b2bi.model.CapabilityOptions
import aws.sdk.kotlin.services.b2bi.model.UpdatePartnershipResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class UpdatePartnershipOperationDeserializer: HttpDeserializer.NonStreaming<UpdatePartnershipResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdatePartnershipResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdatePartnershipError(context, call, payload)
        }
        val builder = UpdatePartnershipResponse.Builder()

        if (payload != null) {
            deserializeUpdatePartnershipOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdatePartnershipError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw B2BiException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> B2BiException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdatePartnershipOperationBody(builder: UpdatePartnershipResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CAPABILITIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("capabilities"))
    val CAPABILITYOPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("capabilityOptions"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val EMAIL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("email"))
    val MODIFIEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("modifiedAt"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val PARTNERSHIPARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("partnershipArn"))
    val PARTNERSHIPID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("partnershipId"))
    val PHONE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("phone"))
    val PROFILEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("profileId"))
    val TRADINGPARTNERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("tradingPartnerId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CAPABILITIES_DESCRIPTOR)
        field(CAPABILITYOPTIONS_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(EMAIL_DESCRIPTOR)
        field(MODIFIEDAT_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PARTNERSHIPARN_DESCRIPTOR)
        field(PARTNERSHIPID_DESCRIPTOR)
        field(PHONE_DESCRIPTOR)
        field(PROFILEID_DESCRIPTOR)
        field(TRADINGPARTNERID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CAPABILITIES_DESCRIPTOR.index -> builder.capabilities =
                    deserializer.deserializeList(CAPABILITIES_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CAPABILITYOPTIONS_DESCRIPTOR.index -> builder.capabilityOptions = deserializeCapabilityOptionsDocument(deserializer)
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeInstant(TimestampFormat.ISO_8601)
                EMAIL_DESCRIPTOR.index -> builder.email = deserializeString()
                MODIFIEDAT_DESCRIPTOR.index -> builder.modifiedAt = deserializeInstant(TimestampFormat.ISO_8601)
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                PARTNERSHIPARN_DESCRIPTOR.index -> builder.partnershipArn = deserializeString()
                PARTNERSHIPID_DESCRIPTOR.index -> builder.partnershipId = deserializeString()
                PHONE_DESCRIPTOR.index -> builder.phone = deserializeString()
                PROFILEID_DESCRIPTOR.index -> builder.profileId = deserializeString()
                TRADINGPARTNERID_DESCRIPTOR.index -> builder.tradingPartnerId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
