// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.b2bi.serde

import aws.sdk.kotlin.services.b2bi.model.B2BiException
import aws.sdk.kotlin.services.b2bi.model.CapabilityConfiguration
import aws.sdk.kotlin.services.b2bi.model.CapabilityType
import aws.sdk.kotlin.services.b2bi.model.CreateCapabilityResponse
import aws.sdk.kotlin.services.b2bi.model.S3Location
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class CreateCapabilityOperationDeserializer: HttpDeserializer.NonStreaming<CreateCapabilityResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateCapabilityResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateCapabilityError(context, call, payload)
        }
        val builder = CreateCapabilityResponse.Builder()

        if (payload != null) {
            deserializeCreateCapabilityOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateCapabilityError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw B2BiException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> B2BiException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateCapabilityOperationBody(builder: CreateCapabilityResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CAPABILITYARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("capabilityArn"))
    val CAPABILITYID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("capabilityId"))
    val CONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("configuration"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val INSTRUCTIONSDOCUMENTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("instructionsDocuments"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("type"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CAPABILITYARN_DESCRIPTOR)
        field(CAPABILITYID_DESCRIPTOR)
        field(CONFIGURATION_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(INSTRUCTIONSDOCUMENTS_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CAPABILITYARN_DESCRIPTOR.index -> builder.capabilityArn = deserializeString()
                CAPABILITYID_DESCRIPTOR.index -> builder.capabilityId = deserializeString()
                CONFIGURATION_DESCRIPTOR.index -> builder.configuration = deserializeCapabilityConfigurationDocument(deserializer)
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeInstant(TimestampFormat.ISO_8601)
                INSTRUCTIONSDOCUMENTS_DESCRIPTOR.index -> builder.instructionsDocuments =
                    deserializer.deserializeList(INSTRUCTIONSDOCUMENTS_DESCRIPTOR) {
                        val col0 = mutableListOf<S3Location>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeS3LocationDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                TYPE_DESCRIPTOR.index -> builder.type = deserializeString().let { CapabilityType.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
