// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.b2bi.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A wrapper structure for an X12 definition object.
 *
 * the X12 envelope ensures the integrity of the data and the efficiency of the information exchange. The X12 message structure has hierarchical levels. From highest to the lowest, they are:
 * + Interchange Envelope
 * + Functional Group
 * + Transaction Set
 */
public class X12Envelope private constructor(builder: Builder) {
    /**
     * A container for the X12 outbound EDI headers.
     */
    public val common: aws.sdk.kotlin.services.b2bi.model.X12OutboundEdiHeaders? = builder.common
    /**
     * Contains options for wrapping (line folding) in X12 EDI files. Wrapping controls how long lines are handled in the EDI output.
     */
    public val wrapOptions: aws.sdk.kotlin.services.b2bi.model.WrapOptions? = builder.wrapOptions

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.b2bi.model.X12Envelope = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("X12Envelope(")
        append("common=$common,")
        append("wrapOptions=$wrapOptions")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = common?.hashCode() ?: 0
        result = 31 * result + (wrapOptions?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as X12Envelope

        if (common != other.common) return false
        if (wrapOptions != other.wrapOptions) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.b2bi.model.X12Envelope = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A container for the X12 outbound EDI headers.
         */
        public var common: aws.sdk.kotlin.services.b2bi.model.X12OutboundEdiHeaders? = null
        /**
         * Contains options for wrapping (line folding) in X12 EDI files. Wrapping controls how long lines are handled in the EDI output.
         */
        public var wrapOptions: aws.sdk.kotlin.services.b2bi.model.WrapOptions? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.b2bi.model.X12Envelope) : this() {
            this.common = x.common
            this.wrapOptions = x.wrapOptions
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.b2bi.model.X12Envelope = X12Envelope(this)

        /**
         * construct an [aws.sdk.kotlin.services.b2bi.model.X12OutboundEdiHeaders] inside the given [block]
         */
        public fun common(block: aws.sdk.kotlin.services.b2bi.model.X12OutboundEdiHeaders.Builder.() -> kotlin.Unit) {
            this.common = aws.sdk.kotlin.services.b2bi.model.X12OutboundEdiHeaders.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.b2bi.model.WrapOptions] inside the given [block]
         */
        public fun wrapOptions(block: aws.sdk.kotlin.services.b2bi.model.WrapOptions.Builder.() -> kotlin.Unit) {
            this.wrapOptions = aws.sdk.kotlin.services.b2bi.model.WrapOptions.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
