// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.b2bi.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains configuration for X12 control numbers used in X12 EDI generation. Control numbers are used to uniquely identify interchanges, functional groups, and transaction sets.
 */
public class X12ControlNumbers private constructor(builder: Builder) {
    /**
     * Specifies the starting functional group control number (GS06) to use for X12 EDI generation. This number is incremented for each new functional group. For the GS (functional group) envelope, Amazon Web Services B2B Data Interchange generates a functional group control number that is unique to the sender ID, receiver ID, and functional identifier code combination.
     */
    public val startingFunctionalGroupControlNumber: kotlin.Int? = builder.startingFunctionalGroupControlNumber
    /**
     * Specifies the starting interchange control number (ISA13) to use for X12 EDI generation. This number is incremented for each new interchange. For the ISA (interchange) envelope, Amazon Web Services B2B Data Interchange generates an interchange control number that is unique for the ISA05 and ISA06 (sender) & ISA07 and ISA08 (receiver) combination.
     */
    public val startingInterchangeControlNumber: kotlin.Int? = builder.startingInterchangeControlNumber
    /**
     * Specifies the starting transaction set control number (ST02) to use for X12 EDI generation. This number is incremented for each new transaction set.
     */
    public val startingTransactionSetControlNumber: kotlin.Int? = builder.startingTransactionSetControlNumber

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.b2bi.model.X12ControlNumbers = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("X12ControlNumbers(")
        append("startingFunctionalGroupControlNumber=$startingFunctionalGroupControlNumber,")
        append("startingInterchangeControlNumber=$startingInterchangeControlNumber,")
        append("startingTransactionSetControlNumber=$startingTransactionSetControlNumber")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = startingFunctionalGroupControlNumber ?: 0
        result = 31 * result + (startingInterchangeControlNumber ?: 0)
        result = 31 * result + (startingTransactionSetControlNumber ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as X12ControlNumbers

        if (startingFunctionalGroupControlNumber != other.startingFunctionalGroupControlNumber) return false
        if (startingInterchangeControlNumber != other.startingInterchangeControlNumber) return false
        if (startingTransactionSetControlNumber != other.startingTransactionSetControlNumber) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.b2bi.model.X12ControlNumbers = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the starting functional group control number (GS06) to use for X12 EDI generation. This number is incremented for each new functional group. For the GS (functional group) envelope, Amazon Web Services B2B Data Interchange generates a functional group control number that is unique to the sender ID, receiver ID, and functional identifier code combination.
         */
        public var startingFunctionalGroupControlNumber: kotlin.Int? = null
        /**
         * Specifies the starting interchange control number (ISA13) to use for X12 EDI generation. This number is incremented for each new interchange. For the ISA (interchange) envelope, Amazon Web Services B2B Data Interchange generates an interchange control number that is unique for the ISA05 and ISA06 (sender) & ISA07 and ISA08 (receiver) combination.
         */
        public var startingInterchangeControlNumber: kotlin.Int? = null
        /**
         * Specifies the starting transaction set control number (ST02) to use for X12 EDI generation. This number is incremented for each new transaction set.
         */
        public var startingTransactionSetControlNumber: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.b2bi.model.X12ControlNumbers) : this() {
            this.startingFunctionalGroupControlNumber = x.startingFunctionalGroupControlNumber
            this.startingInterchangeControlNumber = x.startingInterchangeControlNumber
            this.startingTransactionSetControlNumber = x.startingTransactionSetControlNumber
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.b2bi.model.X12ControlNumbers = X12ControlNumbers(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
