// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.b2bi.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class UpdateCapabilityResponse private constructor(builder: Builder) {
    /**
     * Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a capability, partnership, profile, or transformer.
     */
    public val capabilityArn: kotlin.String = requireNotNull(builder.capabilityArn) { "A non-null value must be provided for capabilityArn" }
    /**
     * Returns a system-assigned unique identifier for the capability.
     */
    public val capabilityId: kotlin.String = requireNotNull(builder.capabilityId) { "A non-null value must be provided for capabilityId" }
    /**
     * Returns a structure that contains the details for a capability.
     */
    public val configuration: aws.sdk.kotlin.services.b2bi.model.CapabilityConfiguration? = builder.configuration
    /**
     * Returns a timestamp for creation date and time of the capability.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * Returns one or more locations in Amazon S3, each specifying an EDI document that can be used with this capability. Each item contains the name of the bucket and the key, to identify the document's location.
     */
    public val instructionsDocuments: List<S3Location>? = builder.instructionsDocuments
    /**
     * Returns a timestamp for last time the capability was modified.
     */
    public val modifiedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.modifiedAt
    /**
     * Returns the name of the capability, used to identify it.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Returns the type of the capability. Currently, only `edi` is supported.
     */
    public val type: aws.sdk.kotlin.services.b2bi.model.CapabilityType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.b2bi.model.UpdateCapabilityResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateCapabilityResponse(")
        append("capabilityArn=$capabilityArn,")
        append("capabilityId=$capabilityId,")
        append("configuration=$configuration,")
        append("createdAt=$createdAt,")
        append("instructionsDocuments=$instructionsDocuments,")
        append("modifiedAt=$modifiedAt,")
        append("name=$name,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = capabilityArn.hashCode()
        result = 31 * result + (capabilityId.hashCode())
        result = 31 * result + (configuration?.hashCode() ?: 0)
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (instructionsDocuments?.hashCode() ?: 0)
        result = 31 * result + (modifiedAt?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateCapabilityResponse

        if (capabilityArn != other.capabilityArn) return false
        if (capabilityId != other.capabilityId) return false
        if (configuration != other.configuration) return false
        if (createdAt != other.createdAt) return false
        if (instructionsDocuments != other.instructionsDocuments) return false
        if (modifiedAt != other.modifiedAt) return false
        if (name != other.name) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.b2bi.model.UpdateCapabilityResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a capability, partnership, profile, or transformer.
         */
        public var capabilityArn: kotlin.String? = null
        /**
         * Returns a system-assigned unique identifier for the capability.
         */
        public var capabilityId: kotlin.String? = null
        /**
         * Returns a structure that contains the details for a capability.
         */
        public var configuration: aws.sdk.kotlin.services.b2bi.model.CapabilityConfiguration? = null
        /**
         * Returns a timestamp for creation date and time of the capability.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Returns one or more locations in Amazon S3, each specifying an EDI document that can be used with this capability. Each item contains the name of the bucket and the key, to identify the document's location.
         */
        public var instructionsDocuments: List<S3Location>? = null
        /**
         * Returns a timestamp for last time the capability was modified.
         */
        public var modifiedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Returns the name of the capability, used to identify it.
         */
        public var name: kotlin.String? = null
        /**
         * Returns the type of the capability. Currently, only `edi` is supported.
         */
        public var type: aws.sdk.kotlin.services.b2bi.model.CapabilityType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.b2bi.model.UpdateCapabilityResponse) : this() {
            this.capabilityArn = x.capabilityArn
            this.capabilityId = x.capabilityId
            this.configuration = x.configuration
            this.createdAt = x.createdAt
            this.instructionsDocuments = x.instructionsDocuments
            this.modifiedAt = x.modifiedAt
            this.name = x.name
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.b2bi.model.UpdateCapabilityResponse = UpdateCapabilityResponse(this)

        internal fun correctErrors(): Builder {
            if (capabilityArn == null) capabilityArn = ""
            if (capabilityId == null) capabilityId = ""
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (name == null) name = ""
            if (type == null) type = CapabilityType.SdkUnknown("no value provided")
            return this
        }
    }
}
