// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.b2bi.model

import aws.smithy.kotlin.runtime.ErrorMetadata
import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * The request was denied due to throttling: the data speed and rendering may be limited depending on various parameters and conditions.
 */
public class ThrottlingException private constructor(builder: Builder) : B2BiException(builder.message) {

    /**
     * The server attempts to retry a command that was throttled.
     */
    public val retryAfterSeconds: kotlin.Int? = builder.retryAfterSeconds

    init {
        sdkErrorMetadata.attributes[ErrorMetadata.Retryable] = true
        sdkErrorMetadata.attributes[ErrorMetadata.ThrottlingError] = false
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.b2bi.model.ThrottlingException = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ThrottlingException(")
        append("message=$message,")
        append("retryAfterSeconds=$retryAfterSeconds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = message.hashCode()
        result = 31 * result + (retryAfterSeconds ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ThrottlingException

        if (message != other.message) return false
        if (retryAfterSeconds != other.retryAfterSeconds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.b2bi.model.ThrottlingException = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        public var message: kotlin.String? = null
        /**
         * The server attempts to retry a command that was throttled.
         */
        public var retryAfterSeconds: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.b2bi.model.ThrottlingException) : this() {
            this.message = x.message
            this.retryAfterSeconds = x.retryAfterSeconds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.b2bi.model.ThrottlingException = ThrottlingException(this)

        internal fun correctErrors(): Builder {
            if (message == null) message = ""
            return this
        }
    }
}
