// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.b2bi.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Specifies the details for the EDI (electronic data interchange) transformation.
 */
public class EdiConfiguration private constructor(builder: Builder) {
    /**
     * Specifies whether this is capability is for inbound or outbound transformations.
     */
    public val capabilityDirection: aws.sdk.kotlin.services.b2bi.model.CapabilityDirection? = builder.capabilityDirection
    /**
     * Contains the Amazon S3 bucket and prefix for the location of the input file, which is contained in an `S3Location` object.
     */
    public val inputLocation: aws.sdk.kotlin.services.b2bi.model.S3Location? = builder.inputLocation
    /**
     * Contains the Amazon S3 bucket and prefix for the location of the output file, which is contained in an `S3Location` object.
     */
    public val outputLocation: aws.sdk.kotlin.services.b2bi.model.S3Location? = builder.outputLocation
    /**
     * Returns the system-assigned unique identifier for the transformer.
     */
    public val transformerId: kotlin.String = requireNotNull(builder.transformerId) { "A non-null value must be provided for transformerId" }
    /**
     * Returns the type of the capability. Currently, only `edi` is supported.
     */
    public val type: aws.sdk.kotlin.services.b2bi.model.EdiType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.b2bi.model.EdiConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EdiConfiguration(")
        append("capabilityDirection=$capabilityDirection,")
        append("inputLocation=$inputLocation,")
        append("outputLocation=$outputLocation,")
        append("transformerId=$transformerId,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = capabilityDirection?.hashCode() ?: 0
        result = 31 * result + (inputLocation?.hashCode() ?: 0)
        result = 31 * result + (outputLocation?.hashCode() ?: 0)
        result = 31 * result + (transformerId.hashCode())
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EdiConfiguration

        if (capabilityDirection != other.capabilityDirection) return false
        if (inputLocation != other.inputLocation) return false
        if (outputLocation != other.outputLocation) return false
        if (transformerId != other.transformerId) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.b2bi.model.EdiConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies whether this is capability is for inbound or outbound transformations.
         */
        public var capabilityDirection: aws.sdk.kotlin.services.b2bi.model.CapabilityDirection? = null
        /**
         * Contains the Amazon S3 bucket and prefix for the location of the input file, which is contained in an `S3Location` object.
         */
        public var inputLocation: aws.sdk.kotlin.services.b2bi.model.S3Location? = null
        /**
         * Contains the Amazon S3 bucket and prefix for the location of the output file, which is contained in an `S3Location` object.
         */
        public var outputLocation: aws.sdk.kotlin.services.b2bi.model.S3Location? = null
        /**
         * Returns the system-assigned unique identifier for the transformer.
         */
        public var transformerId: kotlin.String? = null
        /**
         * Returns the type of the capability. Currently, only `edi` is supported.
         */
        public var type: aws.sdk.kotlin.services.b2bi.model.EdiType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.b2bi.model.EdiConfiguration) : this() {
            this.capabilityDirection = x.capabilityDirection
            this.inputLocation = x.inputLocation
            this.outputLocation = x.outputLocation
            this.transformerId = x.transformerId
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.b2bi.model.EdiConfiguration = EdiConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.b2bi.model.S3Location] inside the given [block]
         */
        public fun inputLocation(block: aws.sdk.kotlin.services.b2bi.model.S3Location.Builder.() -> kotlin.Unit) {
            this.inputLocation = aws.sdk.kotlin.services.b2bi.model.S3Location.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.b2bi.model.S3Location] inside the given [block]
         */
        public fun outputLocation(block: aws.sdk.kotlin.services.b2bi.model.S3Location.Builder.() -> kotlin.Unit) {
            this.outputLocation = aws.sdk.kotlin.services.b2bi.model.S3Location.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (transformerId == null) transformerId = ""
            return this
        }
    }
}
