// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.b2bi.waiters

import aws.sdk.kotlin.services.b2bi.B2BiClient
import aws.sdk.kotlin.services.b2bi.model.GetTransformerJobRequest
import aws.sdk.kotlin.services.b2bi.model.GetTransformerJobResponse
import aws.smithy.kotlin.runtime.retries.Outcome
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.delay.InfiniteTokenBucket
import aws.smithy.kotlin.runtime.retries.policy.Acceptor
import aws.smithy.kotlin.runtime.retries.policy.AcceptorRetryPolicy
import aws.smithy.kotlin.runtime.retries.policy.OutputAcceptor
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective
import kotlin.time.Duration.Companion.milliseconds


public suspend fun B2BiClient.waitUntilTransformerJobSucceeded(request: GetTransformerJobRequest, retryStrategy: RetryStrategy? = null): Outcome<GetTransformerJobResponse> {
    val strategy = retryStrategy ?: StandardRetryStrategy {
        maxAttempts = 20
        tokenBucket = InfiniteTokenBucket
        delayProvider {
            initialDelay = 10_000.milliseconds
            scaleFactor = 1.5
            jitter = 1.0
            maxBackoff = 120_000.milliseconds
        }
    }

    val acceptors = listOf<Acceptor<GetTransformerJobRequest, GetTransformerJobResponse>>(
        OutputAcceptor(RetryDirective.TerminateAndSucceed) {
            val status = it.status?.value
            status == "succeeded"
        },
        OutputAcceptor(RetryDirective.TerminateAndFail) {
            val status = it.status?.value
            status == "failed"
        },
    )

    val policy = AcceptorRetryPolicy(request, acceptors)
    return strategy.retry(policy) { getTransformerJob(request) }
}

public suspend fun B2BiClient.waitUntilTransformerJobSucceeded(block: GetTransformerJobRequest.Builder.() -> Unit): Outcome<GetTransformerJobResponse> =
    waitUntilTransformerJobSucceeded(GetTransformerJobRequest.Builder().apply(block).build())
