// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.b2bi.paginators

import aws.sdk.kotlin.services.b2bi.B2BiClient
import aws.sdk.kotlin.services.b2bi.model.CapabilitySummary
import aws.sdk.kotlin.services.b2bi.model.ListCapabilitiesRequest
import aws.sdk.kotlin.services.b2bi.model.ListCapabilitiesResponse
import aws.sdk.kotlin.services.b2bi.model.ListPartnershipsRequest
import aws.sdk.kotlin.services.b2bi.model.ListPartnershipsResponse
import aws.sdk.kotlin.services.b2bi.model.ListProfilesRequest
import aws.sdk.kotlin.services.b2bi.model.ListProfilesResponse
import aws.sdk.kotlin.services.b2bi.model.ListTransformersRequest
import aws.sdk.kotlin.services.b2bi.model.ListTransformersResponse
import aws.sdk.kotlin.services.b2bi.model.PartnershipSummary
import aws.sdk.kotlin.services.b2bi.model.ProfileSummary
import aws.sdk.kotlin.services.b2bi.model.TransformerSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListCapabilitiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCapabilitiesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCapabilitiesResponse]
 */
public fun B2BiClient.listCapabilitiesPaginated(initialRequest: ListCapabilitiesRequest = ListCapabilitiesRequest { }): Flow<ListCapabilitiesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCapabilitiesPaginated.listCapabilities(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCapabilitiesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCapabilitiesResponse]
 */
public fun B2BiClient.listCapabilitiesPaginated(block: ListCapabilitiesRequest.Builder.() -> Unit): Flow<ListCapabilitiesResponse> =
    listCapabilitiesPaginated(ListCapabilitiesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCapabilitiesPaginated]
 * to access the nested member [CapabilitySummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CapabilitySummary]
 */
@JvmName("listCapabilitiesResponseCapabilitySummary")
public fun Flow<ListCapabilitiesResponse>.capabilities(): Flow<CapabilitySummary> =
    transform() { response ->
        response.capabilities?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListPartnershipsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPartnershipsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPartnershipsResponse]
 */
public fun B2BiClient.listPartnershipsPaginated(initialRequest: ListPartnershipsRequest = ListPartnershipsRequest { }): Flow<ListPartnershipsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPartnershipsPaginated.listPartnerships(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPartnershipsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPartnershipsResponse]
 */
public fun B2BiClient.listPartnershipsPaginated(block: ListPartnershipsRequest.Builder.() -> Unit): Flow<ListPartnershipsResponse> =
    listPartnershipsPaginated(ListPartnershipsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPartnershipsPaginated]
 * to access the nested member [PartnershipSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PartnershipSummary]
 */
@JvmName("listPartnershipsResponsePartnershipSummary")
public fun Flow<ListPartnershipsResponse>.partnerships(): Flow<PartnershipSummary> =
    transform() { response ->
        response.partnerships?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListProfilesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProfilesResponse]
 */
public fun B2BiClient.listProfilesPaginated(initialRequest: ListProfilesRequest = ListProfilesRequest { }): Flow<ListProfilesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listProfilesPaginated.listProfiles(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListProfilesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListProfilesResponse]
 */
public fun B2BiClient.listProfilesPaginated(block: ListProfilesRequest.Builder.() -> Unit): Flow<ListProfilesResponse> =
    listProfilesPaginated(ListProfilesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listProfilesPaginated]
 * to access the nested member [ProfileSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ProfileSummary]
 */
@JvmName("listProfilesResponseProfileSummary")
public fun Flow<ListProfilesResponse>.profiles(): Flow<ProfileSummary> =
    transform() { response ->
        response.profiles?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListTransformersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListTransformersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTransformersResponse]
 */
public fun B2BiClient.listTransformersPaginated(initialRequest: ListTransformersRequest = ListTransformersRequest { }): Flow<ListTransformersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listTransformersPaginated.listTransformers(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListTransformersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListTransformersResponse]
 */
public fun B2BiClient.listTransformersPaginated(block: ListTransformersRequest.Builder.() -> Unit): Flow<ListTransformersResponse> =
    listTransformersPaginated(ListTransformersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listTransformersPaginated]
 * to access the nested member [TransformerSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [TransformerSummary]
 */
@JvmName("listTransformersResponseTransformerSummary")
public fun Flow<ListTransformersResponse>.transformers(): Flow<TransformerSummary> =
    transform() { response ->
        response.transformers?.forEach {
            emit(it)
        }
    }
