// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.b2bi.model



/**
 * Represents a single validation rule that can be applied during X12 EDI processing. This is a union type that can contain one of several specific validation rule types: code list validation rules for modifying allowed element codes, element length validation rules for enforcing custom length constraints, or element requirement validation rules for changing mandatory/optional status. Each validation rule targets specific aspects of EDI document validation to ensure compliance with trading partner requirements and business rules.
 */
public sealed class X12ValidationRule {
    /**
     * Specifies a code list validation rule that modifies the allowed code values for a specific X12 element. This rule enables you to customize which codes are considered valid for an element, allowing for trading partner-specific code requirements.
     */
    public data class CodeListValidationRule(val value: aws.sdk.kotlin.services.b2bi.model.X12CodeListValidationRule) : aws.sdk.kotlin.services.b2bi.model.X12ValidationRule() {
    }

    /**
     * Specifies an element length validation rule that defines custom length constraints for a specific X12 element. This rule allows you to enforce minimum and maximum length requirements that may differ from the standard X12 specification.
     */
    public data class ElementLengthValidationRule(val value: aws.sdk.kotlin.services.b2bi.model.X12ElementLengthValidationRule) : aws.sdk.kotlin.services.b2bi.model.X12ValidationRule() {
    }

    /**
     * Specifies an element requirement validation rule that modifies whether a specific X12 element is required or optional within a segment. This rule provides flexibility to accommodate different trading partner requirements for element presence.
     */
    public data class ElementRequirementValidationRule(val value: aws.sdk.kotlin.services.b2bi.model.X12ElementRequirementValidationRule) : aws.sdk.kotlin.services.b2bi.model.X12ValidationRule() {
    }

    public object SdkUnknown : aws.sdk.kotlin.services.b2bi.model.X12ValidationRule() {
    }

    /**
     * Casts this [X12ValidationRule] as a [CodeListValidationRule] and retrieves its [aws.sdk.kotlin.services.b2bi.model.X12CodeListValidationRule] value. Throws an exception if the [X12ValidationRule] is not a
     * [CodeListValidationRule].
     */
    public fun asCodeListValidationRule(): aws.sdk.kotlin.services.b2bi.model.X12CodeListValidationRule = (this as X12ValidationRule.CodeListValidationRule).value

    /**
     * Casts this [X12ValidationRule] as a [CodeListValidationRule] and retrieves its [aws.sdk.kotlin.services.b2bi.model.X12CodeListValidationRule] value. Returns null if the [X12ValidationRule] is not a [CodeListValidationRule].
     */
    public fun asCodeListValidationRuleOrNull(): aws.sdk.kotlin.services.b2bi.model.X12CodeListValidationRule? = (this as? X12ValidationRule.CodeListValidationRule)?.value

    /**
     * Casts this [X12ValidationRule] as a [ElementLengthValidationRule] and retrieves its [aws.sdk.kotlin.services.b2bi.model.X12ElementLengthValidationRule] value. Throws an exception if the [X12ValidationRule] is not a
     * [ElementLengthValidationRule].
     */
    public fun asElementLengthValidationRule(): aws.sdk.kotlin.services.b2bi.model.X12ElementLengthValidationRule = (this as X12ValidationRule.ElementLengthValidationRule).value

    /**
     * Casts this [X12ValidationRule] as a [ElementLengthValidationRule] and retrieves its [aws.sdk.kotlin.services.b2bi.model.X12ElementLengthValidationRule] value. Returns null if the [X12ValidationRule] is not a [ElementLengthValidationRule].
     */
    public fun asElementLengthValidationRuleOrNull(): aws.sdk.kotlin.services.b2bi.model.X12ElementLengthValidationRule? = (this as? X12ValidationRule.ElementLengthValidationRule)?.value

    /**
     * Casts this [X12ValidationRule] as a [ElementRequirementValidationRule] and retrieves its [aws.sdk.kotlin.services.b2bi.model.X12ElementRequirementValidationRule] value. Throws an exception if the [X12ValidationRule] is not a
     * [ElementRequirementValidationRule].
     */
    public fun asElementRequirementValidationRule(): aws.sdk.kotlin.services.b2bi.model.X12ElementRequirementValidationRule = (this as X12ValidationRule.ElementRequirementValidationRule).value

    /**
     * Casts this [X12ValidationRule] as a [ElementRequirementValidationRule] and retrieves its [aws.sdk.kotlin.services.b2bi.model.X12ElementRequirementValidationRule] value. Returns null if the [X12ValidationRule] is not a [ElementRequirementValidationRule].
     */
    public fun asElementRequirementValidationRuleOrNull(): aws.sdk.kotlin.services.b2bi.model.X12ElementRequirementValidationRule? = (this as? X12ValidationRule.ElementRequirementValidationRule)?.value
}
