// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.b2bi.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains configuration options for X12 EDI validation. This structure allows you to specify custom validation rules that will be applied during EDI document processing, including element length constraints, code list modifications, and element requirement changes. These validation options provide flexibility to accommodate trading partner-specific requirements while maintaining EDI compliance. The validation rules are applied in addition to standard X12 validation to ensure documents meet both standard and custom requirements.
 */
public class X12ValidationOptions private constructor(builder: Builder) {
    /**
     * Specifies a list of validation rules to apply during EDI document processing. These rules can include code list modifications, element length constraints, and element requirement changes.
     */
    public val validationRules: List<X12ValidationRule>? = builder.validationRules

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.b2bi.model.X12ValidationOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("X12ValidationOptions(")
        append("validationRules=$validationRules")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = validationRules?.hashCode() ?: 0
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as X12ValidationOptions

        if (validationRules != other.validationRules) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.b2bi.model.X12ValidationOptions = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies a list of validation rules to apply during EDI document processing. These rules can include code list modifications, element length constraints, and element requirement changes.
         */
        public var validationRules: List<X12ValidationRule>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.b2bi.model.X12ValidationOptions) : this() {
            this.validationRules = x.validationRules
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.b2bi.model.X12ValidationOptions = X12ValidationOptions(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
