// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.b2bi.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A structure containing the details for an outbound EDI object.
 */
public class X12OutboundEdiHeaders private constructor(builder: Builder) {
    /**
     * Specifies control number configuration for outbound X12 EDI headers. These settings determine the starting values for interchange, functional group, and transaction set control numbers.
     */
    public val controlNumbers: aws.sdk.kotlin.services.b2bi.model.X12ControlNumbers? = builder.controlNumbers
    /**
     * The delimiters, for example semicolon (`;`), that separates sections of the headers for the X12 object.
     */
    public val delimiters: aws.sdk.kotlin.services.b2bi.model.X12Delimiters? = builder.delimiters
    /**
     * The functional group headers for the X12 object.
     */
    public val functionalGroupHeaders: aws.sdk.kotlin.services.b2bi.model.X12FunctionalGroupHeaders? = builder.functionalGroupHeaders
    /**
     * Specifies the time format in the GS05 element (time) of the functional group header. The following formats use 24-hour clock time:
     * + `HHMM` - Hours and minutes
     * + `HHMMSS` - Hours, minutes, and seconds
     * + `HHMMSSDD` - Hours, minutes, seconds, and decimal seconds
     *
     * Where:
     * + `HH` - Hours (00-23)
     * + `MM` - Minutes (00-59)
     * + `SS` - Seconds (00-59)
     * + `DD` - Hundredths of seconds (00-99)
     */
    public val gs05TimeFormat: aws.sdk.kotlin.services.b2bi.model.X12Gs05TimeFormat? = builder.gs05TimeFormat
    /**
     * In X12 EDI messages, delimiters are used to mark the end of segments or elements, and are defined in the interchange control header.
     */
    public val interchangeControlHeaders: aws.sdk.kotlin.services.b2bi.model.X12InterchangeControlHeaders? = builder.interchangeControlHeaders
    /**
     * Specifies whether or not to validate the EDI for this X12 object: `TRUE` or `FALSE`. When enabled, this performs both standard EDI validation and applies any configured custom validation rules including element length constraints, code list validations, and element requirement checks. Validation results are returned in the response validation messages.
     */
    public val validateEdi: kotlin.Boolean? = builder.validateEdi

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.b2bi.model.X12OutboundEdiHeaders = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("X12OutboundEdiHeaders(")
        append("controlNumbers=$controlNumbers,")
        append("delimiters=$delimiters,")
        append("functionalGroupHeaders=$functionalGroupHeaders,")
        append("gs05TimeFormat=$gs05TimeFormat,")
        append("interchangeControlHeaders=$interchangeControlHeaders,")
        append("validateEdi=$validateEdi")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = controlNumbers?.hashCode() ?: 0
        result = 31 * result + (delimiters?.hashCode() ?: 0)
        result = 31 * result + (functionalGroupHeaders?.hashCode() ?: 0)
        result = 31 * result + (gs05TimeFormat?.hashCode() ?: 0)
        result = 31 * result + (interchangeControlHeaders?.hashCode() ?: 0)
        result = 31 * result + (validateEdi?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as X12OutboundEdiHeaders

        if (controlNumbers != other.controlNumbers) return false
        if (delimiters != other.delimiters) return false
        if (functionalGroupHeaders != other.functionalGroupHeaders) return false
        if (gs05TimeFormat != other.gs05TimeFormat) return false
        if (interchangeControlHeaders != other.interchangeControlHeaders) return false
        if (validateEdi != other.validateEdi) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.b2bi.model.X12OutboundEdiHeaders = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies control number configuration for outbound X12 EDI headers. These settings determine the starting values for interchange, functional group, and transaction set control numbers.
         */
        public var controlNumbers: aws.sdk.kotlin.services.b2bi.model.X12ControlNumbers? = null
        /**
         * The delimiters, for example semicolon (`;`), that separates sections of the headers for the X12 object.
         */
        public var delimiters: aws.sdk.kotlin.services.b2bi.model.X12Delimiters? = null
        /**
         * The functional group headers for the X12 object.
         */
        public var functionalGroupHeaders: aws.sdk.kotlin.services.b2bi.model.X12FunctionalGroupHeaders? = null
        /**
         * Specifies the time format in the GS05 element (time) of the functional group header. The following formats use 24-hour clock time:
         * + `HHMM` - Hours and minutes
         * + `HHMMSS` - Hours, minutes, and seconds
         * + `HHMMSSDD` - Hours, minutes, seconds, and decimal seconds
         *
         * Where:
         * + `HH` - Hours (00-23)
         * + `MM` - Minutes (00-59)
         * + `SS` - Seconds (00-59)
         * + `DD` - Hundredths of seconds (00-99)
         */
        public var gs05TimeFormat: aws.sdk.kotlin.services.b2bi.model.X12Gs05TimeFormat? = null
        /**
         * In X12 EDI messages, delimiters are used to mark the end of segments or elements, and are defined in the interchange control header.
         */
        public var interchangeControlHeaders: aws.sdk.kotlin.services.b2bi.model.X12InterchangeControlHeaders? = null
        /**
         * Specifies whether or not to validate the EDI for this X12 object: `TRUE` or `FALSE`. When enabled, this performs both standard EDI validation and applies any configured custom validation rules including element length constraints, code list validations, and element requirement checks. Validation results are returned in the response validation messages.
         */
        public var validateEdi: kotlin.Boolean? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.b2bi.model.X12OutboundEdiHeaders) : this() {
            this.controlNumbers = x.controlNumbers
            this.delimiters = x.delimiters
            this.functionalGroupHeaders = x.functionalGroupHeaders
            this.gs05TimeFormat = x.gs05TimeFormat
            this.interchangeControlHeaders = x.interchangeControlHeaders
            this.validateEdi = x.validateEdi
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.b2bi.model.X12OutboundEdiHeaders = X12OutboundEdiHeaders(this)

        /**
         * construct an [aws.sdk.kotlin.services.b2bi.model.X12ControlNumbers] inside the given [block]
         */
        public fun controlNumbers(block: aws.sdk.kotlin.services.b2bi.model.X12ControlNumbers.Builder.() -> kotlin.Unit) {
            this.controlNumbers = aws.sdk.kotlin.services.b2bi.model.X12ControlNumbers.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.b2bi.model.X12Delimiters] inside the given [block]
         */
        public fun delimiters(block: aws.sdk.kotlin.services.b2bi.model.X12Delimiters.Builder.() -> kotlin.Unit) {
            this.delimiters = aws.sdk.kotlin.services.b2bi.model.X12Delimiters.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.b2bi.model.X12FunctionalGroupHeaders] inside the given [block]
         */
        public fun functionalGroupHeaders(block: aws.sdk.kotlin.services.b2bi.model.X12FunctionalGroupHeaders.Builder.() -> kotlin.Unit) {
            this.functionalGroupHeaders = aws.sdk.kotlin.services.b2bi.model.X12FunctionalGroupHeaders.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.b2bi.model.X12InterchangeControlHeaders] inside the given [block]
         */
        public fun interchangeControlHeaders(block: aws.sdk.kotlin.services.b2bi.model.X12InterchangeControlHeaders.Builder.() -> kotlin.Unit) {
            this.interchangeControlHeaders = aws.sdk.kotlin.services.b2bi.model.X12InterchangeControlHeaders.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
