// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.b2bi.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * In X12, the Interchange Control Header is the first segment of an EDI document and is part of the Interchange Envelope. It contains information about the sender and receiver, the date and time of transmission, and the X12 version being used. It also includes delivery information, such as the sender and receiver IDs.
 */
public class X12InterchangeControlHeaders private constructor(builder: Builder) {
    /**
     * Located at position ISA-14 in the header. The value "1" indicates that the sender is requesting an interchange acknowledgment at receipt of the interchange. The value "0" is used otherwise.
     */
    public val acknowledgmentRequestedCode: kotlin.String? = builder.acknowledgmentRequestedCode
    /**
     * Located at position ISA-08 in the header. This value (along with the `receiverIdQualifier`) identifies the intended recipient of the interchange.
     */
    public val receiverId: kotlin.String? = builder.receiverId
    /**
     * Located at position ISA-07 in the header. Qualifier for the receiver ID. Together, the ID and qualifier uniquely identify the receiving trading partner.
     */
    public val receiverIdQualifier: kotlin.String? = builder.receiverIdQualifier
    /**
     * Located at position ISA-11 in the header. This string makes it easier when you need to group similar adjacent element values together without using extra segments.
     *
     * This parameter is only honored for version greater than 401 (`VERSION_4010` and higher).
     *
     * For versions less than 401, this field is called [StandardsId](https://www.stedi.com/edi/x12-004010/segment/ISA#ISA-11), in which case our service sets the value to `U`.
     */
    public val repetitionSeparator: kotlin.String? = builder.repetitionSeparator
    /**
     * Located at position ISA-06 in the header. This value (along with the `senderIdQualifier`) identifies the sender of the interchange.
     */
    public val senderId: kotlin.String? = builder.senderId
    /**
     * Located at position ISA-05 in the header. Qualifier for the sender ID. Together, the ID and qualifier uniquely identify the sending trading partner.
     */
    public val senderIdQualifier: kotlin.String? = builder.senderIdQualifier
    /**
     * Located at position ISA-15 in the header. Specifies how this interchange is being used:
     * + `T` indicates this interchange is for testing.
     * + `P` indicates this interchange is for production.
     * + `I` indicates this interchange is informational.
     */
    public val usageIndicatorCode: kotlin.String? = builder.usageIndicatorCode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.b2bi.model.X12InterchangeControlHeaders = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("X12InterchangeControlHeaders(")
        append("acknowledgmentRequestedCode=$acknowledgmentRequestedCode,")
        append("receiverId=$receiverId,")
        append("receiverIdQualifier=$receiverIdQualifier,")
        append("repetitionSeparator=$repetitionSeparator,")
        append("senderId=$senderId,")
        append("senderIdQualifier=$senderIdQualifier,")
        append("usageIndicatorCode=$usageIndicatorCode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = acknowledgmentRequestedCode?.hashCode() ?: 0
        result = 31 * result + (receiverId?.hashCode() ?: 0)
        result = 31 * result + (receiverIdQualifier?.hashCode() ?: 0)
        result = 31 * result + (repetitionSeparator?.hashCode() ?: 0)
        result = 31 * result + (senderId?.hashCode() ?: 0)
        result = 31 * result + (senderIdQualifier?.hashCode() ?: 0)
        result = 31 * result + (usageIndicatorCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as X12InterchangeControlHeaders

        if (acknowledgmentRequestedCode != other.acknowledgmentRequestedCode) return false
        if (receiverId != other.receiverId) return false
        if (receiverIdQualifier != other.receiverIdQualifier) return false
        if (repetitionSeparator != other.repetitionSeparator) return false
        if (senderId != other.senderId) return false
        if (senderIdQualifier != other.senderIdQualifier) return false
        if (usageIndicatorCode != other.usageIndicatorCode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.b2bi.model.X12InterchangeControlHeaders = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Located at position ISA-14 in the header. The value "1" indicates that the sender is requesting an interchange acknowledgment at receipt of the interchange. The value "0" is used otherwise.
         */
        public var acknowledgmentRequestedCode: kotlin.String? = null
        /**
         * Located at position ISA-08 in the header. This value (along with the `receiverIdQualifier`) identifies the intended recipient of the interchange.
         */
        public var receiverId: kotlin.String? = null
        /**
         * Located at position ISA-07 in the header. Qualifier for the receiver ID. Together, the ID and qualifier uniquely identify the receiving trading partner.
         */
        public var receiverIdQualifier: kotlin.String? = null
        /**
         * Located at position ISA-11 in the header. This string makes it easier when you need to group similar adjacent element values together without using extra segments.
         *
         * This parameter is only honored for version greater than 401 (`VERSION_4010` and higher).
         *
         * For versions less than 401, this field is called [StandardsId](https://www.stedi.com/edi/x12-004010/segment/ISA#ISA-11), in which case our service sets the value to `U`.
         */
        public var repetitionSeparator: kotlin.String? = null
        /**
         * Located at position ISA-06 in the header. This value (along with the `senderIdQualifier`) identifies the sender of the interchange.
         */
        public var senderId: kotlin.String? = null
        /**
         * Located at position ISA-05 in the header. Qualifier for the sender ID. Together, the ID and qualifier uniquely identify the sending trading partner.
         */
        public var senderIdQualifier: kotlin.String? = null
        /**
         * Located at position ISA-15 in the header. Specifies how this interchange is being used:
         * + `T` indicates this interchange is for testing.
         * + `P` indicates this interchange is for production.
         * + `I` indicates this interchange is informational.
         */
        public var usageIndicatorCode: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.b2bi.model.X12InterchangeControlHeaders) : this() {
            this.acknowledgmentRequestedCode = x.acknowledgmentRequestedCode
            this.receiverId = x.receiverId
            this.receiverIdQualifier = x.receiverIdQualifier
            this.repetitionSeparator = x.repetitionSeparator
            this.senderId = x.senderId
            this.senderIdQualifier = x.senderIdQualifier
            this.usageIndicatorCode = x.usageIndicatorCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.b2bi.model.X12InterchangeControlHeaders = X12InterchangeControlHeaders(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
