// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.b2bi.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Defines a validation rule that modifies the requirement status of a specific X12 element within a segment. This rule allows you to make optional elements mandatory or mandatory elements optional, providing flexibility to accommodate different trading partner requirements and business rules. The rule targets a specific element position within a segment and sets its requirement status to either OPTIONAL or MANDATORY.
 */
public class X12ElementRequirementValidationRule private constructor(builder: Builder) {
    /**
     * Specifies the position of the element within an X12 segment for which the requirement status will be modified. The format follows the pattern of segment identifier followed by element position (e.g., "ST-01" for the first element of the ST segment).
     */
    public val elementPosition: kotlin.String = requireNotNull(builder.elementPosition) { "A non-null value must be provided for elementPosition" }
    /**
     * Specifies the requirement status for the element at the specified position. Valid values are OPTIONAL (the element may be omitted) or MANDATORY (the element must be present).
     */
    public val requirement: aws.sdk.kotlin.services.b2bi.model.ElementRequirement = requireNotNull(builder.requirement) { "A non-null value must be provided for requirement" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.b2bi.model.X12ElementRequirementValidationRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("X12ElementRequirementValidationRule(")
        append("elementPosition=$elementPosition,")
        append("requirement=$requirement")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = elementPosition.hashCode()
        result = 31 * result + (requirement.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as X12ElementRequirementValidationRule

        if (elementPosition != other.elementPosition) return false
        if (requirement != other.requirement) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.b2bi.model.X12ElementRequirementValidationRule = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the position of the element within an X12 segment for which the requirement status will be modified. The format follows the pattern of segment identifier followed by element position (e.g., "ST-01" for the first element of the ST segment).
         */
        public var elementPosition: kotlin.String? = null
        /**
         * Specifies the requirement status for the element at the specified position. Valid values are OPTIONAL (the element may be omitted) or MANDATORY (the element must be present).
         */
        public var requirement: aws.sdk.kotlin.services.b2bi.model.ElementRequirement? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.b2bi.model.X12ElementRequirementValidationRule) : this() {
            this.elementPosition = x.elementPosition
            this.requirement = x.requirement
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.b2bi.model.X12ElementRequirementValidationRule = X12ElementRequirementValidationRule(this)

        internal fun correctErrors(): Builder {
            if (elementPosition == null) elementPosition = ""
            if (requirement == null) requirement = ElementRequirement.SdkUnknown("no value provided")
            return this
        }
    }
}
