// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.b2bi.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Defines a validation rule that specifies custom length constraints for a specific X12 element. This rule allows you to override the standard minimum and maximum length requirements for an element, enabling validation of trading partner-specific length requirements that may differ from the X12 specification. Both minimum and maximum length values must be specified and must be between 1 and 200 characters.
 */
public class X12ElementLengthValidationRule private constructor(builder: Builder) {
    /**
     * Specifies the four-digit element ID to which the length constraints will be applied. This identifies which X12 element will have its length requirements modified.
     */
    public val elementId: kotlin.String = requireNotNull(builder.elementId) { "A non-null value must be provided for elementId" }
    /**
     * Specifies the maximum allowed length for the identified element. This value must be between 1 and 200 characters and defines the upper limit for the element's content length.
     */
    public val maxLength: kotlin.Int = requireNotNull(builder.maxLength) { "A non-null value must be provided for maxLength" }
    /**
     * Specifies the minimum required length for the identified element. This value must be between 1 and 200 characters and defines the lower limit for the element's content length.
     */
    public val minLength: kotlin.Int = requireNotNull(builder.minLength) { "A non-null value must be provided for minLength" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.b2bi.model.X12ElementLengthValidationRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("X12ElementLengthValidationRule(")
        append("elementId=$elementId,")
        append("maxLength=$maxLength,")
        append("minLength=$minLength")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = elementId.hashCode()
        result = 31 * result + (maxLength)
        result = 31 * result + (minLength)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as X12ElementLengthValidationRule

        if (elementId != other.elementId) return false
        if (maxLength != other.maxLength) return false
        if (minLength != other.minLength) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.b2bi.model.X12ElementLengthValidationRule = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the four-digit element ID to which the length constraints will be applied. This identifies which X12 element will have its length requirements modified.
         */
        public var elementId: kotlin.String? = null
        /**
         * Specifies the maximum allowed length for the identified element. This value must be between 1 and 200 characters and defines the upper limit for the element's content length.
         */
        public var maxLength: kotlin.Int? = null
        /**
         * Specifies the minimum required length for the identified element. This value must be between 1 and 200 characters and defines the lower limit for the element's content length.
         */
        public var minLength: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.b2bi.model.X12ElementLengthValidationRule) : this() {
            this.elementId = x.elementId
            this.maxLength = x.maxLength
            this.minLength = x.minLength
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.b2bi.model.X12ElementLengthValidationRule = X12ElementLengthValidationRule(this)

        internal fun correctErrors(): Builder {
            if (elementId == null) elementId = ""
            if (maxLength == null) maxLength = 0
            if (minLength == null) minLength = 0
            return this
        }
    }
}
