// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.b2bi.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Defines a validation rule that modifies the allowed code values for a specific X12 element. This rule allows you to add or remove valid codes from an element's standard code list, providing flexibility to accommodate trading partner-specific requirements or industry variations. You can specify codes to add to expand the allowed values beyond the X12 standard, or codes to remove to restrict the allowed values for stricter validation.
 */
public class X12CodeListValidationRule private constructor(builder: Builder) {
    /**
     * Specifies a list of code values to add to the element's allowed values. These codes will be considered valid for the specified element in addition to the standard codes defined by the X12 specification.
     */
    public val codesToAdd: List<String>? = builder.codesToAdd
    /**
     * Specifies a list of code values to remove from the element's allowed values. These codes will be considered invalid for the specified element, even if they are part of the standard codes defined by the X12 specification.
     */
    public val codesToRemove: List<String>? = builder.codesToRemove
    /**
     * Specifies the four-digit element ID to which the code list modifications apply. This identifies which X12 element will have its allowed code values modified.
     */
    public val elementId: kotlin.String = requireNotNull(builder.elementId) { "A non-null value must be provided for elementId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.b2bi.model.X12CodeListValidationRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("X12CodeListValidationRule(")
        append("codesToAdd=$codesToAdd,")
        append("codesToRemove=$codesToRemove,")
        append("elementId=$elementId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = codesToAdd?.hashCode() ?: 0
        result = 31 * result + (codesToRemove?.hashCode() ?: 0)
        result = 31 * result + (elementId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as X12CodeListValidationRule

        if (codesToAdd != other.codesToAdd) return false
        if (codesToRemove != other.codesToRemove) return false
        if (elementId != other.elementId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.b2bi.model.X12CodeListValidationRule = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies a list of code values to add to the element's allowed values. These codes will be considered valid for the specified element in addition to the standard codes defined by the X12 specification.
         */
        public var codesToAdd: List<String>? = null
        /**
         * Specifies a list of code values to remove from the element's allowed values. These codes will be considered invalid for the specified element, even if they are part of the standard codes defined by the X12 specification.
         */
        public var codesToRemove: List<String>? = null
        /**
         * Specifies the four-digit element ID to which the code list modifications apply. This identifies which X12 element will have its allowed code values modified.
         */
        public var elementId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.b2bi.model.X12CodeListValidationRule) : this() {
            this.codesToAdd = x.codesToAdd
            this.codesToRemove = x.codesToRemove
            this.elementId = x.elementId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.b2bi.model.X12CodeListValidationRule = X12CodeListValidationRule(this)

        internal fun correctErrors(): Builder {
            if (elementId == null) elementId = ""
            return this
        }
    }
}
