// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.b2bi.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Contains options for configuring X12 acknowledgments. These options control how functional and technical acknowledgments are handled.
 */
public class X12AcknowledgmentOptions private constructor(builder: Builder) {
    /**
     * Specifies whether functional acknowledgments (997/999) should be generated for incoming X12 transactions. Valid values are `DO_NOT_GENERATE`, `GENERATE_ALL_SEGMENTS` and `GENERATE_WITHOUT_TRANSACTION_SET_RESPONSE_LOOP`.
     *
     * If you choose `GENERATE_WITHOUT_TRANSACTION_SET_RESPONSE_LOOP`, Amazon Web Services B2B Data Interchange skips the AK2_Loop when generating an acknowledgment document.
     */
    public val functionalAcknowledgment: aws.sdk.kotlin.services.b2bi.model.X12FunctionalAcknowledgment = requireNotNull(builder.functionalAcknowledgment) { "A non-null value must be provided for functionalAcknowledgment" }
    /**
     * Specifies whether technical acknowledgments (TA1) should be generated for incoming X12 interchanges. Valid values are `DO_NOT_GENERATE` and `GENERATE_ALL_SEGMENTS` and.
     */
    public val technicalAcknowledgment: aws.sdk.kotlin.services.b2bi.model.X12TechnicalAcknowledgment = requireNotNull(builder.technicalAcknowledgment) { "A non-null value must be provided for technicalAcknowledgment" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.b2bi.model.X12AcknowledgmentOptions = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("X12AcknowledgmentOptions(")
        append("functionalAcknowledgment=$functionalAcknowledgment,")
        append("technicalAcknowledgment=$technicalAcknowledgment")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = functionalAcknowledgment.hashCode()
        result = 31 * result + (technicalAcknowledgment.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as X12AcknowledgmentOptions

        if (functionalAcknowledgment != other.functionalAcknowledgment) return false
        if (technicalAcknowledgment != other.technicalAcknowledgment) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.b2bi.model.X12AcknowledgmentOptions = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies whether functional acknowledgments (997/999) should be generated for incoming X12 transactions. Valid values are `DO_NOT_GENERATE`, `GENERATE_ALL_SEGMENTS` and `GENERATE_WITHOUT_TRANSACTION_SET_RESPONSE_LOOP`.
         *
         * If you choose `GENERATE_WITHOUT_TRANSACTION_SET_RESPONSE_LOOP`, Amazon Web Services B2B Data Interchange skips the AK2_Loop when generating an acknowledgment document.
         */
        public var functionalAcknowledgment: aws.sdk.kotlin.services.b2bi.model.X12FunctionalAcknowledgment? = null
        /**
         * Specifies whether technical acknowledgments (TA1) should be generated for incoming X12 interchanges. Valid values are `DO_NOT_GENERATE` and `GENERATE_ALL_SEGMENTS` and.
         */
        public var technicalAcknowledgment: aws.sdk.kotlin.services.b2bi.model.X12TechnicalAcknowledgment? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.b2bi.model.X12AcknowledgmentOptions) : this() {
            this.functionalAcknowledgment = x.functionalAcknowledgment
            this.technicalAcknowledgment = x.technicalAcknowledgment
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.b2bi.model.X12AcknowledgmentOptions = X12AcknowledgmentOptions(this)

        internal fun correctErrors(): Builder {
            if (functionalAcknowledgment == null) functionalAcknowledgment = X12FunctionalAcknowledgment.SdkUnknown("no value provided")
            if (technicalAcknowledgment == null) technicalAcknowledgment = X12TechnicalAcknowledgment.SdkUnknown("no value provided")
            return this
        }
    }
}
