// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.b2bi.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class CreateTransformerResponse private constructor(builder: Builder) {
    /**
     * Returns a timestamp for creation date and time of the transformer.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * Returns the details for the EDI standard that is being used for the transformer. Currently, only X12 is supported. X12 is a set of standards and corresponding messages that define specific business documents.
     */
    @Deprecated("This is a legacy trait. Please use input-conversion or output-conversion.")
    public val ediType: aws.sdk.kotlin.services.b2bi.model.EdiType? = builder.ediType
    /**
     * Returns that the currently supported file formats for EDI transformations are `JSON` and `XML`.
     */
    @Deprecated("This is a legacy trait. Please use input-conversion or output-conversion.")
    public val fileFormat: aws.sdk.kotlin.services.b2bi.model.FileFormat = builder.fileFormat
    /**
     * Returns the `InputConversion` object, which contains the format options for the inbound transformation.
     */
    public val inputConversion: aws.sdk.kotlin.services.b2bi.model.InputConversion? = builder.inputConversion
    /**
     * Returns the structure that contains the mapping template and its language (either XSLT or JSONATA).
     */
    public val mapping: aws.sdk.kotlin.services.b2bi.model.Mapping? = builder.mapping
    /**
     * Returns the mapping template for the transformer. This template is used to map the parsed EDI file using JSONata or XSLT.
     */
    @Deprecated("This is a legacy trait. Please use input-conversion or output-conversion.")
    public val mappingTemplate: kotlin.String = builder.mappingTemplate
    /**
     * Returns the name of the transformer, used to identify it.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Returns the `OutputConversion` object, which contains the format options for the outbound transformation.
     */
    public val outputConversion: aws.sdk.kotlin.services.b2bi.model.OutputConversion? = builder.outputConversion
    /**
     * Returns a sample EDI document that is used by a transformer as a guide for processing the EDI data.
     */
    @Deprecated("This is a legacy trait. Please use input-conversion or output-conversion.")
    public val sampleDocument: kotlin.String? = builder.sampleDocument
    /**
     * Returns a structure that contains the Amazon S3 bucket and an array of the corresponding keys used to identify the location for your sample documents.
     */
    public val sampleDocuments: aws.sdk.kotlin.services.b2bi.model.SampleDocuments? = builder.sampleDocuments
    /**
     * Returns the state of the newly created transformer. The transformer can be either `active` or `inactive`. For the transformer to be used in a capability, its status must `active`.
     */
    public val status: aws.sdk.kotlin.services.b2bi.model.TransformerStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }
    /**
     * Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a capability, partnership, profile, or transformer.
     */
    public val transformerArn: kotlin.String = requireNotNull(builder.transformerArn) { "A non-null value must be provided for transformerArn" }
    /**
     * Returns the system-assigned unique identifier for the transformer.
     */
    public val transformerId: kotlin.String = requireNotNull(builder.transformerId) { "A non-null value must be provided for transformerId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.b2bi.model.CreateTransformerResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateTransformerResponse(")
        append("createdAt=$createdAt,")
        append("ediType=$ediType,")
        append("fileFormat=$fileFormat,")
        append("inputConversion=$inputConversion,")
        append("mapping=$mapping,")
        append("mappingTemplate=$mappingTemplate,")
        append("name=$name,")
        append("outputConversion=$outputConversion,")
        append("sampleDocument=$sampleDocument,")
        append("sampleDocuments=$sampleDocuments,")
        append("status=$status,")
        append("transformerArn=$transformerArn,")
        append("transformerId=$transformerId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt.hashCode()
        result = 31 * result + (ediType?.hashCode() ?: 0)
        result = 31 * result + (fileFormat.hashCode())
        result = 31 * result + (inputConversion?.hashCode() ?: 0)
        result = 31 * result + (mapping?.hashCode() ?: 0)
        result = 31 * result + (mappingTemplate.hashCode())
        result = 31 * result + (name.hashCode())
        result = 31 * result + (outputConversion?.hashCode() ?: 0)
        result = 31 * result + (sampleDocument?.hashCode() ?: 0)
        result = 31 * result + (sampleDocuments?.hashCode() ?: 0)
        result = 31 * result + (status.hashCode())
        result = 31 * result + (transformerArn.hashCode())
        result = 31 * result + (transformerId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateTransformerResponse

        if (createdAt != other.createdAt) return false
        if (ediType != other.ediType) return false
        if (fileFormat != other.fileFormat) return false
        if (inputConversion != other.inputConversion) return false
        if (mapping != other.mapping) return false
        if (mappingTemplate != other.mappingTemplate) return false
        if (name != other.name) return false
        if (outputConversion != other.outputConversion) return false
        if (sampleDocument != other.sampleDocument) return false
        if (sampleDocuments != other.sampleDocuments) return false
        if (status != other.status) return false
        if (transformerArn != other.transformerArn) return false
        if (transformerId != other.transformerId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.b2bi.model.CreateTransformerResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Returns a timestamp for creation date and time of the transformer.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Returns the details for the EDI standard that is being used for the transformer. Currently, only X12 is supported. X12 is a set of standards and corresponding messages that define specific business documents.
         */
        @Deprecated("This is a legacy trait. Please use input-conversion or output-conversion.")
        public var ediType: aws.sdk.kotlin.services.b2bi.model.EdiType? = null
        /**
         * Returns that the currently supported file formats for EDI transformations are `JSON` and `XML`.
         */
        @Deprecated("This is a legacy trait. Please use input-conversion or output-conversion.")
        public var fileFormat: aws.sdk.kotlin.services.b2bi.model.FileFormat = aws.sdk.kotlin.services.b2bi.model.FileFormat.fromValue("NOT_USED")
        /**
         * Returns the `InputConversion` object, which contains the format options for the inbound transformation.
         */
        public var inputConversion: aws.sdk.kotlin.services.b2bi.model.InputConversion? = null
        /**
         * Returns the structure that contains the mapping template and its language (either XSLT or JSONATA).
         */
        public var mapping: aws.sdk.kotlin.services.b2bi.model.Mapping? = null
        /**
         * Returns the mapping template for the transformer. This template is used to map the parsed EDI file using JSONata or XSLT.
         */
        @Deprecated("This is a legacy trait. Please use input-conversion or output-conversion.")
        public var mappingTemplate: kotlin.String = "NOT_USED"
        /**
         * Returns the name of the transformer, used to identify it.
         */
        public var name: kotlin.String? = null
        /**
         * Returns the `OutputConversion` object, which contains the format options for the outbound transformation.
         */
        public var outputConversion: aws.sdk.kotlin.services.b2bi.model.OutputConversion? = null
        /**
         * Returns a sample EDI document that is used by a transformer as a guide for processing the EDI data.
         */
        @Deprecated("This is a legacy trait. Please use input-conversion or output-conversion.")
        public var sampleDocument: kotlin.String? = null
        /**
         * Returns a structure that contains the Amazon S3 bucket and an array of the corresponding keys used to identify the location for your sample documents.
         */
        public var sampleDocuments: aws.sdk.kotlin.services.b2bi.model.SampleDocuments? = null
        /**
         * Returns the state of the newly created transformer. The transformer can be either `active` or `inactive`. For the transformer to be used in a capability, its status must `active`.
         */
        public var status: aws.sdk.kotlin.services.b2bi.model.TransformerStatus? = null
        /**
         * Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services resource, such as a capability, partnership, profile, or transformer.
         */
        public var transformerArn: kotlin.String? = null
        /**
         * Returns the system-assigned unique identifier for the transformer.
         */
        public var transformerId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.b2bi.model.CreateTransformerResponse) : this() {
            this.createdAt = x.createdAt
            this.ediType = x.ediType
            this.fileFormat = x.fileFormat
            this.inputConversion = x.inputConversion
            this.mapping = x.mapping
            this.mappingTemplate = x.mappingTemplate
            this.name = x.name
            this.outputConversion = x.outputConversion
            this.sampleDocument = x.sampleDocument
            this.sampleDocuments = x.sampleDocuments
            this.status = x.status
            this.transformerArn = x.transformerArn
            this.transformerId = x.transformerId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.b2bi.model.CreateTransformerResponse = CreateTransformerResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.b2bi.model.InputConversion] inside the given [block]
         */
        public fun inputConversion(block: aws.sdk.kotlin.services.b2bi.model.InputConversion.Builder.() -> kotlin.Unit) {
            this.inputConversion = aws.sdk.kotlin.services.b2bi.model.InputConversion.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.b2bi.model.Mapping] inside the given [block]
         */
        public fun mapping(block: aws.sdk.kotlin.services.b2bi.model.Mapping.Builder.() -> kotlin.Unit) {
            this.mapping = aws.sdk.kotlin.services.b2bi.model.Mapping.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.b2bi.model.OutputConversion] inside the given [block]
         */
        public fun outputConversion(block: aws.sdk.kotlin.services.b2bi.model.OutputConversion.Builder.() -> kotlin.Unit) {
            this.outputConversion = aws.sdk.kotlin.services.b2bi.model.OutputConversion.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.b2bi.model.SampleDocuments] inside the given [block]
         */
        public fun sampleDocuments(block: aws.sdk.kotlin.services.b2bi.model.SampleDocuments.Builder.() -> kotlin.Unit) {
            this.sampleDocuments = aws.sdk.kotlin.services.b2bi.model.SampleDocuments.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (name == null) name = ""
            if (status == null) status = TransformerStatus.SdkUnknown("no value provided")
            if (transformerArn == null) transformerArn = ""
            if (transformerId == null) transformerId = ""
            return this
        }
    }
}
