// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.b2bi.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class CreateProfileResponse private constructor(builder: Builder) {
    /**
     * Returns the name for the business associated with this profile.
     */
    public val businessName: kotlin.String = requireNotNull(builder.businessName) { "A non-null value must be provided for businessName" }
    /**
     * Returns a timestamp representing the time the profile was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * Returns the email address associated with this customer profile.
     */
    public val email: kotlin.String? = builder.email
    /**
     * Returns the name of the logging group.
     */
    public val logGroupName: kotlin.String? = builder.logGroupName
    /**
     * Returns whether or not logging is turned on for this profile.
     */
    public val logging: aws.sdk.kotlin.services.b2bi.model.Logging? = builder.logging
    /**
     * Returns the name of the profile, used to identify it.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Returns the phone number associated with the profile.
     */
    public val phone: kotlin.String = requireNotNull(builder.phone) { "A non-null value must be provided for phone" }
    /**
     * Returns an Amazon Resource Name (ARN) for the profile.
     */
    public val profileArn: kotlin.String = requireNotNull(builder.profileArn) { "A non-null value must be provided for profileArn" }
    /**
     * Returns the unique, system-generated identifier for the profile.
     */
    public val profileId: kotlin.String = requireNotNull(builder.profileId) { "A non-null value must be provided for profileId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.b2bi.model.CreateProfileResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateProfileResponse(")
        append("businessName=$businessName,")
        append("createdAt=$createdAt,")
        append("email=*** Sensitive Data Redacted ***,")
        append("logGroupName=$logGroupName,")
        append("logging=$logging,")
        append("name=$name,")
        append("phone=*** Sensitive Data Redacted ***,")
        append("profileArn=$profileArn,")
        append("profileId=$profileId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = businessName.hashCode()
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (email?.hashCode() ?: 0)
        result = 31 * result + (logGroupName?.hashCode() ?: 0)
        result = 31 * result + (logging?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (phone.hashCode())
        result = 31 * result + (profileArn.hashCode())
        result = 31 * result + (profileId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateProfileResponse

        if (businessName != other.businessName) return false
        if (createdAt != other.createdAt) return false
        if (email != other.email) return false
        if (logGroupName != other.logGroupName) return false
        if (logging != other.logging) return false
        if (name != other.name) return false
        if (phone != other.phone) return false
        if (profileArn != other.profileArn) return false
        if (profileId != other.profileId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.b2bi.model.CreateProfileResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Returns the name for the business associated with this profile.
         */
        public var businessName: kotlin.String? = null
        /**
         * Returns a timestamp representing the time the profile was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Returns the email address associated with this customer profile.
         */
        public var email: kotlin.String? = null
        /**
         * Returns the name of the logging group.
         */
        public var logGroupName: kotlin.String? = null
        /**
         * Returns whether or not logging is turned on for this profile.
         */
        public var logging: aws.sdk.kotlin.services.b2bi.model.Logging? = null
        /**
         * Returns the name of the profile, used to identify it.
         */
        public var name: kotlin.String? = null
        /**
         * Returns the phone number associated with the profile.
         */
        public var phone: kotlin.String? = null
        /**
         * Returns an Amazon Resource Name (ARN) for the profile.
         */
        public var profileArn: kotlin.String? = null
        /**
         * Returns the unique, system-generated identifier for the profile.
         */
        public var profileId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.b2bi.model.CreateProfileResponse) : this() {
            this.businessName = x.businessName
            this.createdAt = x.createdAt
            this.email = x.email
            this.logGroupName = x.logGroupName
            this.logging = x.logging
            this.name = x.name
            this.phone = x.phone
            this.profileArn = x.profileArn
            this.profileId = x.profileId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.b2bi.model.CreateProfileResponse = CreateProfileResponse(this)

        internal fun correctErrors(): Builder {
            if (businessName == null) businessName = ""
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (name == null) name = ""
            if (phone == null) phone = ""
            if (profileArn == null) profileArn = ""
            if (profileId == null) profileId = ""
            return this
        }
    }
}
