// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.b2bi.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Returns the capability summary details. A trading capability contains the information required to transform incoming EDI documents into JSON or XML outputs.
 */
public class CapabilitySummary private constructor(builder: Builder) {
    /**
     * Returns a system-assigned unique identifier for the capability.
     */
    public val capabilityId: kotlin.String = requireNotNull(builder.capabilityId) { "A non-null value must be provided for capabilityId" }
    /**
     * Returns a timestamp for creation date and time of the capability.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * Returns a timestamp that identifies the most recent date and time that the capability was modified.
     */
    public val modifiedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.modifiedAt
    /**
     * The display name of the capability.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Returns the type of the capability. Currently, only `edi` is supported.
     */
    public val type: aws.sdk.kotlin.services.b2bi.model.CapabilityType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.b2bi.model.CapabilitySummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CapabilitySummary(")
        append("capabilityId=$capabilityId,")
        append("createdAt=$createdAt,")
        append("modifiedAt=$modifiedAt,")
        append("name=$name,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = capabilityId.hashCode()
        result = 31 * result + (createdAt.hashCode())
        result = 31 * result + (modifiedAt?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CapabilitySummary

        if (capabilityId != other.capabilityId) return false
        if (createdAt != other.createdAt) return false
        if (modifiedAt != other.modifiedAt) return false
        if (name != other.name) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.b2bi.model.CapabilitySummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Returns a system-assigned unique identifier for the capability.
         */
        public var capabilityId: kotlin.String? = null
        /**
         * Returns a timestamp for creation date and time of the capability.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Returns a timestamp that identifies the most recent date and time that the capability was modified.
         */
        public var modifiedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The display name of the capability.
         */
        public var name: kotlin.String? = null
        /**
         * Returns the type of the capability. Currently, only `edi` is supported.
         */
        public var type: aws.sdk.kotlin.services.b2bi.model.CapabilityType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.b2bi.model.CapabilitySummary) : this() {
            this.capabilityId = x.capabilityId
            this.createdAt = x.createdAt
            this.modifiedAt = x.modifiedAt
            this.name = x.name
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.b2bi.model.CapabilitySummary = CapabilitySummary(this)

        internal fun correctErrors(): Builder {
            if (capabilityId == null) capabilityId = ""
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (name == null) name = ""
            if (type == null) type = CapabilityType.SdkUnknown("no value provided")
            return this
        }
    }
}
