/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.runtime.http.retries;

import aws.smithy.kotlin.runtime.ProtocolResponse;
import aws.smithy.kotlin.runtime.ServiceErrorMetadata;
import aws.smithy.kotlin.runtime.ServiceException;
import aws.smithy.kotlin.runtime.http.response.HttpResponse;
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective;
import aws.smithy.kotlin.runtime.retries.policy.RetryErrorType;
import aws.smithy.kotlin.runtime.retries.policy.StandardRetryPolicy;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0002R\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Laws/sdk/kotlin/runtime/http/retries/AwsRetryPolicy;", "Laws/smithy/kotlin/runtime/retries/policy/StandardRetryPolicy;", "<init>", "()V", "evaluateSpecificExceptions", "Laws/smithy/kotlin/runtime/retries/policy/RetryDirective;", "ex", "", "evaluateServiceException", "Laws/smithy/kotlin/runtime/ServiceException;", "statusCode", "", "Laws/smithy/kotlin/runtime/ServiceErrorMetadata;", "getStatusCode", "(Laws/smithy/kotlin/runtime/ServiceErrorMetadata;)Ljava/lang/Integer;", "Companion", "aws-http"})
@SourceDebugExtension(value={"SMAP\nAwsRetryPolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AwsRetryPolicy.kt\naws/sdk/kotlin/runtime/http/retries/AwsRetryPolicy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n1#2:64\n*E\n"})
public class AwsRetryPolicy
extends StandardRetryPolicy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final AwsRetryPolicy Default = new AwsRetryPolicy();
    @NotNull
    private static final Map<String, RetryErrorType> knownErrorTypes;
    @NotNull
    private static final Map<Integer, RetryErrorType> knownStatusCodes;

    @Nullable
    protected RetryDirective evaluateSpecificExceptions(@NotNull Throwable ex) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        return ex instanceof ServiceException ? this.evaluateServiceException((ServiceException)ex) : null;
    }

    private final RetryDirective evaluateServiceException(ServiceException ex) {
        RetryDirective.RetryError retryError;
        RetryErrorType retryErrorType;
        ServiceErrorMetadata $this$evaluateServiceException_u24lambda_u241 = ex.getSdkErrorMetadata();
        boolean bl = false;
        RetryErrorType retryErrorType2 = knownErrorTypes.get($this$evaluateServiceException_u24lambda_u241.getErrorCode());
        if (retryErrorType2 == null) {
            retryErrorType2 = knownStatusCodes.get(this.getStatusCode($this$evaluateServiceException_u24lambda_u241));
        }
        if ((retryErrorType = retryErrorType2) != null) {
            RetryErrorType it = retryErrorType;
            boolean bl2 = false;
            retryError = new RetryDirective.RetryError(it);
        } else {
            retryError = null;
        }
        return (RetryDirective)retryError;
    }

    private final Integer getStatusCode(ServiceErrorMetadata $this$statusCode) {
        ProtocolResponse protocolResponse = $this$statusCode.getProtocolResponse();
        HttpResponse httpResponse = protocolResponse instanceof HttpResponse ? (HttpResponse)protocolResponse : null;
        return httpResponse != null && (httpResponse = httpResponse.getStatus()) != null ? Integer.valueOf(httpResponse.getValue()) : null;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"BandwidthLimitExceeded", (Object)RetryErrorType.Throttling), TuplesKt.to((Object)"EC2ThrottledException", (Object)RetryErrorType.Throttling), TuplesKt.to((Object)"IDPCommunicationError", (Object)RetryErrorType.Transient), TuplesKt.to((Object)"LimitExceededException", (Object)RetryErrorType.Throttling), TuplesKt.to((Object)"PriorRequestNotComplete", (Object)RetryErrorType.Throttling), TuplesKt.to((Object)"ProvisionedThroughputExceededException", (Object)RetryErrorType.Throttling), TuplesKt.to((Object)"RequestLimitExceeded", (Object)RetryErrorType.Throttling), TuplesKt.to((Object)"RequestThrottled", (Object)RetryErrorType.Throttling), TuplesKt.to((Object)"RequestThrottledException", (Object)RetryErrorType.Throttling), TuplesKt.to((Object)"RequestTimeout", (Object)RetryErrorType.Transient), TuplesKt.to((Object)"RequestTimeoutException", (Object)RetryErrorType.Transient), TuplesKt.to((Object)"SlowDown", (Object)RetryErrorType.Throttling), TuplesKt.to((Object)"ThrottledException", (Object)RetryErrorType.Throttling), TuplesKt.to((Object)"Throttling", (Object)RetryErrorType.Throttling), TuplesKt.to((Object)"ThrottlingException", (Object)RetryErrorType.Throttling), TuplesKt.to((Object)"TooManyRequestsException", (Object)RetryErrorType.Throttling), TuplesKt.to((Object)"TransactionInProgressException", (Object)RetryErrorType.Throttling)};
        knownErrorTypes = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)500, (Object)RetryErrorType.Transient), TuplesKt.to((Object)502, (Object)RetryErrorType.Transient), TuplesKt.to((Object)503, (Object)RetryErrorType.Transient), TuplesKt.to((Object)504, (Object)RetryErrorType.Transient)};
        knownStatusCodes = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR \u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000b0\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\r\u00a8\u0006\u0011"}, d2={"Laws/sdk/kotlin/runtime/http/retries/AwsRetryPolicy$Companion;", "", "<init>", "()V", "Default", "Laws/sdk/kotlin/runtime/http/retries/AwsRetryPolicy;", "getDefault", "()Laws/sdk/kotlin/runtime/http/retries/AwsRetryPolicy;", "knownErrorTypes", "", "", "Laws/smithy/kotlin/runtime/retries/policy/RetryErrorType;", "getKnownErrorTypes$aws_http", "()Ljava/util/Map;", "knownStatusCodes", "", "getKnownStatusCodes$aws_http", "aws-http"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AwsRetryPolicy getDefault() {
            return Default;
        }

        @NotNull
        public final Map<String, RetryErrorType> getKnownErrorTypes$aws_http() {
            return knownErrorTypes;
        }

        @NotNull
        public final Map<Integer, RetryErrorType> getKnownStatusCodes$aws_http() {
            return knownStatusCodes;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

