/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.runtime.http.retries;

import aws.smithy.kotlin.runtime.ProtocolResponse;
import aws.smithy.kotlin.runtime.ServiceErrorMetadata;
import aws.smithy.kotlin.runtime.ServiceException;
import aws.smithy.kotlin.runtime.http.response.HttpResponse;
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective;
import aws.smithy.kotlin.runtime.retries.policy.RetryErrorType;
import aws.smithy.kotlin.runtime.retries.policy.StandardRetryPolicy;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0015H\u0014R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR \u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00060\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u0004\u0018\u00010\n*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0016"}, d2={"Laws/sdk/kotlin/runtime/http/retries/AwsDefaultRetryPolicy;", "Laws/smithy/kotlin/runtime/retries/policy/StandardRetryPolicy;", "()V", "knownErrorTypes", "", "", "Laws/smithy/kotlin/runtime/retries/policy/RetryErrorType;", "getKnownErrorTypes$aws_http", "()Ljava/util/Map;", "knownStatusCodes", "", "getKnownStatusCodes$aws_http", "statusCode", "Laws/smithy/kotlin/runtime/ServiceErrorMetadata;", "getStatusCode", "(Laws/smithy/kotlin/runtime/ServiceErrorMetadata;)Ljava/lang/Integer;", "evaluateServiceException", "Laws/smithy/kotlin/runtime/retries/policy/RetryDirective;", "ex", "Laws/smithy/kotlin/runtime/ServiceException;", "evaluateSpecificExceptions", "", "aws-http"})
@SourceDebugExtension(value={"SMAP\nAwsDefaultRetryPolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AwsDefaultRetryPolicy.kt\naws/sdk/kotlin/runtime/http/retries/AwsDefaultRetryPolicy\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,56:1\n1#2:57\n*E\n"})
public final class AwsDefaultRetryPolicy
extends StandardRetryPolicy {
    @NotNull
    public static final AwsDefaultRetryPolicy INSTANCE = new AwsDefaultRetryPolicy();
    @NotNull
    private static final Map<String, RetryErrorType> knownErrorTypes;
    @NotNull
    private static final Map<Integer, RetryErrorType> knownStatusCodes;

    private AwsDefaultRetryPolicy() {
    }

    @NotNull
    public final Map<String, RetryErrorType> getKnownErrorTypes$aws_http() {
        return knownErrorTypes;
    }

    @NotNull
    public final Map<Integer, RetryErrorType> getKnownStatusCodes$aws_http() {
        return knownStatusCodes;
    }

    @Nullable
    protected RetryDirective evaluateSpecificExceptions(@NotNull Throwable ex) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        return ex instanceof ServiceException ? this.evaluateServiceException((ServiceException)ex) : null;
    }

    private final RetryDirective evaluateServiceException(ServiceException ex) {
        RetryDirective.RetryError retryError;
        RetryErrorType retryErrorType;
        ServiceErrorMetadata $this$evaluateServiceException_u24lambda_u241 = ex.getSdkErrorMetadata();
        boolean bl = false;
        RetryErrorType retryErrorType2 = knownErrorTypes.get($this$evaluateServiceException_u24lambda_u241.getErrorCode());
        if (retryErrorType2 == null) {
            retryErrorType2 = knownStatusCodes.get(INSTANCE.getStatusCode($this$evaluateServiceException_u24lambda_u241));
        }
        if ((retryErrorType = retryErrorType2) != null) {
            RetryErrorType it = retryErrorType;
            boolean bl2 = false;
            retryError = new RetryDirective.RetryError(it);
        } else {
            retryError = null;
        }
        return (RetryDirective)retryError;
    }

    private final Integer getStatusCode(ServiceErrorMetadata $this$statusCode) {
        ProtocolResponse protocolResponse = $this$statusCode.getProtocolResponse();
        HttpResponse httpResponse = protocolResponse instanceof HttpResponse ? (HttpResponse)protocolResponse : null;
        return httpResponse != null && (httpResponse = httpResponse.getStatus()) != null ? Integer.valueOf(httpResponse.getValue()) : null;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"BandwidthLimitExceeded", (Object)RetryErrorType.Throttling), TuplesKt.to((Object)"EC2ThrottledException", (Object)RetryErrorType.Throttling), TuplesKt.to((Object)"IDPCommunicationError", (Object)RetryErrorType.Transient), TuplesKt.to((Object)"LimitExceededException", (Object)RetryErrorType.Throttling), TuplesKt.to((Object)"PriorRequestNotComplete", (Object)RetryErrorType.Throttling), TuplesKt.to((Object)"ProvisionedThroughputExceededException", (Object)RetryErrorType.Throttling), TuplesKt.to((Object)"RequestLimitExceeded", (Object)RetryErrorType.Throttling), TuplesKt.to((Object)"RequestThrottled", (Object)RetryErrorType.Throttling), TuplesKt.to((Object)"RequestThrottledException", (Object)RetryErrorType.Throttling), TuplesKt.to((Object)"RequestTimeout", (Object)RetryErrorType.Transient), TuplesKt.to((Object)"RequestTimeoutException", (Object)RetryErrorType.Transient), TuplesKt.to((Object)"SlowDown", (Object)RetryErrorType.Throttling), TuplesKt.to((Object)"ThrottledException", (Object)RetryErrorType.Throttling), TuplesKt.to((Object)"Throttling", (Object)RetryErrorType.Throttling), TuplesKt.to((Object)"ThrottlingException", (Object)RetryErrorType.Throttling), TuplesKt.to((Object)"TooManyRequestsException", (Object)RetryErrorType.Throttling), TuplesKt.to((Object)"TransactionInProgressException", (Object)RetryErrorType.Throttling)};
        knownErrorTypes = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)500, (Object)RetryErrorType.Transient), TuplesKt.to((Object)502, (Object)RetryErrorType.Transient), TuplesKt.to((Object)503, (Object)RetryErrorType.Transient), TuplesKt.to((Object)504, (Object)RetryErrorType.Transient)};
        knownStatusCodes = MapsKt.mapOf((Pair[])pairArray);
    }
}

