/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.runtime.protocol.eventstream;

import aws.sdk.kotlin.runtime.InternalSdkApi;
import aws.smithy.kotlin.runtime.hashing.Crc32Kt;
import aws.smithy.kotlin.runtime.io.Buffer;
import aws.smithy.kotlin.runtime.io.MutableBuffer;
import aws.smithy.kotlin.runtime.io.MutableBufferKt;
import aws.smithy.kotlin.runtime.io.SdkByteBuffer;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.UStringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalSdkApi
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0087\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u0019"}, d2={"Laws/sdk/kotlin/runtime/protocol/eventstream/Prelude;", "", "totalLen", "", "headersLength", "(II)V", "getHeadersLength", "()I", "payloadLen", "getPayloadLen", "getTotalLen", "component1", "component2", "copy", "encode", "", "dest", "Laws/smithy/kotlin/runtime/io/MutableBuffer;", "equals", "", "other", "hashCode", "toString", "", "Companion", "aws-event-stream"})
public final class Prelude {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int totalLen;
    private final int headersLength;

    public Prelude(int totalLen, int headersLength) {
        this.totalLen = totalLen;
        this.headersLength = headersLength;
    }

    public final int getTotalLen() {
        return this.totalLen;
    }

    public final int getHeadersLength() {
        return this.headersLength;
    }

    public final int getPayloadLen() {
        return this.totalLen - 12 - this.headersLength - 4;
    }

    public final void encode(@NotNull MutableBuffer dest) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        byte[] bytes = new byte[8];
        SdkByteBuffer preludeBuf = SdkByteBuffer.Companion.of$default((SdkByteBuffer.Companion)SdkByteBuffer.Companion, (byte[])bytes, (int)0, (int)0, (int)6, null);
        preludeBuf.writeInt(this.totalLen);
        preludeBuf.writeInt(this.headersLength);
        MutableBufferKt.writeFully-aPcrCvc$default((MutableBuffer)dest, (SdkByteBuffer)preludeBuf, (long)0L, (int)2, null);
        dest.writeUInt-WZ4Q5Ns(Crc32Kt.crc32((byte[])bytes));
    }

    public final int component1() {
        return this.totalLen;
    }

    public final int component2() {
        return this.headersLength;
    }

    @NotNull
    public final Prelude copy(int totalLen, int headersLength) {
        return new Prelude(totalLen, headersLength);
    }

    public static /* synthetic */ Prelude copy$default(Prelude prelude, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = prelude.totalLen;
        }
        if ((n3 & 2) != 0) {
            n2 = prelude.headersLength;
        }
        return prelude.copy(n, n2);
    }

    @NotNull
    public String toString() {
        return "Prelude(totalLen=" + this.totalLen + ", headersLength=" + this.headersLength + ')';
    }

    public int hashCode() {
        int result = Integer.hashCode(this.totalLen);
        result = result * 31 + Integer.hashCode(this.headersLength);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Prelude)) {
            return false;
        }
        Prelude prelude = (Prelude)other;
        if (this.totalLen != prelude.totalLen) {
            return false;
        }
        return this.headersLength == prelude.headersLength;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Laws/sdk/kotlin/runtime/protocol/eventstream/Prelude$Companion;", "", "()V", "decode", "Laws/sdk/kotlin/runtime/protocol/eventstream/Prelude;", "buffer", "Laws/smithy/kotlin/runtime/io/Buffer;", "aws-event-stream"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Prelude decode(@NotNull Buffer buffer) {
            SdkByteBuffer sdkByteBuffer;
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            if (!(Long.compareUnsigned(buffer.getReadRemaining-s-VKNKU(), ULong.constructor-impl((long)12)) >= 0)) {
                boolean $i$a$-check-Prelude$Companion$decode$52 = false;
                String $i$a$-check-Prelude$Companion$decode$52 = "Invalid message prelude";
                throw new IllegalStateException($i$a$-check-Prelude$Companion$decode$52.toString());
            }
            byte[] crcBuffer = new byte[8];
            Buffer.DefaultImpls.readFully$default((Buffer)buffer, (byte[])crcBuffer, (int)0, (int)0, (int)6, null);
            int expectedCrc = buffer.readUInt-pVg5ArA();
            int computedCrc = Crc32Kt.crc32((byte[])crcBuffer);
            SdkByteBuffer $this$decode_u24lambda_u2d1 = sdkByteBuffer = SdkByteBuffer.Companion.of$default((SdkByteBuffer.Companion)SdkByteBuffer.Companion, (byte[])crcBuffer, (int)0, (int)0, (int)6, null);
            boolean bl = false;
            $this$decode_u24lambda_u2d1.advance-VKZWuLQ(ULong.constructor-impl((long)8));
            SdkByteBuffer preludeBuffer = sdkByteBuffer;
            int totalLen = preludeBuffer.readUInt-pVg5ArA();
            int headerLen = preludeBuffer.readUInt-pVg5ArA();
            if (!(Integer.compareUnsigned(totalLen, UInt.constructor-impl((int)0x1000000)) <= 0)) {
                boolean $i$a$-check-Prelude$Companion$decode$62 = false;
                String $i$a$-check-Prelude$Companion$decode$62 = "Invalid Message size: " + UInt.toString-impl((int)totalLen);
                throw new IllegalStateException($i$a$-check-Prelude$Companion$decode$62.toString());
            }
            if (!(Integer.compareUnsigned(headerLen, UInt.constructor-impl((int)131072)) <= 0)) {
                boolean $i$a$-check-Prelude$Companion$decode$72 = false;
                String $i$a$-check-Prelude$Companion$decode$72 = "Invalid Header size: " + UInt.toString-impl((int)headerLen);
                throw new IllegalStateException($i$a$-check-Prelude$Companion$decode$72.toString());
            }
            if (!(expectedCrc == computedCrc)) {
                boolean bl2 = false;
                String string = "Prelude checksum mismatch; expected=0x" + UStringsKt.toString-V7xB4Y4((int)expectedCrc, (int)16) + "; calculated=0x" + UStringsKt.toString-V7xB4Y4((int)computedCrc, (int)16);
                throw new IllegalStateException(string.toString());
            }
            return new Prelude(totalLen, headerLen);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

