/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.runtime.protocol.eventstream;

import aws.sdk.kotlin.runtime.InternalSdkApi;
import aws.sdk.kotlin.runtime.protocol.eventstream.Header;
import aws.sdk.kotlin.runtime.protocol.eventstream.MessageBuilder;
import aws.sdk.kotlin.runtime.protocol.eventstream.Prelude;
import aws.smithy.kotlin.runtime.hashing.Crc32Kt;
import aws.smithy.kotlin.runtime.io.Buffer;
import aws.smithy.kotlin.runtime.io.BufferKt;
import aws.smithy.kotlin.runtime.io.MutableBuffer;
import aws.smithy.kotlin.runtime.io.SdkByteBuffer;
import aws.smithy.kotlin.runtime.io.SdkByteBufferKt;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.UStringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalSdkApi
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0087\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001b"}, d2={"Laws/sdk/kotlin/runtime/protocol/eventstream/Message;", "", "headers", "", "Laws/sdk/kotlin/runtime/protocol/eventstream/Header;", "payload", "", "(Ljava/util/List;[B)V", "getHeaders", "()Ljava/util/List;", "getPayload", "()[B", "component1", "component2", "copy", "encode", "", "dest", "Laws/smithy/kotlin/runtime/io/MutableBuffer;", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "aws-event-stream"})
public final class Message {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Header> headers;
    @NotNull
    private final byte[] payload;

    public Message(@NotNull List<Header> headers, @NotNull byte[] payload) {
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        this.headers = headers;
        this.payload = payload;
    }

    @NotNull
    public final List<Header> getHeaders() {
        return this.headers;
    }

    @NotNull
    public final byte[] getPayload() {
        return this.payload;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)Reflection.getOrCreateKotlinClass(other.getClass()))) {
            return false;
        }
        Message cfr_ignored_0 = (Message)other;
        if (!Intrinsics.areEqual(this.headers, ((Message)other).headers)) {
            return false;
        }
        return Arrays.equals(this.payload, ((Message)other).payload);
    }

    public int hashCode() {
        int result = ((Object)this.headers).hashCode();
        result = 31 * result + Arrays.hashCode(this.payload);
        return result;
    }

    public final void encode(@NotNull MutableBuffer dest) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        SdkByteBuffer encodedHeaders = new SdkByteBuffer(16L, false, false, 6, null);
        Iterable $this$forEach$iv = this.headers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Header it = (Header)element$iv;
            boolean bl = false;
            it.encode((MutableBuffer)encodedHeaders);
        }
        int headersLen = (int)encodedHeaders.getReadRemaining-s-VKNKU();
        int payloadLen = this.payload.length;
        int messageLen = 12 + headersLen + payloadLen + 4;
        if (!(headersLen < 131072)) {
            boolean $i$a$-check-Message$encode$42 = false;
            String $i$a$-check-Message$encode$42 = "Invalid Headers length: " + headersLen;
            throw new IllegalStateException($i$a$-check-Message$encode$42.toString());
        }
        if (!(messageLen < 0x1000000)) {
            boolean $i$a$-check-Message$encode$52 = false;
            String $i$a$-check-Message$encode$52 = "Invalid Message length: " + messageLen;
            throw new IllegalStateException($i$a$-check-Message$encode$52.toString());
        }
        Prelude prelude = new Prelude(messageLen, headersLen);
        byte[] encodedMessage = new byte[messageLen - 4];
        SdkByteBuffer messageBuf = SdkByteBuffer.Companion.of$default((SdkByteBuffer.Companion)SdkByteBuffer.Companion, (byte[])encodedMessage, (int)0, (int)0, (int)6, null);
        prelude.encode((MutableBuffer)messageBuf);
        SdkByteBufferKt.writeFully-aPcrCvc$default((SdkByteBuffer)messageBuf, (SdkByteBuffer)encodedHeaders, (long)0L, (int)2, null);
        MutableBuffer.DefaultImpls.writeFully$default((MutableBuffer)((MutableBuffer)messageBuf), (byte[])this.payload, (int)0, (int)0, (int)6, null);
        MutableBuffer.DefaultImpls.writeFully$default((MutableBuffer)dest, (byte[])encodedMessage, (int)0, (int)0, (int)6, null);
        dest.writeInt(Crc32Kt.crc32((byte[])encodedMessage));
    }

    @NotNull
    public final List<Header> component1() {
        return this.headers;
    }

    @NotNull
    public final byte[] component2() {
        return this.payload;
    }

    @NotNull
    public final Message copy(@NotNull List<Header> headers, @NotNull byte[] payload) {
        Intrinsics.checkNotNullParameter(headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        return new Message(headers, payload);
    }

    public static /* synthetic */ Message copy$default(Message message, List list, byte[] byArray, int n, Object object) {
        if ((n & 1) != 0) {
            list = message.headers;
        }
        if ((n & 2) != 0) {
            byArray = message.payload;
        }
        return message.copy(list, byArray);
    }

    @NotNull
    public String toString() {
        return "Message(headers=" + this.headers + ", payload=" + Arrays.toString(this.payload) + ')';
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Laws/sdk/kotlin/runtime/protocol/eventstream/Message$Companion;", "", "()V", "decode", "Laws/sdk/kotlin/runtime/protocol/eventstream/Message;", "buffer", "Laws/smithy/kotlin/runtime/io/Buffer;", "aws-event-stream"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Message decode(@NotNull Buffer buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            int totalLen = buffer.readUInt-pVg5ArA();
            if (!(Integer.compareUnsigned(totalLen, UInt.constructor-impl((int)0x1000000)) <= 0)) {
                boolean $i$a$-check-Message$Companion$decode$52 = false;
                String $i$a$-check-Message$Companion$decode$52 = "Invalid Message size: " + UInt.toString-impl((int)totalLen);
                throw new IllegalStateException($i$a$-check-Message$Companion$decode$52.toString());
            }
            byte[] messageBytes = new byte[totalLen - 4];
            SdkByteBuffer messageBuffer = SdkByteBuffer.Companion.of$default((SdkByteBuffer.Companion)SdkByteBuffer.Companion, (byte[])messageBytes, (int)0, (int)0, (int)6, null);
            messageBuffer.writeUInt-WZ4Q5Ns(totalLen);
            BufferKt.readFully-aPcrCvc$default((Buffer)buffer, (SdkByteBuffer)messageBuffer, (long)0L, (int)2, null);
            Prelude prelude = Prelude.Companion.decode((Buffer)messageBuffer);
            int remaining = prelude.getTotalLen() - 12 - 4;
            if (!(Long.compareUnsigned(messageBuffer.getReadRemaining-s-VKNKU(), ULong.constructor-impl((long)remaining)) >= 0)) {
                boolean bl = false;
                String string = "Invalid buffer, not enough remaining; have: " + ULong.toString-impl((long)messageBuffer.getReadRemaining-s-VKNKU()) + "; expected " + remaining;
                throw new IllegalStateException(string.toString());
            }
            MessageBuilder message = new MessageBuilder();
            long headerBytesConsumed = 0L;
            headerBytesConsumed = 0L;
            while (Long.compareUnsigned(headerBytesConsumed, ULong.constructor-impl((long)prelude.getHeadersLength())) < 0) {
                long start = messageBuffer.getReadPosition-s-VKNKU();
                Header header = Header.Companion.decode((Buffer)messageBuffer);
                headerBytesConsumed = ULong.constructor-impl((long)(headerBytesConsumed + ULong.constructor-impl((long)(messageBuffer.getReadPosition-s-VKNKU() - start))));
                message.addHeader(header);
            }
            if (!(headerBytesConsumed == ULong.constructor-impl((long)prelude.getHeadersLength()))) {
                boolean $i$a$-check-Message$Companion$decode$62 = false;
                String $i$a$-check-Message$Companion$decode$62 = "Invalid Message: expected " + prelude.getHeadersLength() + " header bytes; consumed " + ULong.toString-impl((long)headerBytesConsumed);
                throw new IllegalStateException($i$a$-check-Message$Companion$decode$62.toString());
            }
            byte[] payload = new byte[prelude.getPayloadLen()];
            Buffer.DefaultImpls.readFully$default((Buffer)((Buffer)messageBuffer), (byte[])payload, (int)0, (int)0, (int)6, null);
            message.setPayload(payload);
            int expectedCrc = buffer.readUInt-pVg5ArA();
            int computedCrc = Crc32Kt.crc32((byte[])messageBytes);
            if (!(computedCrc == expectedCrc)) {
                boolean bl = false;
                String string = "Message checksum mismatch; expected=0x" + UStringsKt.toString-V7xB4Y4((int)expectedCrc, (int)16) + "; calculated=0x" + UStringsKt.toString-V7xB4Y4((int)computedCrc, (int)16);
                throw new IllegalStateException(string.toString());
            }
            return message.build();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

