/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.runtime.protocol.eventstream;

import aws.sdk.kotlin.runtime.InternalSdkApi;
import aws.sdk.kotlin.runtime.protocol.eventstream.HeaderValue;
import aws.smithy.kotlin.runtime.io.Buffer;
import aws.smithy.kotlin.runtime.io.MutableBuffer;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@InternalSdkApi
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0019"}, d2={"Laws/sdk/kotlin/runtime/protocol/eventstream/Header;", "", "name", "", "value", "Laws/sdk/kotlin/runtime/protocol/eventstream/HeaderValue;", "(Ljava/lang/String;Laws/sdk/kotlin/runtime/protocol/eventstream/HeaderValue;)V", "getName", "()Ljava/lang/String;", "getValue", "()Laws/sdk/kotlin/runtime/protocol/eventstream/HeaderValue;", "component1", "component2", "copy", "encode", "", "dest", "Laws/smithy/kotlin/runtime/io/MutableBuffer;", "equals", "", "other", "hashCode", "", "toString", "Companion", "aws-event-stream"})
public final class Header {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final HeaderValue value;

    public Header(@NotNull String name, @NotNull HeaderValue value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.name = name;
        this.value = value;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final HeaderValue getValue() {
        return this.value;
    }

    public final void encode(@NotNull MutableBuffer dest) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        byte[] bytes = StringsKt.encodeToByteArray((String)this.name);
        if (!(bytes.length < 255)) {
            boolean bl = false;
            String string = "Header name too long";
            throw new IllegalStateException(string.toString());
        }
        dest.writeByte((byte)bytes.length);
        MutableBuffer.DefaultImpls.writeFully$default((MutableBuffer)dest, (byte[])bytes, (int)0, (int)0, (int)6, null);
        this.value.encode(dest);
    }

    @NotNull
    public final String component1() {
        return this.name;
    }

    @NotNull
    public final HeaderValue component2() {
        return this.value;
    }

    @NotNull
    public final Header copy(@NotNull String name, @NotNull HeaderValue value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new Header(name, value);
    }

    public static /* synthetic */ Header copy$default(Header header, String string, HeaderValue headerValue, int n, Object object) {
        if ((n & 1) != 0) {
            string = header.name;
        }
        if ((n & 2) != 0) {
            headerValue = header.value;
        }
        return header.copy(string, headerValue);
    }

    @NotNull
    public String toString() {
        return "Header(name=" + this.name + ", value=" + this.value + ')';
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = result * 31 + this.value.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Header)) {
            return false;
        }
        Header header = (Header)other;
        if (!Intrinsics.areEqual((Object)this.name, (Object)header.name)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.value, (Object)header.value);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Laws/sdk/kotlin/runtime/protocol/eventstream/Header$Companion;", "", "()V", "decode", "Laws/sdk/kotlin/runtime/protocol/eventstream/Header;", "buffer", "Laws/smithy/kotlin/runtime/io/Buffer;", "aws-event-stream"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Header decode(@NotNull Buffer buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            if (!(Long.compareUnsigned(buffer.getReadRemaining-s-VKNKU(), ULong.constructor-impl((long)2)) >= 0)) {
                boolean $i$a$-check-Header$Companion$decode$32 = false;
                String $i$a$-check-Header$Companion$decode$32 = "Invalid frame header; require at least 2 bytes";
                throw new IllegalStateException($i$a$-check-Header$Companion$decode$32.toString());
            }
            byte nameLen = buffer.readByte();
            if (!(nameLen > 0)) {
                boolean $i$a$-check-Header$Companion$decode$42 = false;
                String $i$a$-check-Header$Companion$decode$42 = "Invalid header name length: " + nameLen;
                throw new IllegalStateException($i$a$-check-Header$Companion$decode$42.toString());
            }
            byte[] nameBytes = new byte[nameLen];
            Buffer.DefaultImpls.readFully$default((Buffer)buffer, (byte[])nameBytes, (int)0, (int)0, (int)6, null);
            HeaderValue value = HeaderValue.Companion.decode(buffer);
            return new Header(StringsKt.decodeToString((byte[])nameBytes), value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

