// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.runtime.auth.credentials.internal.ssooidc.serde

import aws.sdk.kotlin.runtime.auth.credentials.internal.ssooidc.model.CreateTokenResponse
import aws.sdk.kotlin.runtime.auth.credentials.internal.ssooidc.model.SsoOidcException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateTokenOperationDeserializer: HttpDeserializer.NonStreaming<CreateTokenResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): CreateTokenResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateTokenError(context, call, payload)
        }
        val builder = CreateTokenResponse.Builder()

        if (payload != null) {
            deserializeCreateTokenOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwCreateTokenError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw SsoOidcException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AuthorizationPendingException" -> AuthorizationPendingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ExpiredTokenException" -> ExpiredTokenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidClientException" -> InvalidClientExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidGrantException" -> InvalidGrantExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidRequestException" -> InvalidRequestExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidScopeException" -> InvalidScopeExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "SlowDownException" -> SlowDownExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedClientException" -> UnauthorizedClientExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnsupportedGrantTypeException" -> UnsupportedGrantTypeExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> SsoOidcException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateTokenOperationBody(builder: CreateTokenResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACCESSTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("accessToken"))
    val EXPIRESIN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("expiresIn"))
    val IDTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("idToken"))
    val REFRESHTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("refreshToken"))
    val TOKENTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("tokenType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCESSTOKEN_DESCRIPTOR)
        field(EXPIRESIN_DESCRIPTOR)
        field(IDTOKEN_DESCRIPTOR)
        field(REFRESHTOKEN_DESCRIPTOR)
        field(TOKENTYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCESSTOKEN_DESCRIPTOR.index -> builder.accessToken = deserializeString()
                EXPIRESIN_DESCRIPTOR.index -> builder.expiresIn = deserializeInt()
                IDTOKEN_DESCRIPTOR.index -> builder.idToken = deserializeString()
                REFRESHTOKEN_DESCRIPTOR.index -> builder.refreshToken = deserializeString()
                TOKENTYPE_DESCRIPTOR.index -> builder.tokenType = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
