// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.runtime.auth.credentials.internal.sts.serde

import aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.AssumeRoleResponse
import aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.AssumedRoleUser
import aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.Credentials
import aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.StsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponse
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class AssumeRoleOperationDeserializer: HttpDeserializer.NonStreaming<AssumeRoleResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): AssumeRoleResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwAssumeRoleError(context, call, payload)
        }
        val builder = AssumeRoleResponse.Builder()

        if (payload != null) {
            deserializeAssumeRoleOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwAssumeRoleError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponse(payload)
    } catch (ex: Exception) {
        throw StsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ExpiredTokenException" -> ExpiredTokenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "MalformedPolicyDocument" -> MalformedPolicyDocumentExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "PackedPolicyTooLarge" -> PackedPolicyTooLargeExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RegionDisabledException" -> RegionDisabledExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> StsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeAssumeRoleOperationBody(builder: AssumeRoleResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "AssumeRole")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // AssumedRoleUser com.amazonaws.sts#AssumeRoleResponse$AssumedRoleUser
            "AssumedRoleUser" -> builder.assumedRoleUser = deserializeAssumedRoleUserDocument(curr)
            // Credentials com.amazonaws.sts#AssumeRoleResponse$Credentials
            "Credentials" -> builder.credentials = deserializeCredentialsDocument(curr)
            // PackedPolicySize com.amazonaws.sts#AssumeRoleResponse$PackedPolicySize
            "PackedPolicySize" -> builder.packedPolicySize = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.sts#nonNegativeIntegerType`)" }
            // SourceIdentity com.amazonaws.sts#AssumeRoleResponse$SourceIdentity
            "SourceIdentity" -> builder.sourceIdentity = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.sts#sourceIdentityType`)" }
            else -> {}
        }
        curr.drop()
    }
}
