/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.runtime.config.imds;

import aws.sdk.kotlin.runtime.config.imds.EC2MetadataError;
import aws.smithy.kotlin.runtime.http.HttpStatusCode;
import aws.smithy.kotlin.runtime.http.HttpStatusCodeKt;
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective;
import aws.smithy.kotlin.runtime.retries.policy.RetryErrorType;
import aws.smithy.kotlin.runtime.retries.policy.StandardRetryPolicy;
import aws.smithy.kotlin.runtime.telemetry.logging.CoroutineContextLogExtKt;
import aws.smithy.kotlin.runtime.telemetry.logging.Logger;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Laws/sdk/kotlin/runtime/config/imds/ImdsRetryPolicy;", "Laws/smithy/kotlin/runtime/retries/policy/StandardRetryPolicy;", "callContext", "Lkotlin/coroutines/CoroutineContext;", "<init>", "(Lkotlin/coroutines/CoroutineContext;)V", "evaluateSpecificExceptions", "Laws/smithy/kotlin/runtime/retries/policy/RetryDirective$RetryError;", "ex", "", "aws-config"})
@SourceDebugExtension(value={"SMAP\nImdsRetryPolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImdsRetryPolicy.kt\naws/sdk/kotlin/runtime/config/imds/ImdsRetryPolicy\n+ 2 CoroutineContextLogExt.kt\naws/smithy/kotlin/runtime/telemetry/logging/CoroutineContextLogExtKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,34:1\n258#2:35\n259#2:37\n1#3:36\n*S KotlinDebug\n*F\n+ 1 ImdsRetryPolicy.kt\naws/sdk/kotlin/runtime/config/imds/ImdsRetryPolicy\n*L\n25#1:35\n25#1:37\n25#1:36\n*E\n"})
public final class ImdsRetryPolicy
extends StandardRetryPolicy {
    @NotNull
    private final CoroutineContext callContext;

    public ImdsRetryPolicy(@NotNull CoroutineContext callContext) {
        Intrinsics.checkNotNullParameter((Object)callContext, (String)"callContext");
        this.callContext = callContext;
    }

    @Nullable
    protected RetryDirective.RetryError evaluateSpecificExceptions(@NotNull Throwable ex) {
        RetryDirective.RetryError retryError;
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        if (ex instanceof EC2MetadataError) {
            HttpStatusCode status = ((EC2MetadataError)((Object)ex)).getStatus();
            if (HttpStatusCodeKt.category((HttpStatusCode)status) == HttpStatusCode.Category.SERVER_ERROR) {
                retryError = new RetryDirective.RetryError(RetryErrorType.ServerSide);
            } else if (Intrinsics.areEqual((Object)status, (Object)HttpStatusCode.Companion.getUnauthorized())) {
                retryError = new RetryDirective.RetryError(RetryErrorType.ServerSide);
            } else {
                CoroutineContext $this$logger$iv = this.callContext;
                boolean $i$f$logger = false;
                String string = Reflection.getOrCreateKotlinClass(ImdsRetryPolicy.class).getQualifiedName();
                if (string == null) {
                    boolean bl = false;
                    String string2 = "logger<T> cannot be used on an anonymous object";
                    throw new IllegalArgumentException(string2.toString());
                }
                String sourceComponent$iv = string;
                Logger logger = CoroutineContextLogExtKt.logger((CoroutineContext)$this$logger$iv, (String)sourceComponent$iv);
                Logger.debug$default((Logger)logger, null, () -> ImdsRetryPolicy.evaluateSpecificExceptions$lambda$0(status, ex), (int)1, null);
                retryError = null;
            }
        } else {
            retryError = null;
        }
        return retryError;
    }

    private static final String evaluateSpecificExceptions$lambda$0(HttpStatusCode $status, Throwable $ex) {
        return "IMDS error: statusCode=" + $status + "; " + ((EC2MetadataError)((Object)$ex)).getMessage();
    }
}

