// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.runtime.auth.credentials.internal.sts.serde

import aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.AssumeRoleRequest
import aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.PolicyDescriptorType
import aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.ProvidedContext
import aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.Tag
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerialName
import aws.smithy.kotlin.runtime.serde.formurl.FormUrlSerializer
import aws.smithy.kotlin.runtime.serde.formurl.QueryLiteral
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class AssumeRoleOperationSerializer: HttpSerializer.NonStreaming<AssumeRoleRequest> {
    override fun serialize(context: ExecutionContext, input: AssumeRoleRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/"
        }

        val payload = serializeAssumeRoleOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/x-www-form-urlencoded")
        }
        return builder
    }
}

private fun serializeAssumeRoleOperationBody(context: ExecutionContext, input: AssumeRoleRequest): ByteArray {
    val serializer = FormUrlSerializer()
    val DURATIONSECONDS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, FormUrlSerialName("DurationSeconds"))
    val EXTERNALID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("ExternalId"))
    val POLICY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("Policy"))
    val POLICYARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("PolicyArns"))
    val PROVIDEDCONTEXTS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("ProvidedContexts"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("RoleArn"))
    val ROLESESSIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("RoleSessionName"))
    val SERIALNUMBER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("SerialNumber"))
    val SOURCEIDENTITY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("SourceIdentity"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("Tags"))
    val TOKENCODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, FormUrlSerialName("TokenCode"))
    val TRANSITIVETAGKEYS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, FormUrlSerialName("TransitiveTagKeys"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        trait(FormUrlSerialName("AssumeRoleRequest"))
        trait(QueryLiteral("Action", "AssumeRole"))
        trait(QueryLiteral("Version", "2011-06-15"))
        field(DURATIONSECONDS_DESCRIPTOR)
        field(EXTERNALID_DESCRIPTOR)
        field(POLICY_DESCRIPTOR)
        field(POLICYARNS_DESCRIPTOR)
        field(PROVIDEDCONTEXTS_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(ROLESESSIONNAME_DESCRIPTOR)
        field(SERIALNUMBER_DESCRIPTOR)
        field(SOURCEIDENTITY_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(TOKENCODE_DESCRIPTOR)
        field(TRANSITIVETAGKEYS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.durationSeconds?.let { field(DURATIONSECONDS_DESCRIPTOR, it) }
        input.externalId?.let { field(EXTERNALID_DESCRIPTOR, it) }
        input.policy?.let { field(POLICY_DESCRIPTOR, it) }
        if (input.policyArns != null) {
            listField(POLICYARNS_DESCRIPTOR) {
                for (el0 in input.policyArns) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializePolicyDescriptorTypeDocument))
                }
            }
        }
        if (input.providedContexts != null) {
            listField(PROVIDEDCONTEXTS_DESCRIPTOR) {
                for (el0 in input.providedContexts) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeProvidedContextDocument))
                }
            }
        }
        input.roleArn?.let { field(ROLEARN_DESCRIPTOR, it) }
        input.roleSessionName?.let { field(ROLESESSIONNAME_DESCRIPTOR, it) }
        input.serialNumber?.let { field(SERIALNUMBER_DESCRIPTOR, it) }
        input.sourceIdentity?.let { field(SOURCEIDENTITY_DESCRIPTOR, it) }
        if (input.tags != null) {
            listField(TAGS_DESCRIPTOR) {
                for (el0 in input.tags) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeTagDocument))
                }
            }
        }
        input.tokenCode?.let { field(TOKENCODE_DESCRIPTOR, it) }
        if (input.transitiveTagKeys != null) {
            listField(TRANSITIVETAGKEYS_DESCRIPTOR) {
                for (el0 in input.transitiveTagKeys) {
                    serializeString(el0)
                }
            }
        }
    }
    return serializer.toByteArray()
}
