/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.runtime.config.imds;

import aws.sdk.kotlin.runtime.config.imds.EC2MetadataError;
import aws.smithy.kotlin.runtime.http.HttpStatusCode;
import aws.smithy.kotlin.runtime.http.HttpStatusCodeKt;
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective;
import aws.smithy.kotlin.runtime.retries.policy.RetryErrorType;
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy;
import aws.smithy.kotlin.runtime.telemetry.logging.CoroutineContextLogExtKt;
import aws.smithy.kotlin.runtime.telemetry.logging.Logger;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\b\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001d\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Laws/sdk/kotlin/runtime/config/imds/ImdsRetryPolicy;", "Laws/smithy/kotlin/runtime/retries/policy/RetryPolicy;", "", "callContext", "Lkotlin/coroutines/CoroutineContext;", "<init>", "(Lkotlin/coroutines/CoroutineContext;)V", "evaluate", "Laws/smithy/kotlin/runtime/retries/policy/RetryDirective;", "result", "Lkotlin/Result;", "(Ljava/lang/Object;)Laws/smithy/kotlin/runtime/retries/policy/RetryDirective;", "throwable", "", "aws-config"})
@SourceDebugExtension(value={"SMAP\nImdsRetryPolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImdsRetryPolicy.kt\naws/sdk/kotlin/runtime/config/imds/ImdsRetryPolicy\n+ 2 CoroutineContextLogExt.kt\naws/smithy/kotlin/runtime/telemetry/logging/CoroutineContextLogExtKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,41:1\n258#2:42\n259#2:44\n1#3:43\n*S KotlinDebug\n*F\n+ 1 ImdsRetryPolicy.kt\naws/sdk/kotlin/runtime/config/imds/ImdsRetryPolicy\n*L\n32#1:42\n32#1:44\n32#1:43\n*E\n"})
public final class ImdsRetryPolicy
implements RetryPolicy<Object> {
    @NotNull
    private final CoroutineContext callContext;

    public ImdsRetryPolicy(@NotNull CoroutineContext callContext) {
        Intrinsics.checkNotNullParameter((Object)callContext, (String)"callContext");
        this.callContext = callContext;
    }

    @NotNull
    public RetryDirective evaluate(@NotNull Object result) {
        RetryDirective retryDirective;
        if (Result.isSuccess-impl((Object)result)) {
            retryDirective = (RetryDirective)RetryDirective.TerminateAndSucceed.INSTANCE;
        } else {
            Throwable throwable = Result.exceptionOrNull-impl((Object)result);
            Intrinsics.checkNotNull((Object)throwable);
            retryDirective = this.evaluate(throwable);
        }
        return retryDirective;
    }

    private final RetryDirective evaluate(Throwable throwable) {
        RetryDirective retryDirective;
        if (throwable instanceof EC2MetadataError) {
            HttpStatusCode status = HttpStatusCode.Companion.fromValue(((EC2MetadataError)((Object)throwable)).getStatusCode());
            if (HttpStatusCodeKt.category((HttpStatusCode)status) == HttpStatusCode.Category.SERVER_ERROR) {
                retryDirective = (RetryDirective)new RetryDirective.RetryError(RetryErrorType.ServerSide);
            } else if (Intrinsics.areEqual((Object)status, (Object)HttpStatusCode.Companion.getUnauthorized())) {
                retryDirective = (RetryDirective)new RetryDirective.RetryError(RetryErrorType.ServerSide);
            } else {
                CoroutineContext $this$logger$iv = this.callContext;
                boolean $i$f$logger = false;
                String string = Reflection.getOrCreateKotlinClass(ImdsRetryPolicy.class).getQualifiedName();
                if (string == null) {
                    boolean bl = false;
                    String string2 = "logger<T> cannot be used on an anonymous object";
                    throw new IllegalArgumentException(string2.toString());
                }
                String sourceComponent$iv = string;
                Logger logger = CoroutineContextLogExtKt.logger((CoroutineContext)$this$logger$iv, (String)sourceComponent$iv);
                Logger.DefaultImpls.debug$default((Logger)logger, null, () -> ImdsRetryPolicy.evaluate$lambda$0(throwable), (int)1, null);
                retryDirective = (RetryDirective)RetryDirective.TerminateAndFail.INSTANCE;
            }
        } else {
            retryDirective = (RetryDirective)RetryDirective.TerminateAndFail.INSTANCE;
        }
        return retryDirective;
    }

    private static final String evaluate$lambda$0(Throwable $throwable) {
        return "Non retryable IMDS error: statusCode=" + ((EC2MetadataError)((Object)$throwable)).getStatusCode() + "; " + ((EC2MetadataError)((Object)$throwable)).getMessage();
    }
}

