/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.runtime.auth.credentials.profile;

import aws.sdk.kotlin.runtime.auth.credentials.ProviderConfigurationException;
import aws.sdk.kotlin.runtime.auth.credentials.internal.CredentialsExtKt;
import aws.sdk.kotlin.runtime.auth.credentials.profile.LeafProvider;
import aws.sdk.kotlin.runtime.auth.credentials.profile.LeafProviderResult;
import aws.sdk.kotlin.runtime.auth.credentials.profile.NextProfile;
import aws.sdk.kotlin.runtime.auth.credentials.profile.RoleArn;
import aws.sdk.kotlin.runtime.auth.credentials.profile.RoleArnSource;
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig;
import aws.sdk.kotlin.runtime.config.profile.ConfigSection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a7\u0010\u0000\u001a\u00060\u0001j\u0002`\u0002*\u0012\u0012\u0004\u0012\u00020\u0004\u0012\b\u0012\u00060\u0001j\u0002`\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007H\u0082\b\u001a\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u00060\u0001j\u0002`\u0002H\u0002\u001a\f\u0010\u001a\u001a\u00020\u001b*\u00020\u001cH\u0002\u001a\u001d\u0010\u001d\u001a\u00020\u001c*\u0004\u0018\u00010\u001c2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0007H\u0082\b\u001a!\u0010\u001f\u001a\u0004\u0018\u00010\u001c*\u0004\u0018\u00010\u001c2\u000e\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u0007H\u0082\b\u001a\u0012\u0010 \u001a\u0004\u0018\u00010\u001c*\u00060\u0001j\u0002`\u0002H\u0002\u001a\u0012\u0010!\u001a\u0004\u0018\u00010\u001c*\u00060\u0001j\u0002`\u0002H\u0002\u001a\u001a\u0010\"\u001a\u0004\u0018\u00010\u001c*\u00060\u0001j\u0002`\u00022\u0006\u0010#\u001a\u00020$H\u0002\u001a\u0010\u0010%\u001a\u00020\u001c*\u00060\u0001j\u0002`\u0002H\u0002\u001a\u0010\u0010&\u001a\u00020\u001c*\u00060\u0001j\u0002`\u0002H\u0002\u001a\u0012\u0010'\u001a\u0004\u0018\u00010\u001b*\u00060\u0001j\u0002`\u0002H\u0002\u001a\u0010\u0010(\u001a\u00020)*\u00060\u0001j\u0002`\u0002H\u0002\u001a\u0018\u0010*\u001a\u00020\u001b*\u00060\u0001j\u0002`\u00022\u0006\u0010#\u001a\u00020$H\u0002\"\u000e\u0010\b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\r\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000e\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000f\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0010\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0011\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0012\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0013\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0014\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0015\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0016\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0017\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"getOrThrow", "Laws/sdk/kotlin/runtime/config/profile/ConfigSection;", "Laws/sdk/kotlin/runtime/config/profile/AwsProfile;", "", "", "name", "lazyMessage", "Lkotlin/Function0;", "ROLE_ARN", "EXTERNAL_ID", "ROLE_SESSION_NAME", "CREDENTIAL_SOURCE", "SOURCE_PROFILE", "WEB_IDENTITY_TOKEN_FILE", "AWS_ACCESS_KEY_ID", "AWS_SECRET_ACCESS_KEY", "AWS_SESSION_TOKEN", "AWS_ACCOUNT_ID", "SSO_START_URL", "SSO_REGION", "SSO_ACCOUNT_ID", "SSO_ROLE_NAME", "SSO_SESSION", "CREDENTIAL_PROCESS", "roleArnOrNull", "Laws/sdk/kotlin/runtime/auth/credentials/profile/RoleArn;", "unwrap", "Laws/sdk/kotlin/runtime/auth/credentials/profile/LeafProvider;", "Laws/sdk/kotlin/runtime/auth/credentials/profile/LeafProviderResult;", "unwrapOrElse", "fn", "orElse", "webIdentityTokenCreds", "legacySsoCreds", "ssoSessionCreds", "config", "Laws/sdk/kotlin/runtime/config/profile/AwsSharedConfig;", "processCreds", "staticCreds", "staticCredsOrNull", "chainProvider", "Laws/sdk/kotlin/runtime/auth/credentials/profile/NextProfile;", "leafProvider", "aws-config"})
@SourceDebugExtension(value={"SMAP\nProfileChain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileChain.kt\naws/sdk/kotlin/runtime/auth/credentials/profile/ProfileChainKt\n*L\n1#1,354:1\n210#1,4:355\n210#1,4:359\n202#1,4:363\n*S KotlinDebug\n*F\n+ 1 ProfileChain.kt\naws/sdk/kotlin/runtime/auth/credentials/profile/ProfileChainKt\n*L\n349#1:355,4\n350#1:359,4\n351#1:363,4\n*E\n"})
public final class ProfileChainKt {
    @NotNull
    public static final String ROLE_ARN = "role_arn";
    @NotNull
    public static final String EXTERNAL_ID = "external_id";
    @NotNull
    public static final String ROLE_SESSION_NAME = "role_session_name";
    @NotNull
    public static final String CREDENTIAL_SOURCE = "credential_source";
    @NotNull
    public static final String SOURCE_PROFILE = "source_profile";
    @NotNull
    public static final String WEB_IDENTITY_TOKEN_FILE = "web_identity_token_file";
    @NotNull
    public static final String AWS_ACCESS_KEY_ID = "aws_access_key_id";
    @NotNull
    public static final String AWS_SECRET_ACCESS_KEY = "aws_secret_access_key";
    @NotNull
    public static final String AWS_SESSION_TOKEN = "aws_session_token";
    @NotNull
    public static final String AWS_ACCOUNT_ID = "aws_account_id";
    @NotNull
    public static final String SSO_START_URL = "sso_start_url";
    @NotNull
    public static final String SSO_REGION = "sso_region";
    @NotNull
    public static final String SSO_ACCOUNT_ID = "sso_account_id";
    @NotNull
    public static final String SSO_ROLE_NAME = "sso_role_name";
    @NotNull
    public static final String SSO_SESSION = "sso_session";
    @NotNull
    public static final String CREDENTIAL_PROCESS = "credential_process";

    private static final ConfigSection getOrThrow(Map<String, ConfigSection> $this$getOrThrow, String name, Function0<String> lazyMessage) {
        boolean $i$f$getOrThrow = false;
        ConfigSection configSection = $this$getOrThrow.get(name);
        if (configSection == null) {
            throw new ProviderConfigurationException((String)lazyMessage.invoke(), null, 2, null);
        }
        return configSection;
    }

    private static final RoleArn roleArnOrNull(ConfigSection $this$roleArnOrNull) {
        boolean validSource;
        boolean bl = validSource = $this$roleArnOrNull.contains(CREDENTIAL_SOURCE) || $this$roleArnOrNull.contains(SOURCE_PROFILE);
        if (!validSource && $this$roleArnOrNull.contains(WEB_IDENTITY_TOKEN_FILE)) {
            return null;
        }
        String string = ConfigSection.getOrNull$default($this$roleArnOrNull, ROLE_ARN, null, 2, null);
        if (string == null) {
            return null;
        }
        String roleArn = string;
        RoleArnSource roleArnSource = $this$roleArnOrNull.contains(SOURCE_PROFILE) && !$this$roleArnOrNull.contains(CREDENTIAL_SOURCE) ? RoleArnSource.SOURCE_PROFILE : ($this$roleArnOrNull.contains(CREDENTIAL_SOURCE) && !$this$roleArnOrNull.contains(SOURCE_PROFILE) ? RoleArnSource.CREDENTIALS_SOURCE : null);
        return new RoleArn(roleArn, roleArnSource, ConfigSection.getOrNull$default($this$roleArnOrNull, ROLE_SESSION_NAME, null, 2, null), ConfigSection.getOrNull$default($this$roleArnOrNull, EXTERNAL_ID, null, 2, null));
    }

    private static final LeafProvider unwrap(LeafProviderResult $this$unwrap) {
        LeafProviderResult leafProviderResult = $this$unwrap;
        if (!(leafProviderResult instanceof LeafProviderResult.Ok)) {
            if (leafProviderResult instanceof LeafProviderResult.Err) {
                throw new ProviderConfigurationException(((LeafProviderResult.Err)$this$unwrap).getErrorMessage(), null, 2, null);
            }
            throw new NoWhenBranchMatchedException();
        }
        return ((LeafProviderResult.Ok)$this$unwrap).getProvider();
    }

    private static final LeafProviderResult unwrapOrElse(LeafProviderResult $this$unwrapOrElse, Function0<? extends LeafProviderResult> fn) {
        boolean $i$f$unwrapOrElse = false;
        return $this$unwrapOrElse == null ? (LeafProviderResult)fn.invoke() : $this$unwrapOrElse;
    }

    private static final LeafProviderResult orElse(LeafProviderResult $this$orElse, Function0<? extends LeafProviderResult> fn) {
        boolean $i$f$orElse = false;
        return $this$orElse == null ? (LeafProviderResult)fn.invoke() : $this$orElse;
    }

    private static final LeafProviderResult webIdentityTokenCreds(ConfigSection $this$webIdentityTokenCreds) {
        String roleArn = ConfigSection.getOrNull$default($this$webIdentityTokenCreds, ROLE_ARN, null, 2, null);
        String tokenFile = ConfigSection.getOrNull$default($this$webIdentityTokenCreds, WEB_IDENTITY_TOKEN_FILE, null, 2, null);
        String sessionName = ConfigSection.getOrNull$default($this$webIdentityTokenCreds, ROLE_SESSION_NAME, null, 2, null);
        return tokenFile == null ? null : (roleArn == null ? (LeafProviderResult)new LeafProviderResult.Err("profile (" + $this$webIdentityTokenCreds.getName() + ") missing `role_arn`") : (LeafProviderResult)new LeafProviderResult.Ok(new LeafProvider.WebIdentityTokenRole(roleArn, tokenFile, sessionName)));
    }

    private static final LeafProviderResult legacySsoCreds(ConfigSection $this$legacySsoCreds) {
        if (!$this$legacySsoCreds.contains(SSO_ACCOUNT_ID) && !$this$legacySsoCreds.contains(SSO_ROLE_NAME)) {
            return null;
        }
        String string = ConfigSection.getOrNull$default($this$legacySsoCreds, SSO_START_URL, null, 2, null);
        if (string == null) {
            return new LeafProviderResult.Err("profile (" + $this$legacySsoCreds.getName() + ") missing `sso_start_url`");
        }
        String startUrl = string;
        String string2 = ConfigSection.getOrNull$default($this$legacySsoCreds, SSO_REGION, null, 2, null);
        if (string2 == null) {
            return new LeafProviderResult.Err("profile (" + $this$legacySsoCreds.getName() + ") missing `sso_region`");
        }
        String ssoRegion = string2;
        String string3 = ConfigSection.getOrNull$default($this$legacySsoCreds, SSO_ACCOUNT_ID, null, 2, null);
        if (string3 == null) {
            return new LeafProviderResult.Err("profile (" + $this$legacySsoCreds.getName() + ") missing `sso_account_id`");
        }
        String accountId = string3;
        String string4 = ConfigSection.getOrNull$default($this$legacySsoCreds, SSO_ROLE_NAME, null, 2, null);
        if (string4 == null) {
            return new LeafProviderResult.Err("profile (" + $this$legacySsoCreds.getName() + ") missing `sso_role_name`");
        }
        String roleName = string4;
        return new LeafProviderResult.Ok(new LeafProvider.LegacySso(startUrl, ssoRegion, accountId, roleName));
    }

    private static final LeafProviderResult ssoSessionCreds(ConfigSection $this$ssoSessionCreds, AwsSharedConfig config) {
        String string = ConfigSection.getOrNull$default($this$ssoSessionCreds, SSO_SESSION, null, 2, null);
        if (string == null) {
            return null;
        }
        String sessionName = string;
        ConfigSection configSection = config.getSsoSessions().get(sessionName);
        if (configSection == null) {
            return new LeafProviderResult.Err("profile (" + $this$ssoSessionCreds.getName() + ") references non-existing sso_session = `" + sessionName + '`');
        }
        ConfigSection session = configSection;
        String string2 = ConfigSection.getOrNull$default(session, SSO_START_URL, null, 2, null);
        if (string2 == null) {
            return new LeafProviderResult.Err("sso-session (" + sessionName + ") missing `sso_start_url`");
        }
        String startUrl = string2;
        String string3 = ConfigSection.getOrNull$default(session, SSO_REGION, null, 2, null);
        if (string3 == null) {
            return new LeafProviderResult.Err("sso-session (" + sessionName + ") missing `sso_region`");
        }
        String ssoRegion = string3;
        String string4 = ConfigSection.getOrNull$default($this$ssoSessionCreds, SSO_ACCOUNT_ID, null, 2, null);
        if (string4 == null) {
            return new LeafProviderResult.Err("profile (" + $this$ssoSessionCreds.getName() + ") missing `sso_account_id`");
        }
        String accountId = string4;
        String string5 = ConfigSection.getOrNull$default($this$ssoSessionCreds, SSO_ROLE_NAME, null, 2, null);
        if (string5 == null) {
            return new LeafProviderResult.Err("profile (" + $this$ssoSessionCreds.getName() + ") missing `sso_role_name`");
        }
        String roleName = string5;
        String sessionSsoRegion = ConfigSection.getOrNull$default(session, SSO_REGION, null, 2, null);
        String profileSsoRegion = ConfigSection.getOrNull$default($this$ssoSessionCreds, SSO_REGION, null, 2, null);
        if (sessionSsoRegion != null && profileSsoRegion != null && !Intrinsics.areEqual((Object)sessionSsoRegion, (Object)profileSsoRegion)) {
            return new LeafProviderResult.Err("sso-session (" + sessionName + ") sso_region = `" + sessionSsoRegion + "` does not match profile (" + $this$ssoSessionCreds.getName() + ") sso_region = `" + profileSsoRegion + '`');
        }
        String sessionStartUrl = ConfigSection.getOrNull$default(session, SSO_START_URL, null, 2, null);
        String profileStartUrl = ConfigSection.getOrNull$default($this$ssoSessionCreds, SSO_START_URL, null, 2, null);
        if (sessionStartUrl != null && profileStartUrl != null && !Intrinsics.areEqual((Object)sessionStartUrl, (Object)profileStartUrl)) {
            return new LeafProviderResult.Err("sso-session (" + sessionName + ") sso_start_url = `" + sessionStartUrl + "` does not match profile (" + $this$ssoSessionCreds.getName() + ") sso_start_url = `" + profileStartUrl + '`');
        }
        return new LeafProviderResult.Ok(new LeafProvider.SsoSession(sessionName, startUrl, ssoRegion, accountId, roleName));
    }

    private static final LeafProviderResult processCreds(ConfigSection $this$processCreds) {
        if (!$this$processCreds.contains(CREDENTIAL_PROCESS)) {
            return new LeafProviderResult.Err("profile (" + $this$processCreds.getName() + ") did not contain credential information");
        }
        String string = ConfigSection.getOrNull$default($this$processCreds, CREDENTIAL_PROCESS, null, 2, null);
        if (string == null) {
            return new LeafProviderResult.Err("profile (" + $this$processCreds.getName() + ") missing `credential_process`");
        }
        String credentialProcess = string;
        return new LeafProviderResult.Ok(new LeafProvider.Process(credentialProcess));
    }

    private static final LeafProviderResult staticCreds(ConfigSection $this$staticCreds) {
        LeafProviderResult leafProviderResult;
        String accessKeyId = ConfigSection.getOrNull$default($this$staticCreds, AWS_ACCESS_KEY_ID, null, 2, null);
        String secretKey = ConfigSection.getOrNull$default($this$staticCreds, AWS_SECRET_ACCESS_KEY, null, 2, null);
        String accountId = ConfigSection.getOrNull$default($this$staticCreds, AWS_ACCOUNT_ID, null, 2, null);
        if (accessKeyId == null && secretKey == null) {
            leafProviderResult = new LeafProviderResult.Err("profile (" + $this$staticCreds.getName() + ") missing `aws_access_key_id` & `aws_secret_access_key`");
        } else if (accessKeyId == null) {
            leafProviderResult = new LeafProviderResult.Err("profile (" + $this$staticCreds.getName() + ") missing `aws_access_key_id`");
        } else if (secretKey == null) {
            leafProviderResult = new LeafProviderResult.Err("profile (" + $this$staticCreds.getName() + ") missing `aws_secret_access_key`");
        } else {
            String sessionToken = ConfigSection.getOrNull$default($this$staticCreds, AWS_SESSION_TOKEN, null, 2, null);
            LeafProvider.AccessKey provider = new LeafProvider.AccessKey(CredentialsExtKt.credentials$default(accessKeyId, secretKey, sessionToken, null, null, accountId, 24, null));
            leafProviderResult = new LeafProviderResult.Ok(provider);
        }
        return leafProviderResult;
    }

    private static final LeafProvider staticCredsOrNull(ConfigSection $this$staticCredsOrNull) {
        LeafProviderResult result = ProfileChainKt.staticCreds($this$staticCredsOrNull);
        return result instanceof LeafProviderResult.Ok ? ((LeafProviderResult.Ok)result).getProvider() : null;
    }

    private static final NextProfile chainProvider(ConfigSection $this$chainProvider) {
        String sourceProfile = ConfigSection.getOrNull$default($this$chainProvider, SOURCE_PROFILE, null, 2, null);
        String credSource = ConfigSection.getOrNull$default($this$chainProvider, CREDENTIAL_SOURCE, null, 2, null);
        if (sourceProfile != null && credSource != null) {
            throw new ProviderConfigurationException("profile (" + $this$chainProvider.getName() + ") contained both `source_profile` and `credential_source`. Only one or the other can be defined.", null, 2, null);
        }
        if (sourceProfile == null && credSource == null) {
            throw new ProviderConfigurationException("profile (" + $this$chainProvider.getName() + ") must contain `source_profile` or `credential_source` but neither were defined", null, 2, null);
        }
        return sourceProfile != null && credSource == null ? (Intrinsics.areEqual((Object)sourceProfile, (Object)$this$chainProvider.getName()) ? (NextProfile)NextProfile.SelfReference.INSTANCE : (NextProfile)new NextProfile.Named(sourceProfile)) : (NextProfile)NextProfile.SelfReference.INSTANCE;
    }

    private static final LeafProvider leafProvider(ConfigSection $this$leafProvider, AwsSharedConfig config) {
        LeafProviderResult leafProviderResult;
        LeafProviderResult leafProviderResult2;
        LeafProviderResult leafProviderResult3;
        String credSource = ConfigSection.getOrNull$default($this$leafProvider, CREDENTIAL_SOURCE, null, 2, null);
        if (credSource != null) {
            return new LeafProvider.NamedSource(credSource);
        }
        LeafProviderResult $this$orElse$iv = ProfileChainKt.webIdentityTokenCreds($this$leafProvider);
        boolean $i$f$orElse = false;
        if ($this$orElse$iv == null) {
            boolean bl = false;
            leafProviderResult3 = ProfileChainKt.ssoSessionCreds($this$leafProvider, config);
        } else {
            leafProviderResult3 = $this$orElse$iv;
        }
        $this$orElse$iv = leafProviderResult3;
        $i$f$orElse = false;
        if ($this$orElse$iv == null) {
            boolean bl = false;
            leafProviderResult2 = ProfileChainKt.legacySsoCreds($this$leafProvider);
        } else {
            leafProviderResult2 = $this$orElse$iv;
        }
        LeafProviderResult $this$unwrapOrElse$iv = leafProviderResult2;
        boolean $i$f$unwrapOrElse = false;
        if ($this$unwrapOrElse$iv == null) {
            boolean bl = false;
            leafProviderResult = ProfileChainKt.processCreds($this$leafProvider);
        } else {
            leafProviderResult = $this$unwrapOrElse$iv;
        }
        return ProfileChainKt.unwrap(leafProviderResult);
    }

    public static final /* synthetic */ LeafProvider access$staticCredsOrNull(ConfigSection $receiver) {
        return ProfileChainKt.staticCredsOrNull($receiver);
    }

    public static final /* synthetic */ RoleArn access$roleArnOrNull(ConfigSection $receiver) {
        return ProfileChainKt.roleArnOrNull($receiver);
    }

    public static final /* synthetic */ LeafProvider access$leafProvider(ConfigSection $receiver, AwsSharedConfig config) {
        return ProfileChainKt.leafProvider($receiver, config);
    }

    public static final /* synthetic */ NextProfile access$chainProvider(ConfigSection $receiver) {
        return ProfileChainKt.chainProvider($receiver);
    }
}

