/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.runtime.auth.credentials;

import aws.sdk.kotlin.runtime.auth.credentials.EcsCredentialsProvider;
import aws.sdk.kotlin.runtime.auth.credentials.EnvironmentCredentialsProvider;
import aws.sdk.kotlin.runtime.auth.credentials.ImdsCredentialsProvider;
import aws.sdk.kotlin.runtime.auth.credentials.ProfileCredentialsProvider;
import aws.sdk.kotlin.runtime.auth.credentials.StsWebIdentityProvider;
import aws.sdk.kotlin.runtime.auth.credentials.SystemPropertyCredentialsProvider;
import aws.sdk.kotlin.runtime.config.imds.ImdsClient;
import aws.smithy.kotlin.runtime.auth.awscredentials.CachedCredentialsProvider;
import aws.smithy.kotlin.runtime.auth.awscredentials.CloseableCredentialsProvider;
import aws.smithy.kotlin.runtime.auth.awscredentials.Credentials;
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider;
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderChain;
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderKt;
import aws.smithy.kotlin.runtime.collections.Attributes;
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngineKt;
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine;
import aws.smithy.kotlin.runtime.io.CloseableKt;
import aws.smithy.kotlin.runtime.util.PlatformEnvironProvider;
import aws.smithy.kotlin.runtime.util.PlatformProvider;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B5\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0096@\u00a2\u0006\u0002\u0010\u001bJ\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u0003H\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Laws/sdk/kotlin/runtime/auth/credentials/DefaultChainCredentialsProvider;", "Laws/smithy/kotlin/runtime/auth/awscredentials/CloseableCredentialsProvider;", "profileName", "", "platformProvider", "Laws/smithy/kotlin/runtime/util/PlatformProvider;", "httpClient", "Laws/smithy/kotlin/runtime/http/engine/HttpClientEngine;", "region", "<init>", "(Ljava/lang/String;Laws/smithy/kotlin/runtime/util/PlatformProvider;Laws/smithy/kotlin/runtime/http/engine/HttpClientEngine;Ljava/lang/String;)V", "getProfileName", "()Ljava/lang/String;", "getPlatformProvider", "()Laws/smithy/kotlin/runtime/util/PlatformProvider;", "getRegion", "manageEngine", "", "engine", "chain", "Laws/smithy/kotlin/runtime/auth/awscredentials/CredentialsProviderChain;", "provider", "Laws/smithy/kotlin/runtime/auth/awscredentials/CachedCredentialsProvider;", "resolve", "Laws/smithy/kotlin/runtime/auth/awscredentials/Credentials;", "attributes", "Laws/smithy/kotlin/runtime/collections/Attributes;", "(Laws/smithy/kotlin/runtime/collections/Attributes;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "close", "", "toString", "aws-config"})
public final class DefaultChainCredentialsProvider
implements CloseableCredentialsProvider {
    @Nullable
    private final String profileName;
    @NotNull
    private final PlatformProvider platformProvider;
    @Nullable
    private final String region;
    private final boolean manageEngine;
    @NotNull
    private final HttpClientEngine engine;
    @NotNull
    private final CredentialsProviderChain chain;
    @NotNull
    private final CachedCredentialsProvider provider;

    public DefaultChainCredentialsProvider(@Nullable String profileName, @NotNull PlatformProvider platformProvider, @Nullable HttpClientEngine httpClient, @Nullable String region2) {
        Intrinsics.checkNotNullParameter((Object)platformProvider, (String)"platformProvider");
        this.profileName = profileName;
        this.platformProvider = platformProvider;
        this.region = region2;
        this.manageEngine = httpClient == null;
        HttpClientEngine httpClientEngine = httpClient;
        if (httpClientEngine == null) {
            httpClientEngine = (HttpClientEngine)DefaultHttpEngineKt.DefaultHttpEngine$default(null, (int)1, null);
        }
        this.engine = httpClientEngine;
        CredentialsProvider[] credentialsProviderArray = new CredentialsProvider[6];
        credentialsProviderArray[0] = new SystemPropertyCredentialsProvider((Function1<? super String, String>)((Function1)new Function1<String, String>((Object)this.platformProvider){

            public final String invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((PlatformProvider)this.receiver).getProperty(p0);
            }
        }));
        credentialsProviderArray[1] = new EnvironmentCredentialsProvider((Function1<? super String, String>)((Function1)new Function1<String, String>((Object)this.platformProvider){

            public final String invoke(String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ((PlatformProvider)this.receiver).getenv(p0);
            }
        }));
        credentialsProviderArray[2] = new StsWebIdentityProvider(this.platformProvider, this.engine, this.region);
        String string = this.profileName;
        PlatformProvider platformProvider2 = this.platformProvider;
        HttpClientEngine httpClientEngine2 = this.engine;
        String string2 = this.region;
        credentialsProviderArray[3] = new ProfileCredentialsProvider(string, string2, platformProvider2, httpClientEngine2);
        credentialsProviderArray[4] = new EcsCredentialsProvider(this.platformProvider, this.engine);
        credentialsProviderArray[5] = new ImdsCredentialsProvider(null, LazyKt.lazy(() -> DefaultChainCredentialsProvider.chain$lambda$1(this)), (PlatformEnvironProvider)this.platformProvider, null, 9, null);
        this.chain = new CredentialsProviderChain(credentialsProviderArray);
        this.provider = new CachedCredentialsProvider((CredentialsProvider)this.chain, 0L, 0L, null, 14, null);
    }

    public /* synthetic */ DefaultChainCredentialsProvider(String string, PlatformProvider platformProvider, HttpClientEngine httpClientEngine, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            platformProvider = PlatformProvider.Companion.getSystem();
        }
        if ((n & 4) != 0) {
            httpClientEngine = null;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        this(string, platformProvider, httpClientEngine, string2);
    }

    @Nullable
    public final String getProfileName() {
        return this.profileName;
    }

    @NotNull
    public final PlatformProvider getPlatformProvider() {
        return this.platformProvider;
    }

    @Nullable
    public final String getRegion() {
        return this.region;
    }

    @Nullable
    public Object resolve(@NotNull Attributes attributes, @NotNull Continuation<? super Credentials> $completion) {
        return this.provider.resolve(attributes, $completion);
    }

    public void close() {
        this.provider.close();
        if (this.manageEngine) {
            CloseableKt.closeIfCloseable((Object)this.engine);
        }
    }

    @NotNull
    public String toString() {
        return CredentialsProviderKt.getSimpleClassName((CredentialsProvider)((CredentialsProvider)this)) + ": " + this.chain;
    }

    private static final Unit chain$lambda$1$lambda$0(DefaultChainCredentialsProvider this$0, ImdsClient.Builder $this$ImdsClient) {
        Intrinsics.checkNotNullParameter((Object)$this$ImdsClient, (String)"$this$ImdsClient");
        $this$ImdsClient.setPlatformProvider$aws_config(this$0.platformProvider);
        $this$ImdsClient.setEngine$aws_config(this$0.engine);
        return Unit.INSTANCE;
    }

    private static final ImdsClient chain$lambda$1(DefaultChainCredentialsProvider this$0) {
        return ImdsClient.Companion.invoke((Function1<? super ImdsClient.Builder, Unit>)((Function1)arg_0 -> DefaultChainCredentialsProvider.chain$lambda$1$lambda$0(this$0, arg_0)));
    }

    public DefaultChainCredentialsProvider() {
        this(null, null, null, null, 15, null);
    }
}

