// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.runtime.auth.credentials.internal.sts.serde

import aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.AssumeRoleWithWebIdentityResponse
import aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.AssumedRoleUser
import aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.Credentials
import aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.StsException
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.awsprotocol.xml.parseRestXmlErrorResponseNoSuspend
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.getOrDeserializeErr
import aws.smithy.kotlin.runtime.serde.parseInt
import aws.smithy.kotlin.runtime.serde.xml.tryData
import aws.smithy.kotlin.runtime.serde.xml.xmlTagReader


internal class AssumeRoleWithWebIdentityOperationDeserializer: HttpDeserializer.NonStreaming<AssumeRoleWithWebIdentityResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): AssumeRoleWithWebIdentityResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwAssumeRoleWithWebIdentityError(context, call, payload)
        }
        val builder = AssumeRoleWithWebIdentityResponse.Builder()

        if (payload != null) {
            deserializeAssumeRoleWithWebIdentityOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwAssumeRoleWithWebIdentityError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        checkNotNull(payload){ "unable to parse error from empty response" }
        parseRestXmlErrorResponseNoSuspend(payload)
    } catch (ex: Exception) {
        throw StsException("Failed to parse response as 'awsQuery' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "IDPRejectedClaim" -> IdpRejectedClaimExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "MalformedPolicyDocument" -> MalformedPolicyDocumentExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ExpiredTokenException" -> ExpiredTokenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidIdentityToken" -> InvalidIdentityTokenExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "RegionDisabledException" -> RegionDisabledExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "PackedPolicyTooLarge" -> PackedPolicyTooLargeExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "IDPCommunicationError" -> IdpCommunicationErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> StsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeAssumeRoleWithWebIdentityOperationBody(builder: AssumeRoleWithWebIdentityResponse.Builder, payload: ByteArray) {
    val root = xmlTagReader(payload)
    val unwrapped = unwrapAwsQueryResponse(root, "AssumeRoleWithWebIdentity")

    loop@while (true) {
        val curr = unwrapped.nextTag() ?: break@loop
        when (curr.tagName) {
            // AssumedRoleUser com.amazonaws.sts#AssumeRoleWithWebIdentityResponse$AssumedRoleUser
            "AssumedRoleUser" -> builder.assumedRoleUser = deserializeAssumedRoleUserDocument(curr)
            // Audience com.amazonaws.sts#AssumeRoleWithWebIdentityResponse$Audience
            "Audience" -> builder.audience = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.sts#Audience`)" }
            // Credentials com.amazonaws.sts#AssumeRoleWithWebIdentityResponse$Credentials
            "Credentials" -> builder.credentials = deserializeCredentialsDocument(curr)
            // PackedPolicySize com.amazonaws.sts#AssumeRoleWithWebIdentityResponse$PackedPolicySize
            "PackedPolicySize" -> builder.packedPolicySize = curr.tryData()
                .parseInt()
                .getOrDeserializeErr { "expected (integer: `com.amazonaws.sts#nonNegativeIntegerType`)" }
            // Provider com.amazonaws.sts#AssumeRoleWithWebIdentityResponse$Provider
            "Provider" -> builder.provider = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.sts#Issuer`)" }
            // SourceIdentity com.amazonaws.sts#AssumeRoleWithWebIdentityResponse$SourceIdentity
            "SourceIdentity" -> builder.sourceIdentity = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.sts#sourceIdentityType`)" }
            // SubjectFromWebIdentityToken com.amazonaws.sts#AssumeRoleWithWebIdentityResponse$SubjectFromWebIdentityToken
            "SubjectFromWebIdentityToken" -> builder.subjectFromWebIdentityToken = curr.tryData()
                .getOrDeserializeErr { "expected (string: `com.amazonaws.sts#webIdentitySubjectType`)" }
            else -> {}
        }
        curr.drop()
    }
}
