// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model



/**
 * Contains the response to a successful AssumeRole request, including temporary Amazon Web Services credentials that can be used to make Amazon Web Services requests.
 */
internal class AssumeRoleResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) and the assumed role ID, which are identifiers that you can use to refer to the resulting temporary security credentials. For example, you can reference these credentials as a principal in a resource-based policy by using the ARN or assumed role ID. The ARN and ID include the `RoleSessionName` that you specified when you called `AssumeRole`.
     */
    public val assumedRoleUser: aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.AssumedRoleUser? = builder.assumedRoleUser
    /**
     * The temporary security credentials, which include an access key ID, a secret access key, and a security (or session) token.
     *
     * The size of the security token that STS API operations return is not fixed. We strongly recommend that you make no assumptions about the maximum size.
     */
    public val credentials: aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.Credentials? = builder.credentials
    /**
     * A percentage value that indicates the packed size of the session policies and session tags combined passed in the request. The request fails if the packed size is greater than 100 percent, which means the policies and tags exceeded the allowed space.
     */
    public val packedPolicySize: kotlin.Int? = builder.packedPolicySize
    /**
     * The source identity specified by the principal that is calling the `AssumeRole` operation.
     *
     * You can require users to specify a source identity when they assume a role. You do this by using the `sts:SourceIdentity` condition key in a role trust policy. You can use source identity information in CloudTrail logs to determine who took actions with a role. You can use the `aws:SourceIdentity` condition key to further control access to Amazon Web Services resources based on the value of source identity. For more information about using source identity, see [Monitor and control actions taken with assumed roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html) in the *IAM User Guide*.
     *
     * The regex used to validate this parameter is a string of characters consisting of upper- and lower-case alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@-
     */
    public val sourceIdentity: kotlin.String? = builder.sourceIdentity

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.AssumeRoleResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssumeRoleResponse(")
        append("assumedRoleUser=$assumedRoleUser,")
        append("credentials=$credentials,")
        append("packedPolicySize=$packedPolicySize,")
        append("sourceIdentity=$sourceIdentity")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assumedRoleUser?.hashCode() ?: 0
        result = 31 * result + (credentials?.hashCode() ?: 0)
        result = 31 * result + (packedPolicySize ?: 0)
        result = 31 * result + (sourceIdentity?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssumeRoleResponse

        if (assumedRoleUser != other.assumedRoleUser) return false
        if (credentials != other.credentials) return false
        if (packedPolicySize != other.packedPolicySize) return false
        if (sourceIdentity != other.sourceIdentity) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.AssumeRoleResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) and the assumed role ID, which are identifiers that you can use to refer to the resulting temporary security credentials. For example, you can reference these credentials as a principal in a resource-based policy by using the ARN or assumed role ID. The ARN and ID include the `RoleSessionName` that you specified when you called `AssumeRole`.
         */
        public var assumedRoleUser: aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.AssumedRoleUser? = null
        /**
         * The temporary security credentials, which include an access key ID, a secret access key, and a security (or session) token.
         *
         * The size of the security token that STS API operations return is not fixed. We strongly recommend that you make no assumptions about the maximum size.
         */
        public var credentials: aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.Credentials? = null
        /**
         * A percentage value that indicates the packed size of the session policies and session tags combined passed in the request. The request fails if the packed size is greater than 100 percent, which means the policies and tags exceeded the allowed space.
         */
        public var packedPolicySize: kotlin.Int? = null
        /**
         * The source identity specified by the principal that is calling the `AssumeRole` operation.
         *
         * You can require users to specify a source identity when they assume a role. You do this by using the `sts:SourceIdentity` condition key in a role trust policy. You can use source identity information in CloudTrail logs to determine who took actions with a role. You can use the `aws:SourceIdentity` condition key to further control access to Amazon Web Services resources based on the value of source identity. For more information about using source identity, see [Monitor and control actions taken with assumed roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html) in the *IAM User Guide*.
         *
         * The regex used to validate this parameter is a string of characters consisting of upper- and lower-case alphanumeric characters with no spaces. You can also include underscores or any of the following characters: =,.@-
         */
        public var sourceIdentity: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.AssumeRoleResponse) : this() {
            this.assumedRoleUser = x.assumedRoleUser
            this.credentials = x.credentials
            this.packedPolicySize = x.packedPolicySize
            this.sourceIdentity = x.sourceIdentity
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.AssumeRoleResponse = AssumeRoleResponse(this)

        /**
         * construct an [aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.AssumedRoleUser] inside the given [block]
         */
        public fun assumedRoleUser(block: aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.AssumedRoleUser.Builder.() -> kotlin.Unit) {
            this.assumedRoleUser = aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.AssumedRoleUser.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.Credentials] inside the given [block]
         */
        public fun credentials(block: aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.Credentials.Builder.() -> kotlin.Unit) {
            this.credentials = aws.sdk.kotlin.runtime.auth.credentials.internal.sts.model.Credentials.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
