/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.runtime.config.imds;

import aws.sdk.kotlin.runtime.config.imds.EC2MetadataError;
import aws.smithy.kotlin.runtime.http.HttpStatusCode;
import aws.smithy.kotlin.runtime.http.HttpStatusCodeKt;
import aws.smithy.kotlin.runtime.logging.Logger;
import aws.smithy.kotlin.runtime.retries.policy.RetryDirective;
import aws.smithy.kotlin.runtime.retries.policy.RetryErrorType;
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\b\u0000\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0007H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u000b"}, d2={"Laws/sdk/kotlin/runtime/config/imds/ImdsRetryPolicy;", "Laws/smithy/kotlin/runtime/retries/policy/RetryPolicy;", "", "()V", "evaluate", "Laws/smithy/kotlin/runtime/retries/policy/RetryDirective;", "result", "Lkotlin/Result;", "(Ljava/lang/Object;)Laws/smithy/kotlin/runtime/retries/policy/RetryDirective;", "throwable", "", "aws-config"})
@SourceDebugExtension(value={"SMAP\nImdsRetryPolicy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImdsRetryPolicy.kt\naws/sdk/kotlin/runtime/config/imds/ImdsRetryPolicy\n+ 2 Logger.kt\naws/smithy/kotlin/runtime/logging/Logger$Companion\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,38:1\n20#2:39\n1#3:40\n*S KotlinDebug\n*F\n+ 1 ImdsRetryPolicy.kt\naws/sdk/kotlin/runtime/config/imds/ImdsRetryPolicy\n*L\n29#1:39\n29#1:40\n*E\n"})
public final class ImdsRetryPolicy
implements RetryPolicy<Object> {
    @NotNull
    public RetryDirective evaluate(@NotNull Object result) {
        RetryDirective retryDirective;
        if (Result.isSuccess-impl((Object)result)) {
            retryDirective = (RetryDirective)RetryDirective.TerminateAndSucceed.INSTANCE;
        } else {
            Throwable throwable = Result.exceptionOrNull-impl((Object)result);
            Intrinsics.checkNotNull((Object)throwable);
            retryDirective = this.evaluate(throwable);
        }
        return retryDirective;
    }

    private final RetryDirective evaluate(Throwable throwable) {
        RetryDirective retryDirective;
        if (throwable instanceof EC2MetadataError) {
            HttpStatusCode status = HttpStatusCode.Companion.fromValue(((EC2MetadataError)((Object)throwable)).getStatusCode());
            if (HttpStatusCodeKt.category((HttpStatusCode)status) == HttpStatusCode.Category.SERVER_ERROR) {
                retryDirective = (RetryDirective)new RetryDirective.RetryError(RetryErrorType.ServerSide);
            } else if (Intrinsics.areEqual((Object)status, (Object)HttpStatusCode.Companion.getUnauthorized())) {
                retryDirective = (RetryDirective)new RetryDirective.RetryError(RetryErrorType.ServerSide);
            } else {
                Logger.Companion this_$iv = Logger.Companion;
                boolean $i$f$getLogger = false;
                Logger.Companion companion = this_$iv;
                String string = Reflection.getOrCreateKotlinClass(ImdsRetryPolicy.class).getQualifiedName();
                if (string == null) {
                    Logger.Companion companion2 = companion;
                    boolean bl = false;
                    Logger.Companion companion3 = companion2;
                    String string2 = "getLogger<T> cannot be used on an anonymous object";
                    throw new IllegalArgumentException(string2.toString());
                }
                Logger logger = companion.getLogger(string);
                logger.debug((Function0)new Function0<Object>(throwable){
                    final /* synthetic */ Throwable $throwable;
                    {
                        this.$throwable = $throwable;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Non retryable IMDS error: statusCode=" + ((EC2MetadataError)((Object)this.$throwable)).getStatusCode() + "; " + this.$throwable.getMessage();
                    }
                });
                retryDirective = (RetryDirective)RetryDirective.TerminateAndFail.INSTANCE;
            }
        } else {
            retryDirective = (RetryDirective)RetryDirective.TerminateAndFail.INSTANCE;
        }
        return retryDirective;
    }
}

