/*
 * Decompiled with CFR 0.152.
 */
package aws.sdk.kotlin.runtime.auth.credentials;

import aws.sdk.kotlin.runtime.auth.credentials.EcsCredentialsDeserializer;
import aws.sdk.kotlin.runtime.auth.credentials.EcsCredentialsProvider;
import aws.sdk.kotlin.runtime.auth.credentials.EcsCredentialsRetryPolicy;
import aws.sdk.kotlin.runtime.auth.credentials.EcsCredentialsSerializer;
import aws.sdk.kotlin.runtime.auth.credentials.ProviderConfigurationException;
import aws.sdk.kotlin.runtime.config.AwsSdkSetting;
import aws.smithy.kotlin.runtime.auth.awscredentials.CloseableCredentialsProvider;
import aws.smithy.kotlin.runtime.auth.awscredentials.Credentials;
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderException;
import aws.smithy.kotlin.runtime.client.endpoints.Endpoint;
import aws.smithy.kotlin.runtime.config.EnvironmentSettingKt;
import aws.smithy.kotlin.runtime.http.SdkHttpClient;
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngineKt;
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine;
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver;
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize;
import aws.smithy.kotlin.runtime.http.operation.HttpOperationContextKt;
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize;
import aws.smithy.kotlin.runtime.http.operation.ResolveEndpointRequest;
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation;
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperationBuilder;
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperationKt;
import aws.smithy.kotlin.runtime.io.CloseableKt;
import aws.smithy.kotlin.runtime.io.Handler;
import aws.smithy.kotlin.runtime.logging.Logger;
import aws.smithy.kotlin.runtime.net.Scheme;
import aws.smithy.kotlin.runtime.net.Url;
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy;
import aws.smithy.kotlin.runtime.time.Instant;
import aws.smithy.kotlin.runtime.time.TimestampFormat;
import aws.smithy.kotlin.runtime.util.Attributes;
import aws.smithy.kotlin.runtime.util.PlatformEnvironProvider;
import aws.smithy.kotlin.runtime.util.PlatformProvider;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u001b\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0019\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010J\u0019\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0014H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0018"}, d2={"Laws/sdk/kotlin/runtime/auth/credentials/EcsCredentialsProvider;", "Laws/smithy/kotlin/runtime/auth/awscredentials/CloseableCredentialsProvider;", "()V", "platformProvider", "Laws/smithy/kotlin/runtime/util/PlatformEnvironProvider;", "httpClient", "Laws/smithy/kotlin/runtime/http/engine/HttpClientEngine;", "(Laws/smithy/kotlin/runtime/util/PlatformEnvironProvider;Laws/smithy/kotlin/runtime/http/engine/HttpClientEngine;)V", "manageEngine", "", "close", "", "resolve", "Laws/smithy/kotlin/runtime/auth/awscredentials/Credentials;", "attributes", "Laws/smithy/kotlin/runtime/util/Attributes;", "(Laws/smithy/kotlin/runtime/util/Attributes;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "validateFullUri", "Laws/smithy/kotlin/runtime/net/Url;", "uri", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "validateRelativeUri", "relativeUri", "aws-config"})
@SourceDebugExtension(value={"SMAP\nEcsCredentialsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EcsCredentialsProvider.kt\naws/sdk/kotlin/runtime/auth/credentials/EcsCredentialsProvider\n+ 2 HttpOperationContext.kt\naws/smithy/kotlin/runtime/http/operation/HttpOperationContextKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 SdkHttpOperation.kt\naws/smithy/kotlin/runtime/http/operation/SdkHttpOperation$Companion\n+ 5 SdkHttpOperation.kt\naws/smithy/kotlin/runtime/http/operation/SdkHttpOperationKt\n*L\n1#1,230:1\n89#2:231\n1#3:232\n61#4,4:233\n133#5,2:237\n*S KotlinDebug\n*F\n+ 1 EcsCredentialsProvider.kt\naws/sdk/kotlin/runtime/auth/credentials/EcsCredentialsProvider\n*L\n71#1:231\n71#1:232\n82#1:233,4\n85#1:237,2\n*E\n"})
public final class EcsCredentialsProvider
implements CloseableCredentialsProvider {
    @NotNull
    private final PlatformEnvironProvider platformProvider;
    private final boolean manageEngine;
    @NotNull
    private final HttpClientEngine httpClient;

    public EcsCredentialsProvider(@NotNull PlatformEnvironProvider platformProvider, @Nullable HttpClientEngine httpClient) {
        Intrinsics.checkNotNullParameter((Object)platformProvider, (String)"platformProvider");
        this.platformProvider = platformProvider;
        this.manageEngine = httpClient == null;
        HttpClientEngine httpClientEngine = httpClient;
        if (httpClientEngine == null) {
            httpClientEngine = (HttpClientEngine)DefaultHttpEngineKt.DefaultHttpEngine$default(null, (int)1, null);
        }
        this.httpClient = httpClientEngine;
    }

    public /* synthetic */ EcsCredentialsProvider(PlatformEnvironProvider platformEnvironProvider, HttpClientEngine httpClientEngine, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            httpClientEngine = null;
        }
        this(platformEnvironProvider, httpClientEngine);
    }

    public EcsCredentialsProvider() {
        this((PlatformEnvironProvider)PlatformProvider.Companion.getSystem(), null, 2, null);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object resolve(@NotNull Attributes var1_1, @NotNull Continuation<? super Credentials> var2_2) {
        block13: {
            if (!(var2_2 instanceof resolve.1)) ** GOTO lbl-1000
            var19_3 = var2_2;
            if ((var19_3.label & -2147483648) != 0) {
                var19_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var2_2){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    /* synthetic */ Object result;
                    final /* synthetic */ EcsCredentialsProvider this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.resolve(null, (Continuation<? super Credentials>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var20_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $this$getLogger$iv = $continuation.getContext();
                    $i$f$getLogger = false;
                    v0 = $this$getLogger$iv;
                    v1 = Reflection.getOrCreateKotlinClass(EcsCredentialsProvider.class).getQualifiedName();
                    if (v1 == null) {
                        var6_9 = v0;
                        $i$a$-requireNotNull-HttpOperationContextKt$getLogger$1$iv = false;
                        v2 = var6_9;
                        $i$a$-requireNotNull-HttpOperationContextKt$getLogger$1$iv = "getLogger<T> cannot be used on an anonymous object";
                        throw new IllegalArgumentException($i$a$-requireNotNull-HttpOperationContextKt$getLogger$1$iv.toString());
                    }
                    logger = HttpOperationContextKt.getLogger((CoroutineContext)v0, (String)v1);
                    authToken = (String)EnvironmentSettingKt.resolve(AwsSdkSetting.INSTANCE.getAwsContainerAuthorizationToken(), (PlatformEnvironProvider)this.platformProvider);
                    relativeUri = (String)EnvironmentSettingKt.resolve(AwsSdkSetting.INSTANCE.getAwsContainerCredentialsRelativeUri(), (PlatformEnvironProvider)this.platformProvider);
                    fullUri = (String)EnvironmentSettingKt.resolve(AwsSdkSetting.INSTANCE.getAwsContainerCredentialsFullUri(), (PlatformEnvironProvider)this.platformProvider);
                    v3 = relativeUri;
                    v4 = v3 != null ? !StringsKt.isBlank((CharSequence)v3) : false;
                    if (!v4) ** GOTO lbl32
                    v5 = this.validateRelativeUri(relativeUri);
                    break block13;
lbl32:
                    // 1 sources

                    v6 = fullUri;
                    v7 = v6 != null ? !StringsKt.isBlank((CharSequence)v6) : false;
                    if (!v7) break;
                    $continuation.L$0 = this;
                    $continuation.L$1 = logger;
                    $continuation.L$2 = authToken;
                    $continuation.label = 1;
                    v8 = this.validateFullUri(fullUri, (Continuation<? super Url>)$continuation);
                    if (v8 == var20_5) {
                        return var20_5;
                    }
                    ** GOTO lbl49
                }
                case 1: {
                    authToken = (String)$continuation.L$2;
                    logger = (Logger)$continuation.L$1;
                    this = (EcsCredentialsProvider)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v8 = $result;
lbl49:
                    // 2 sources

                    v5 = (Url)v8;
                    break block13;
                }
            }
            throw new ProviderConfigurationException("Container credentials URI not set", null, 2, null);
        }
        url = v5;
        $i$f$build = false;
        $this$resolve_u24lambda_u241 = var11_17 = new SdkHttpOperationBuilder(Reflection.getOrCreateKotlinClass(Unit.class), Reflection.getOrCreateKotlinClass(Credentials.class));
        $i$a$-build-EcsCredentialsProvider$resolve$op$1 = false;
        $this$resolve_u24lambda_u241.setSerializer((HttpSerialize)new EcsCredentialsSerializer(authToken));
        $this$resolve_u24lambda_u241.setDeserializer((HttpDeserialize)new EcsCredentialsDeserializer());
        $this$context$iv = $this$resolve_u24lambda_u241;
        $i$f$context = false;
        $this$resolve_u24lambda_u241_u24lambda_u240 = $this$context$iv.getContext();
        $i$a$-context-EcsCredentialsProvider$resolve$op$1$1 = false;
        $this$resolve_u24lambda_u241_u24lambda_u240.setOperationName("EcsCredentialsProvider");
        $this$resolve_u24lambda_u241.getExecution().setEndpointResolver(new EndpointResolver(url){
            final /* synthetic */ Url $url;
            {
                this.$url = $url;
            }

            @Nullable
            public final Object resolve(@NotNull ResolveEndpointRequest it, @NotNull Continuation<? super Endpoint> $completion) {
                return new Endpoint(this.$url, null, 2, null);
            }
        });
        op = var11_17.build();
        op.getExecution().setRetryPolicy((RetryPolicy)new EcsCredentialsRetryPolicy());
        logger.debug((Function0)resolve.2.INSTANCE);
        client = new SdkHttpClient(this.httpClient);
        $continuation.L$0 = logger;
        $continuation.L$1 = null;
        $continuation.L$2 = null;
        $continuation.label = 2;
        v9 = SdkHttpOperationKt.roundTrip((SdkHttpOperation)op, (Handler)((Handler)client), (Object)Unit.INSTANCE, (Continuation)$continuation);
        ** if (v9 != var20_5) goto lbl82
lbl81:
        // 1 sources

        return var20_5;
lbl82:
        // 1 sources

        ** GOTO lbl89
        {
            case 2: {
                logger = (Logger)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v9 = $result;
lbl89:
                    // 2 sources

                    var11_17 = (Credentials)v9;
                }
                catch (Exception ex) {
                    logger.debug((Function0)resolve.creds.1.INSTANCE);
                    throw ex instanceof CredentialsProviderException != false ? (Throwable)ex : (Throwable)new CredentialsProviderException("Failed to get credentials from container metadata service", (Throwable)ex);
                }
                creds = var11_17;
                logger.debug((Function0)new Function0<Object>(creds){
                    final /* synthetic */ Credentials $creds;
                    {
                        this.$creds = $creds;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        Instant instant = this.$creds.getExpiration();
                        return "obtained credentials from container metadata service; expiration=" + (instant != null ? instant.format(TimestampFormat.ISO_8601) : null);
                    }
                });
                return creds;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Url validateRelativeUri(String relativeUri) {
        Url url;
        try {
            url = Url.Companion.parse("http://169.254.170.2" + relativeUri);
        }
        catch (Exception ex) {
            throw new ProviderConfigurationException("Invalid relativeUri `" + relativeUri + '`', ex);
        }
        return url;
    }

    private final Object validateFullUri(String uri, Continuation<? super Url> $completion) {
        Url url;
        try {
            url = Url.Companion.parse(uri);
        }
        catch (Exception ex) {
            throw new ProviderConfigurationException("Invalid fullUri `" + uri + '`', ex);
        }
        Url url2 = url;
        if (Intrinsics.areEqual((Object)url2.getScheme(), (Object)Scheme.Companion.getHTTPS())) {
            return url2;
        }
        Object[] objectArray = new String[]{"127.0.0.1", "::1"};
        Set allowedHosts = SetsKt.setOf((Object[])objectArray);
        if (!allowedHosts.contains(url2.getHost().toString())) {
            throw new ProviderConfigurationException("The container credentials full URI (" + uri + ") has an invalid host. Host can only be one of [" + CollectionsKt.joinToString$default((Iterable)allowedHosts, null, null, null, (int)0, null, null, (int)63, null) + "].", null, 2, null);
        }
        return url2;
    }

    public void close() {
        if (this.manageEngine) {
            CloseableKt.closeIfCloseable((Object)this.httpClient);
        }
    }

    public static final /* synthetic */ Object access$validateFullUri(EcsCredentialsProvider $this, String uri, Continuation $completion) {
        return $this.validateFullUri(uri, (Continuation<? super Url>)$completion);
    }
}

