// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscalingplans.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.autoscalingplans.model.AutoScalingPlansException
import aws.sdk.kotlin.services.autoscalingplans.model.UpdateScalingPlanResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class UpdateScalingPlanOperationDeserializer: HttpDeserialize<UpdateScalingPlanResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateScalingPlanResponse {
        if (!response.status.isSuccess()) {
            throwUpdateScalingPlanError(context, response)
        }
        val builder = UpdateScalingPlanResponse.builder()

        return builder.build()
    }
}

private suspend fun throwUpdateScalingPlanError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as awsJson1_1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "ConcurrentUpdateException" -> ConcurrentUpdateExceptionDeserializer()
        "InternalServiceException" -> InternalServiceExceptionDeserializer()
        "ObjectNotFoundException" -> ObjectNotFoundExceptionDeserializer()
        "ValidationException" -> ValidationExceptionDeserializer()
        else -> throw AutoScalingPlansException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, response)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
