// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscalingplans.model



/**
 * Describes a target tracking configuration to use with AWS Auto Scaling. Used with ScalingInstruction and ScalingPolicy.
 */
class TargetTrackingConfiguration private constructor(builder: BuilderImpl) {
    /**
     * A customized metric. You can specify either a predefined metric or a customized metric.
     */
    val customizedScalingMetricSpecification: CustomizedScalingMetricSpecification? = builder.customizedScalingMetricSpecification
    /**
     * Indicates whether scale in by the target tracking scaling policy is disabled. If the
     * value is true, scale in is disabled and the target tracking scaling policy
     * doesn't remove capacity from the scalable resource. Otherwise, scale in is enabled and the
     * target tracking scaling policy can remove capacity from the scalable resource.
     * The default value is false.
     */
    val disableScaleIn: Boolean? = builder.disableScaleIn
    /**
     * The estimated time, in seconds, until a newly launched instance can contribute to the
     * CloudWatch metrics. This value is used only if the resource is an Auto Scaling group.
     */
    val estimatedInstanceWarmup: Int? = builder.estimatedInstanceWarmup
    /**
     * A predefined metric. You can specify either a predefined metric or a customized
     * metric.
     */
    val predefinedScalingMetricSpecification: PredefinedScalingMetricSpecification? = builder.predefinedScalingMetricSpecification
    /**
     * The amount of time, in seconds, after a scale-in activity completes before another
     * scale-in activity can start. This property is not used if the scalable resource is an Auto Scaling
     * group.
     * With the scale-in cooldown period, the intention is to scale in
     * conservatively to protect your application’s availability, so scale-in activities are blocked
     * until the cooldown period has expired. However, if another alarm triggers a scale-out activity
     * during the scale-in cooldown period, Auto Scaling scales out the target immediately. In this case,
     * the scale-in cooldown period stops and doesn't complete.
     */
    val scaleInCooldown: Int? = builder.scaleInCooldown
    /**
     * The amount of time, in seconds, to wait for a previous scale-out activity to take
     * effect. This property is not used if the scalable resource is an Auto Scaling
     * group.
     * With the scale-out cooldown period, the intention is to continuously
     * (but not excessively) scale out. After Auto Scaling successfully scales out using a target
     * tracking scaling policy, it starts to calculate the cooldown time. The scaling policy won't
     * increase the desired capacity again unless either a larger scale out is triggered or the
     * cooldown period ends.
     */
    val scaleOutCooldown: Int? = builder.scaleOutCooldown
    /**
     * The target value for the metric. Although this property accepts numbers of type Double,
     * it won't accept values that are either too small or too large. Values must be in the range
     * of -2^360 to 2^360.
     */
    val targetValue: Double? = builder.targetValue

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): TargetTrackingConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("TargetTrackingConfiguration(")
        append("customizedScalingMetricSpecification=$customizedScalingMetricSpecification,")
        append("disableScaleIn=$disableScaleIn,")
        append("estimatedInstanceWarmup=$estimatedInstanceWarmup,")
        append("predefinedScalingMetricSpecification=$predefinedScalingMetricSpecification,")
        append("scaleInCooldown=$scaleInCooldown,")
        append("scaleOutCooldown=$scaleOutCooldown,")
        append("targetValue=$targetValue)")
    }

    override fun hashCode(): kotlin.Int {
        var result = customizedScalingMetricSpecification?.hashCode() ?: 0
        result = 31 * result + (disableScaleIn?.hashCode() ?: 0)
        result = 31 * result + (estimatedInstanceWarmup ?: 0)
        result = 31 * result + (predefinedScalingMetricSpecification?.hashCode() ?: 0)
        result = 31 * result + (scaleInCooldown ?: 0)
        result = 31 * result + (scaleOutCooldown ?: 0)
        result = 31 * result + (targetValue?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as TargetTrackingConfiguration

        if (customizedScalingMetricSpecification != other.customizedScalingMetricSpecification) return false
        if (disableScaleIn != other.disableScaleIn) return false
        if (estimatedInstanceWarmup != other.estimatedInstanceWarmup) return false
        if (predefinedScalingMetricSpecification != other.predefinedScalingMetricSpecification) return false
        if (scaleInCooldown != other.scaleInCooldown) return false
        if (scaleOutCooldown != other.scaleOutCooldown) return false
        if (targetValue != other.targetValue) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): TargetTrackingConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): TargetTrackingConfiguration
        /**
         * A customized metric. You can specify either a predefined metric or a customized metric.
         */
        fun customizedScalingMetricSpecification(customizedScalingMetricSpecification: CustomizedScalingMetricSpecification): FluentBuilder
        /**
         * Indicates whether scale in by the target tracking scaling policy is disabled. If the
         * value is true, scale in is disabled and the target tracking scaling policy
         * doesn't remove capacity from the scalable resource. Otherwise, scale in is enabled and the
         * target tracking scaling policy can remove capacity from the scalable resource.
         * The default value is false.
         */
        fun disableScaleIn(disableScaleIn: Boolean): FluentBuilder
        /**
         * The estimated time, in seconds, until a newly launched instance can contribute to the
         * CloudWatch metrics. This value is used only if the resource is an Auto Scaling group.
         */
        fun estimatedInstanceWarmup(estimatedInstanceWarmup: Int): FluentBuilder
        /**
         * A predefined metric. You can specify either a predefined metric or a customized
         * metric.
         */
        fun predefinedScalingMetricSpecification(predefinedScalingMetricSpecification: PredefinedScalingMetricSpecification): FluentBuilder
        /**
         * The amount of time, in seconds, after a scale-in activity completes before another
         * scale-in activity can start. This property is not used if the scalable resource is an Auto Scaling
         * group.
         * With the scale-in cooldown period, the intention is to scale in
         * conservatively to protect your application’s availability, so scale-in activities are blocked
         * until the cooldown period has expired. However, if another alarm triggers a scale-out activity
         * during the scale-in cooldown period, Auto Scaling scales out the target immediately. In this case,
         * the scale-in cooldown period stops and doesn't complete.
         */
        fun scaleInCooldown(scaleInCooldown: Int): FluentBuilder
        /**
         * The amount of time, in seconds, to wait for a previous scale-out activity to take
         * effect. This property is not used if the scalable resource is an Auto Scaling
         * group.
         * With the scale-out cooldown period, the intention is to continuously
         * (but not excessively) scale out. After Auto Scaling successfully scales out using a target
         * tracking scaling policy, it starts to calculate the cooldown time. The scaling policy won't
         * increase the desired capacity again unless either a larger scale out is triggered or the
         * cooldown period ends.
         */
        fun scaleOutCooldown(scaleOutCooldown: Int): FluentBuilder
        /**
         * The target value for the metric. Although this property accepts numbers of type Double,
         * it won't accept values that are either too small or too large. Values must be in the range
         * of -2^360 to 2^360.
         */
        fun targetValue(targetValue: Double): FluentBuilder
    }

    interface DslBuilder {
        /**
         * A customized metric. You can specify either a predefined metric or a customized metric.
         */
        var customizedScalingMetricSpecification: CustomizedScalingMetricSpecification?
        /**
         * Indicates whether scale in by the target tracking scaling policy is disabled. If the
         * value is true, scale in is disabled and the target tracking scaling policy
         * doesn't remove capacity from the scalable resource. Otherwise, scale in is enabled and the
         * target tracking scaling policy can remove capacity from the scalable resource.
         * The default value is false.
         */
        var disableScaleIn: Boolean?
        /**
         * The estimated time, in seconds, until a newly launched instance can contribute to the
         * CloudWatch metrics. This value is used only if the resource is an Auto Scaling group.
         */
        var estimatedInstanceWarmup: Int?
        /**
         * A predefined metric. You can specify either a predefined metric or a customized
         * metric.
         */
        var predefinedScalingMetricSpecification: PredefinedScalingMetricSpecification?
        /**
         * The amount of time, in seconds, after a scale-in activity completes before another
         * scale-in activity can start. This property is not used if the scalable resource is an Auto Scaling
         * group.
         * With the scale-in cooldown period, the intention is to scale in
         * conservatively to protect your application’s availability, so scale-in activities are blocked
         * until the cooldown period has expired. However, if another alarm triggers a scale-out activity
         * during the scale-in cooldown period, Auto Scaling scales out the target immediately. In this case,
         * the scale-in cooldown period stops and doesn't complete.
         */
        var scaleInCooldown: Int?
        /**
         * The amount of time, in seconds, to wait for a previous scale-out activity to take
         * effect. This property is not used if the scalable resource is an Auto Scaling
         * group.
         * With the scale-out cooldown period, the intention is to continuously
         * (but not excessively) scale out. After Auto Scaling successfully scales out using a target
         * tracking scaling policy, it starts to calculate the cooldown time. The scaling policy won't
         * increase the desired capacity again unless either a larger scale out is triggered or the
         * cooldown period ends.
         */
        var scaleOutCooldown: Int?
        /**
         * The target value for the metric. Although this property accepts numbers of type Double,
         * it won't accept values that are either too small or too large. Values must be in the range
         * of -2^360 to 2^360.
         */
        var targetValue: Double?

        fun build(): TargetTrackingConfiguration
        /**
         * construct an [aws.sdk.kotlin.services.autoscalingplans.model.CustomizedScalingMetricSpecification] inside the given [block]
         */
        fun customizedScalingMetricSpecification(block: CustomizedScalingMetricSpecification.DslBuilder.() -> kotlin.Unit) {
            this.customizedScalingMetricSpecification = CustomizedScalingMetricSpecification.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.autoscalingplans.model.PredefinedScalingMetricSpecification] inside the given [block]
         */
        fun predefinedScalingMetricSpecification(block: PredefinedScalingMetricSpecification.DslBuilder.() -> kotlin.Unit) {
            this.predefinedScalingMetricSpecification = PredefinedScalingMetricSpecification.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var customizedScalingMetricSpecification: CustomizedScalingMetricSpecification? = null
        override var disableScaleIn: Boolean? = null
        override var estimatedInstanceWarmup: Int? = null
        override var predefinedScalingMetricSpecification: PredefinedScalingMetricSpecification? = null
        override var scaleInCooldown: Int? = null
        override var scaleOutCooldown: Int? = null
        override var targetValue: Double? = null

        constructor(x: TargetTrackingConfiguration) : this() {
            this.customizedScalingMetricSpecification = x.customizedScalingMetricSpecification
            this.disableScaleIn = x.disableScaleIn
            this.estimatedInstanceWarmup = x.estimatedInstanceWarmup
            this.predefinedScalingMetricSpecification = x.predefinedScalingMetricSpecification
            this.scaleInCooldown = x.scaleInCooldown
            this.scaleOutCooldown = x.scaleOutCooldown
            this.targetValue = x.targetValue
        }

        override fun build(): TargetTrackingConfiguration = TargetTrackingConfiguration(this)
        override fun customizedScalingMetricSpecification(customizedScalingMetricSpecification: CustomizedScalingMetricSpecification): FluentBuilder = apply { this.customizedScalingMetricSpecification = customizedScalingMetricSpecification }
        override fun disableScaleIn(disableScaleIn: Boolean): FluentBuilder = apply { this.disableScaleIn = disableScaleIn }
        override fun estimatedInstanceWarmup(estimatedInstanceWarmup: Int): FluentBuilder = apply { this.estimatedInstanceWarmup = estimatedInstanceWarmup }
        override fun predefinedScalingMetricSpecification(predefinedScalingMetricSpecification: PredefinedScalingMetricSpecification): FluentBuilder = apply { this.predefinedScalingMetricSpecification = predefinedScalingMetricSpecification }
        override fun scaleInCooldown(scaleInCooldown: Int): FluentBuilder = apply { this.scaleInCooldown = scaleInCooldown }
        override fun scaleOutCooldown(scaleOutCooldown: Int): FluentBuilder = apply { this.scaleOutCooldown = scaleOutCooldown }
        override fun targetValue(targetValue: Double): FluentBuilder = apply { this.targetValue = targetValue }
    }
}
