// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.autoscalingplans.model



/**
 * Represents a scalable resource.
 */
class ScalingPlanResource private constructor(builder: BuilderImpl) {
    /**
     * The ID of the resource. This string consists of the resource type and unique
     * identifier.
     * Auto Scaling group - The resource type is autoScalingGroup and the unique identifier is the
     * name of the Auto Scaling group. Example: autoScalingGroup/my-asg.
     * ECS service - The resource type is service and the unique identifier is the cluster name
     * and service name. Example: service/default/sample-webapp.
     * Spot Fleet request - The resource type is spot-fleet-request and the unique identifier is the
     * Spot Fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
     * DynamoDB table - The resource type is table and the unique identifier is the resource ID.
     * Example: table/my-table.
     * DynamoDB global secondary index - The resource type is index and the unique identifier is the resource ID.
     * Example: table/my-table/index/my-table-index.
     * Aurora DB cluster - The resource type is cluster and the unique identifier is the cluster name.
     * Example: cluster:my-db-cluster.
     */
    val resourceId: String? = builder.resourceId
    /**
     * The scalable dimension for the resource.
     * autoscaling:autoScalingGroup:DesiredCapacity - The desired capacity of an Auto Scaling group.
     * ecs:service:DesiredCount - The desired task count of an ECS service.
     * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot Fleet request.
     * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for a DynamoDB table.
     * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for a DynamoDB table.
     * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for a DynamoDB global secondary index.
     * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for a DynamoDB global secondary index.
     * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
     */
    val scalableDimension: ScalableDimension? = builder.scalableDimension
    /**
     * The name of the scaling plan.
     */
    val scalingPlanName: String? = builder.scalingPlanName
    /**
     * The version number of the scaling plan.
     */
    val scalingPlanVersion: Long? = builder.scalingPlanVersion
    /**
     * The scaling policies.
     */
    val scalingPolicies: List<ScalingPolicy>? = builder.scalingPolicies
    /**
     * The scaling status of the resource.
     * Active - The scaling configuration is active.
     * Inactive - The scaling configuration is not active because the
     * scaling plan is being created or the scaling configuration could not be applied.
     * Check the status message for more information.
     * PartiallyActive - The scaling configuration is partially active
     * because the scaling plan is being created or deleted or the scaling configuration
     * could not be fully applied. Check the status message for more information.
     */
    val scalingStatusCode: ScalingStatusCode? = builder.scalingStatusCode
    /**
     * A simple message about the current scaling status of the resource.
     */
    val scalingStatusMessage: String? = builder.scalingStatusMessage
    /**
     * The namespace of the AWS service.
     */
    val serviceNamespace: ServiceNamespace? = builder.serviceNamespace

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ScalingPlanResource = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ScalingPlanResource(")
        append("resourceId=$resourceId,")
        append("scalableDimension=$scalableDimension,")
        append("scalingPlanName=$scalingPlanName,")
        append("scalingPlanVersion=$scalingPlanVersion,")
        append("scalingPolicies=$scalingPolicies,")
        append("scalingStatusCode=$scalingStatusCode,")
        append("scalingStatusMessage=$scalingStatusMessage,")
        append("serviceNamespace=$serviceNamespace)")
    }

    override fun hashCode(): kotlin.Int {
        var result = resourceId?.hashCode() ?: 0
        result = 31 * result + (scalableDimension?.hashCode() ?: 0)
        result = 31 * result + (scalingPlanName?.hashCode() ?: 0)
        result = 31 * result + (scalingPlanVersion?.hashCode() ?: 0)
        result = 31 * result + (scalingPolicies?.hashCode() ?: 0)
        result = 31 * result + (scalingStatusCode?.hashCode() ?: 0)
        result = 31 * result + (scalingStatusMessage?.hashCode() ?: 0)
        result = 31 * result + (serviceNamespace?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ScalingPlanResource

        if (resourceId != other.resourceId) return false
        if (scalableDimension != other.scalableDimension) return false
        if (scalingPlanName != other.scalingPlanName) return false
        if (scalingPlanVersion != other.scalingPlanVersion) return false
        if (scalingPolicies != other.scalingPolicies) return false
        if (scalingStatusCode != other.scalingStatusCode) return false
        if (scalingStatusMessage != other.scalingStatusMessage) return false
        if (serviceNamespace != other.serviceNamespace) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ScalingPlanResource = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ScalingPlanResource
        /**
         * The ID of the resource. This string consists of the resource type and unique
         * identifier.
         * Auto Scaling group - The resource type is autoScalingGroup and the unique identifier is the
         * name of the Auto Scaling group. Example: autoScalingGroup/my-asg.
         * ECS service - The resource type is service and the unique identifier is the cluster name
         * and service name. Example: service/default/sample-webapp.
         * Spot Fleet request - The resource type is spot-fleet-request and the unique identifier is the
         * Spot Fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
         * DynamoDB table - The resource type is table and the unique identifier is the resource ID.
         * Example: table/my-table.
         * DynamoDB global secondary index - The resource type is index and the unique identifier is the resource ID.
         * Example: table/my-table/index/my-table-index.
         * Aurora DB cluster - The resource type is cluster and the unique identifier is the cluster name.
         * Example: cluster:my-db-cluster.
         */
        fun resourceId(resourceId: String): FluentBuilder
        /**
         * The scalable dimension for the resource.
         * autoscaling:autoScalingGroup:DesiredCapacity - The desired capacity of an Auto Scaling group.
         * ecs:service:DesiredCount - The desired task count of an ECS service.
         * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot Fleet request.
         * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for a DynamoDB table.
         * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for a DynamoDB table.
         * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for a DynamoDB global secondary index.
         * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for a DynamoDB global secondary index.
         * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
         */
        fun scalableDimension(scalableDimension: ScalableDimension): FluentBuilder
        /**
         * The name of the scaling plan.
         */
        fun scalingPlanName(scalingPlanName: String): FluentBuilder
        /**
         * The version number of the scaling plan.
         */
        fun scalingPlanVersion(scalingPlanVersion: Long): FluentBuilder
        /**
         * The scaling policies.
         */
        fun scalingPolicies(scalingPolicies: List<ScalingPolicy>): FluentBuilder
        /**
         * The scaling status of the resource.
         * Active - The scaling configuration is active.
         * Inactive - The scaling configuration is not active because the
         * scaling plan is being created or the scaling configuration could not be applied.
         * Check the status message for more information.
         * PartiallyActive - The scaling configuration is partially active
         * because the scaling plan is being created or deleted or the scaling configuration
         * could not be fully applied. Check the status message for more information.
         */
        fun scalingStatusCode(scalingStatusCode: ScalingStatusCode): FluentBuilder
        /**
         * A simple message about the current scaling status of the resource.
         */
        fun scalingStatusMessage(scalingStatusMessage: String): FluentBuilder
        /**
         * The namespace of the AWS service.
         */
        fun serviceNamespace(serviceNamespace: ServiceNamespace): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The ID of the resource. This string consists of the resource type and unique
         * identifier.
         * Auto Scaling group - The resource type is autoScalingGroup and the unique identifier is the
         * name of the Auto Scaling group. Example: autoScalingGroup/my-asg.
         * ECS service - The resource type is service and the unique identifier is the cluster name
         * and service name. Example: service/default/sample-webapp.
         * Spot Fleet request - The resource type is spot-fleet-request and the unique identifier is the
         * Spot Fleet request ID. Example: spot-fleet-request/sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE.
         * DynamoDB table - The resource type is table and the unique identifier is the resource ID.
         * Example: table/my-table.
         * DynamoDB global secondary index - The resource type is index and the unique identifier is the resource ID.
         * Example: table/my-table/index/my-table-index.
         * Aurora DB cluster - The resource type is cluster and the unique identifier is the cluster name.
         * Example: cluster:my-db-cluster.
         */
        var resourceId: String?
        /**
         * The scalable dimension for the resource.
         * autoscaling:autoScalingGroup:DesiredCapacity - The desired capacity of an Auto Scaling group.
         * ecs:service:DesiredCount - The desired task count of an ECS service.
         * ec2:spot-fleet-request:TargetCapacity - The target capacity of a Spot Fleet request.
         * dynamodb:table:ReadCapacityUnits - The provisioned read capacity for a DynamoDB table.
         * dynamodb:table:WriteCapacityUnits - The provisioned write capacity for a DynamoDB table.
         * dynamodb:index:ReadCapacityUnits - The provisioned read capacity for a DynamoDB global secondary index.
         * dynamodb:index:WriteCapacityUnits - The provisioned write capacity for a DynamoDB global secondary index.
         * rds:cluster:ReadReplicaCount - The count of Aurora Replicas in an Aurora DB cluster. Available for Aurora MySQL-compatible edition and Aurora PostgreSQL-compatible edition.
         */
        var scalableDimension: ScalableDimension?
        /**
         * The name of the scaling plan.
         */
        var scalingPlanName: String?
        /**
         * The version number of the scaling plan.
         */
        var scalingPlanVersion: Long?
        /**
         * The scaling policies.
         */
        var scalingPolicies: List<ScalingPolicy>?
        /**
         * The scaling status of the resource.
         * Active - The scaling configuration is active.
         * Inactive - The scaling configuration is not active because the
         * scaling plan is being created or the scaling configuration could not be applied.
         * Check the status message for more information.
         * PartiallyActive - The scaling configuration is partially active
         * because the scaling plan is being created or deleted or the scaling configuration
         * could not be fully applied. Check the status message for more information.
         */
        var scalingStatusCode: ScalingStatusCode?
        /**
         * A simple message about the current scaling status of the resource.
         */
        var scalingStatusMessage: String?
        /**
         * The namespace of the AWS service.
         */
        var serviceNamespace: ServiceNamespace?

        fun build(): ScalingPlanResource
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var resourceId: String? = null
        override var scalableDimension: ScalableDimension? = null
        override var scalingPlanName: String? = null
        override var scalingPlanVersion: Long? = null
        override var scalingPolicies: List<ScalingPolicy>? = null
        override var scalingStatusCode: ScalingStatusCode? = null
        override var scalingStatusMessage: String? = null
        override var serviceNamespace: ServiceNamespace? = null

        constructor(x: ScalingPlanResource) : this() {
            this.resourceId = x.resourceId
            this.scalableDimension = x.scalableDimension
            this.scalingPlanName = x.scalingPlanName
            this.scalingPlanVersion = x.scalingPlanVersion
            this.scalingPolicies = x.scalingPolicies
            this.scalingStatusCode = x.scalingStatusCode
            this.scalingStatusMessage = x.scalingStatusMessage
            this.serviceNamespace = x.serviceNamespace
        }

        override fun build(): ScalingPlanResource = ScalingPlanResource(this)
        override fun resourceId(resourceId: String): FluentBuilder = apply { this.resourceId = resourceId }
        override fun scalableDimension(scalableDimension: ScalableDimension): FluentBuilder = apply { this.scalableDimension = scalableDimension }
        override fun scalingPlanName(scalingPlanName: String): FluentBuilder = apply { this.scalingPlanName = scalingPlanName }
        override fun scalingPlanVersion(scalingPlanVersion: Long): FluentBuilder = apply { this.scalingPlanVersion = scalingPlanVersion }
        override fun scalingPolicies(scalingPolicies: List<ScalingPolicy>): FluentBuilder = apply { this.scalingPolicies = scalingPolicies }
        override fun scalingStatusCode(scalingStatusCode: ScalingStatusCode): FluentBuilder = apply { this.scalingStatusCode = scalingStatusCode }
        override fun scalingStatusMessage(scalingStatusMessage: String): FluentBuilder = apply { this.scalingStatusMessage = scalingStatusMessage }
        override fun serviceNamespace(serviceNamespace: ServiceNamespace): FluentBuilder = apply { this.serviceNamespace = serviceNamespace }
    }
}
